/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.geosparql;

import com.ontotext.trree.geosparql.EntityGeometryIterator;
import com.ontotext.trree.geosparql.GeoSparqlFunction;
import com.ontotext.trree.geosparql.GeoSparqlPlugin;
import com.ontotext.trree.geosparql.SingleEntityGeometryIterator;
import com.ontotext.trree.geosparql.lucene.LuceneMultiSearchEntityGeometryIterator;
import com.ontotext.trree.sdk.Entities;
import com.ontotext.trree.sdk.StatementIterator;
import com.useekm.indexing.GeoConstants;
import java.io.IOException;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.locationtech.jts.geom.Geometry;
import org.slf4j.Logger;

class GeoSparqlRelationIterator
extends StatementIterator {
    private final GeoSparqlPlugin parent;
    private final Logger logger;
    private final GeoSparqlFunction function;
    private final Entities entities;
    private Geometry knownGeometry;
    private EntityGeometryIterator iKnownEntities;
    private EntityGeometryIterator iCandidateEntities;
    private EntityGeometryIterator iSubjectGeometries;
    private EntityGeometryIterator iObjectGeometries;
    private LuceneMultiSearchEntityGeometryIterator searchIterator;
    private boolean trustLucene;
    private boolean inverse;

    GeoSparqlRelationIterator(GeoSparqlPlugin parent, GeoSparqlFunction function, long subject, long predicate, long object, Entities entities) {
        this.parent = parent;
        this.logger = parent.getLogger();
        this.function = function;
        this.subject = subject;
        this.predicate = predicate;
        this.object = object;
        this.entities = entities;
        if (subject != 0L) {
            this.iSubjectGeometries = this.makeIteratorFromEntityId(subject);
        }
        if (object != 0L) {
            this.iObjectGeometries = this.makeIteratorFromEntityId(object);
        }
        if (this.iSubjectGeometries != null && this.iObjectGeometries != null) {
            this.iKnownEntities = this.iObjectGeometries;
            this.iCandidateEntities = this.iSubjectGeometries;
            this.inverse = true;
        } else if (this.iSubjectGeometries == null) {
            this.iKnownEntities = this.iObjectGeometries;
            this.searchIterator = new LuceneMultiSearchEntityGeometryIterator(parent.indexer, function.getSpatialOperation());
            this.iCandidateEntities = this.searchIterator;
            this.inverse = true;
        } else {
            this.iKnownEntities = this.iSubjectGeometries;
            this.searchIterator = new LuceneMultiSearchEntityGeometryIterator(parent.indexer, function.getInverseSpatialOperation());
            this.iCandidateEntities = this.searchIterator;
            this.inverse = false;
        }
    }

    public boolean next() {
        boolean result;
        block9: {
            Geometry candidateGeometry;
            result = false;
            do {
                if (this.knownGeometry == null || !this.iCandidateEntities.hasNextGeometry()) {
                    if (!this.iKnownEntities.hasNextGeometry()) break block9;
                    this.knownGeometry = this.iKnownEntities.nextGeometry();
                    if (this.searchIterator != null) {
                        this.searchIterator.search(this.knownGeometry);
                    }
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("KNOWN GEOMETRY: {}; {}", (Object)this.entities.get(this.iKnownEntities.getEntityForLastGeometry()), (Object)this.knownGeometry);
                    }
                }
                if ((candidateGeometry = this.iCandidateEntities.nextGeometry()) == null) {
                    this.logger.debug(">>>>>>>> GeoSPARQL: No available candidate geometries matching the query!");
                    break block9;
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("CANDIDATE: {}; {}", (Object)this.entities.get(this.iCandidateEntities.getEntityForLastGeometry()), (Object)candidateGeometry);
                }
                result = this.trustLucene || (this.inverse ? this.function.evaluate(candidateGeometry, this.knownGeometry) : this.function.evaluate(this.knownGeometry, candidateGeometry));
            } while (!result);
            this.iKnownEntities.advanceToNextEntity();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("MATCH: {} -> {}", (Object)this.knownGeometry, (Object)candidateGeometry);
            }
            if (this.inverse) {
                this.subject = this.iCandidateEntities.getEntityForLastGeometry();
                this.object = this.iKnownEntities.getEntityForLastGeometry();
            } else {
                this.subject = this.iKnownEntities.getEntityForLastGeometry();
                this.object = this.iCandidateEntities.getEntityForLastGeometry();
            }
        }
        return result;
    }

    public void close() {
        try {
            this.iKnownEntities.close();
        }
        catch (IOException e) {
            this.logger.warn("Unable to close entity-geometry iterator.", (Throwable)e);
        }
        try {
            this.iCandidateEntities.close();
        }
        catch (IOException e) {
            this.logger.warn("Unable to close entity-geometry iterator.", (Throwable)e);
        }
    }

    private EntityGeometryIterator makeIteratorFromEntityId(long entityId) {
        EntityGeometryIterator iterator;
        Value value = this.entities.get(entityId);
        if (value instanceof Literal) {
            IRI subjType = ((Literal)value).getDatatype();
            Geometry g = GeoConstants.GEO_GML_LITERAL.equals((Object)subjType) ? this.parent.getGeometryFromString(value.stringValue(), this.parent.asGML) : this.parent.getGeometryFromString(value.stringValue(), this.parent.asWKT);
            iterator = new SingleEntityGeometryIterator(entityId, g);
        } else {
            iterator = this.parent.indexer.getGeometriesFor(entityId);
        }
        return iterator;
    }
}

