/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.geosparql;

import com.google.common.annotations.VisibleForTesting;
import com.ontotext.trree.geosparql.FunctionLoader;
import com.ontotext.trree.geosparql.GeoSparqlConfig;
import com.ontotext.trree.geosparql.GeoSparqlConfigIterator;
import com.ontotext.trree.geosparql.GeoSparqlForceReindexer;
import com.ontotext.trree.geosparql.GeoSparqlFunction;
import com.ontotext.trree.geosparql.GeoSparqlIndexer;
import com.ontotext.trree.geosparql.GeoSparqlRelationIterator;
import com.ontotext.trree.geosparql.GeoSparqlUpdateListener;
import com.ontotext.trree.geosparql.gml.GmlConverter;
import com.ontotext.trree.geosparql.lucene.LuceneGeoIndexer;
import com.ontotext.trree.geosparql.util.GeoSparqlUtils;
import com.ontotext.trree.sdk.Entities;
import com.ontotext.trree.sdk.InitReason;
import com.ontotext.trree.sdk.ParallelTransactionListener;
import com.ontotext.trree.sdk.PatternInterpreter;
import com.ontotext.trree.sdk.PluginBase;
import com.ontotext.trree.sdk.PluginConnection;
import com.ontotext.trree.sdk.PluginException;
import com.ontotext.trree.sdk.RequestContext;
import com.ontotext.trree.sdk.StatementIterator;
import com.ontotext.trree.sdk.StatementListener;
import com.ontotext.trree.sdk.UpdateInterpreter;
import com.useekm.indexing.GeoConstants;
import com.useekm.types.GeoConvert;
import com.useekm.types.exception.InvalidGeometryException;
import gnu.trove.TLongObjectHashMap;
import jakarta.xml.bind.JAXBException;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.datatypes.XMLDatatypeUtil;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.locationtech.jts.geom.Geometry;

public class GeoSparqlPlugin
extends PluginBase
implements PatternInterpreter,
UpdateInterpreter,
ParallelTransactionListener,
StatementListener {
    static final ValueFactory VALUE_FACTORY = SimpleValueFactory.getInstance();
    private static final String NS = "http://www.ontotext.com/plugins/geosparql#";
    static final IRI CONTEXT_IRI = VALUE_FACTORY.createIRI("http://www.ontotext.com/plugins/geosparql#".substring(0, "http://www.ontotext.com/plugins/geosparql#".length() - 1));
    static final IRI FORCE_REINDEX_PREDICATE_IRI = VALUE_FACTORY.createIRI("http://www.ontotext.com/plugins/geosparql#", "forceReindex");
    static final IRI ENABLED_PREDICATE_IRI = VALUE_FACTORY.createIRI("http://www.ontotext.com/plugins/geosparql#", "enabled");
    static final IRI PREFIXTREE_PREDICATE_IRI = VALUE_FACTORY.createIRI("http://www.ontotext.com/plugins/geosparql#", "prefixTree");
    static final IRI PRECISION_PREDICATE_IRI = VALUE_FACTORY.createIRI("http://www.ontotext.com/plugins/geosparql#", "precision");
    static final IRI CURRENT_PREFIXTREE_PREDICATE_IRI = VALUE_FACTORY.createIRI("http://www.ontotext.com/plugins/geosparql#", "currentPrefixTree");
    static final IRI CURRENT_PRECISION_PREDICATE_IRI = VALUE_FACTORY.createIRI("http://www.ontotext.com/plugins/geosparql#", "currentPrecision");
    static final IRI IGNORE_ERRORS_PREDICATE_IRI = VALUE_FACTORY.createIRI("http://www.ontotext.com/plugins/geosparql#", "ignoreErrors");
    static final IRI MAX_BUFFERED_DOCS_PREDICATE_IRI = VALUE_FACTORY.createIRI("http://www.ontotext.com/plugins/geosparql#", "maxBufferedDocs");
    static final IRI RAM_BUFFER_SIZE_MB_PREDICATE_IRI = VALUE_FACTORY.createIRI("http://www.ontotext.com/plugins/geosparql#", "ramBufferSizeMB");
    private GeoSparqlConfig config;
    private long forceReindexPredicateId;
    long contextId;
    long enabledPredicateId;
    long prefixTreePredicateId;
    long precisionPredicateId;
    long currentPrefixTreePredicateId;
    long currentPrecisionPredicateId;
    long ignoreErrorsPredicateId;
    long maxBufferedDocsPredicateId;
    long ramBufferSizePredicateId;
    long asWKT;
    long asGML;
    long hasDefaultGeometry;
    GeoSparqlIndexer indexer;
    GeoSparqlConfig.PrefixTree tmpPrefixTree;
    int tmpPrecision;
    private TLongObjectHashMap<GeoSparqlFunction> predicateIds2Function = new TLongObjectHashMap(GeoSparqlFunction.values().length);
    private GmlConverter gmlConverter;
    private GeoSparqlUpdateListener updateListener;

    public String getName() {
        return "GeoSPARQL";
    }

    public void initialize(InitReason reason, PluginConnection pluginConnection) {
        GeoSparqlUtils.migrateConfig(this.getDataDir().toPath(), this.getLogger());
        this.config = GeoSparqlUtils.readConfig(this.getDataDir().toPath());
        this.initControlPredicates(pluginConnection.getEntities());
        this.initPluginFeatures(pluginConnection.getEntities());
        this.updateListener = new GeoSparqlUpdateListener(this, this.asWKT, this.asGML, this.hasDefaultGeometry);
    }

    public double estimate(long subject, long predicate, long object, long context, PluginConnection pluginConnection, RequestContext requestContext) {
        if ((subject != 0L || object != 0L) && this.predicateIds2Function.contains(predicate)) {
            return 0.1;
        }
        if (subject == this.contextId || predicate == this.enabledPredicateId || predicate == this.prefixTreePredicateId || predicate == this.precisionPredicateId || predicate == this.currentPrefixTreePredicateId || predicate == this.currentPrecisionPredicateId || predicate == this.maxBufferedDocsPredicateId || predicate == this.ramBufferSizePredicateId) {
            return 0.1;
        }
        return Double.POSITIVE_INFINITY;
    }

    public StatementIterator interpret(long subject, long predicate, long object, long context, PluginConnection pluginConnection, RequestContext requestContext) {
        if (subject == this.contextId) {
            return new GeoSparqlConfigIterator(this, predicate, object, pluginConnection.getEntities());
        }
        if (predicate == this.enabledPredicateId || predicate == this.prefixTreePredicateId || predicate == this.precisionPredicateId || predicate == this.currentPrefixTreePredicateId || predicate == this.currentPrecisionPredicateId || predicate == this.maxBufferedDocsPredicateId || predicate == this.ramBufferSizePredicateId) {
            return new GeoSparqlConfigIterator(this, predicate, pluginConnection.getEntities());
        }
        if (!this.config.isEnabled()) {
            return null;
        }
        if (this.predicateIds2Function.contains(predicate)) {
            if (subject == 0L && object == 0L) {
                return StatementIterator.EMPTY;
            }
            return new GeoSparqlRelationIterator(this, (GeoSparqlFunction)((Object)this.predicateIds2Function.get(predicate)), subject, predicate, object, pluginConnection.getEntities());
        }
        return null;
    }

    public long[] getPredicatesToListenFor() {
        return new long[]{this.forceReindexPredicateId, this.enabledPredicateId, this.prefixTreePredicateId, this.precisionPredicateId, this.ignoreErrorsPredicateId, this.maxBufferedDocsPredicateId, this.ramBufferSizePredicateId};
    }

    public boolean interpretUpdate(long subject, long predicate, long object, long context, boolean isAddition, boolean isExplicit, PluginConnection pluginConnection) {
        if (predicate == this.forceReindexPredicateId && this.config.isEnabled()) {
            this.indexAllData(true, pluginConnection);
        } else if (predicate == this.enabledPredicateId) {
            boolean wasPluginEnabled = this.config.isEnabled();
            String pluginEnabledStringLiteral = pluginConnection.getEntities().get(object).stringValue();
            this.config.setEnabled(XMLDatatypeUtil.parseBoolean((String)pluginEnabledStringLiteral));
            if (this.config.isEnabled() != wasPluginEnabled) {
                GeoSparqlUtils.saveConfig(this.config, this.getDataDir().toPath());
                if (this.config.isEnabled()) {
                    this.initializeGeoIndexer();
                    this.indexAllData(false, pluginConnection);
                } else {
                    try {
                        this.indexer.rollback();
                    }
                    catch (Exception e) {
                        throw new PluginException("Unable to rollback plugin data", (Throwable)e);
                    }
                }
            }
        } else {
            if (predicate == this.prefixTreePredicateId) {
                String prefixTreeString = pluginConnection.getEntities().get(object).stringValue();
                try {
                    this.tmpPrefixTree = GeoSparqlConfig.PrefixTree.valueOf(prefixTreeString.toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    throw new PluginException(String.format("Unknown prefix tree: %s. The supported types are 'quad' and 'geohash'.", prefixTreeString));
                }
            }
            if (predicate == this.precisionPredicateId) {
                String precisionString = pluginConnection.getEntities().get(object).stringValue();
                try {
                    this.tmpPrecision = Integer.parseInt(precisionString);
                }
                catch (NumberFormatException e) {
                    throw new PluginException("Precision must be an integer number.");
                }
            }
            if (predicate == this.ignoreErrorsPredicateId) {
                String ignoreErrorsString = pluginConnection.getEntities().get(object).stringValue();
                boolean ignoreErrors = Boolean.parseBoolean(ignoreErrorsString);
                this.config.setIgnoreErrors(ignoreErrors);
                GeoSparqlUtils.saveConfig(this.config, this.getDataDir().toPath());
            } else {
                if (predicate == this.maxBufferedDocsPredicateId) {
                    String maxBufferedDocsString = pluginConnection.getEntities().get(object).stringValue();
                    try {
                        int maxBufferedDocs = Integer.parseInt(maxBufferedDocsString);
                        this.config.setMaxBufferedDocs(maxBufferedDocs);
                        GeoSparqlUtils.saveConfig(this.config, this.getDataDir().toPath());
                    }
                    catch (NumberFormatException e) {
                        throw new PluginException("Maximum buffered documents must be an integer number.");
                    }
                }
                if (predicate == this.ramBufferSizePredicateId) {
                    String ramBufferSizeString = pluginConnection.getEntities().get(object).stringValue();
                    try {
                        double ramBufferSize = Double.parseDouble(ramBufferSizeString);
                        this.config.setRamBufferSizeMb(ramBufferSize);
                        GeoSparqlUtils.saveConfig(this.config, this.getDataDir().toPath());
                    }
                    catch (NumberFormatException e) {
                        throw new PluginException("Ram buffer size must be a double number.");
                    }
                }
            }
        }
        return true;
    }

    public GeoSparqlConfig getConfig() {
        return this.config;
    }

    @VisibleForTesting
    public void setConfig(GeoSparqlConfig config) {
        this.config = config;
    }

    Geometry getGeometryFromLiteralId(long id, long geometryTypeId, Entities entities) {
        return this.getGeometryFromString(entities.get(id).stringValue(), geometryTypeId);
    }

    Geometry getGeometryFromString(String literalValue, long geometryTypeId) {
        try {
            if (geometryTypeId == this.asWKT) {
                return GeoConvert.wktToGeometry(literalValue);
            }
            if (geometryTypeId == this.asGML) {
                return this.gmlConverter.gmlToGeometry(literalValue);
            }
        }
        catch (InvalidGeometryException e) {
            this.getLogger().debug("Invalid geometry value: " + literalValue);
        }
        return null;
    }

    private void initPluginFeatures(Entities entities) {
        this.enableGeoSparqlPredicates(entities);
        for (GeoSparqlFunction function : GeoSparqlFunction.values()) {
            long predicateUriId = entities.put((Value)function.getPredicateUri(), Entities.Scope.DEFAULT);
            this.predicateIds2Function.put(predicateUriId, (Object)function);
        }
        try {
            this.gmlConverter = new GmlConverter();
        }
        catch (JAXBException e) {
            throw new PluginException("Unable to init GML converter.", (Throwable)e);
        }
        this.initializeGeoIndexer();
        FunctionLoader.loadFunctionsInPackage("com.useekm.geosparql");
    }

    private void initControlPredicates(Entities entities) {
        this.contextId = entities.put((Value)CONTEXT_IRI, Entities.Scope.SYSTEM);
        this.enabledPredicateId = entities.put((Value)ENABLED_PREDICATE_IRI, Entities.Scope.SYSTEM);
        this.forceReindexPredicateId = entities.put((Value)FORCE_REINDEX_PREDICATE_IRI, Entities.Scope.SYSTEM);
        this.prefixTreePredicateId = entities.put((Value)PREFIXTREE_PREDICATE_IRI, Entities.Scope.SYSTEM);
        this.precisionPredicateId = entities.put((Value)PRECISION_PREDICATE_IRI, Entities.Scope.SYSTEM);
        this.currentPrefixTreePredicateId = entities.put((Value)CURRENT_PREFIXTREE_PREDICATE_IRI, Entities.Scope.SYSTEM);
        this.currentPrecisionPredicateId = entities.put((Value)CURRENT_PRECISION_PREDICATE_IRI, Entities.Scope.SYSTEM);
        this.ignoreErrorsPredicateId = entities.put((Value)IGNORE_ERRORS_PREDICATE_IRI, Entities.Scope.SYSTEM);
        this.maxBufferedDocsPredicateId = entities.put((Value)MAX_BUFFERED_DOCS_PREDICATE_IRI, Entities.Scope.SYSTEM);
        this.ramBufferSizePredicateId = entities.put((Value)RAM_BUFFER_SIZE_MB_PREDICATE_IRI, Entities.Scope.SYSTEM);
    }

    private void enableGeoSparqlPredicates(Entities entities) {
        this.asWKT = entities.put((Value)GeoConstants.GEO_AS_WKT, Entities.Scope.DEFAULT);
        this.asGML = entities.put((Value)GeoConstants.GEO_AS_GML, Entities.Scope.DEFAULT);
        this.hasDefaultGeometry = entities.put((Value)GeoConstants.GEO_HAS_DEFAULT_GEOMETRY, Entities.Scope.DEFAULT);
    }

    private void initializeGeoIndexer() {
        if (this.config.isEnabled() && this.indexer == null) {
            try {
                this.getLogger().debug(">>>>>>>> GeoSPARQL: Initializing Lucene indexer...");
                this.indexer = new LuceneGeoIndexer(this);
                this.indexer.initialize();
                this.getLogger().debug(">>>>>>>> GeoSPARQL: Lucene indexer initialized!");
            }
            catch (Exception e) {
                throw new PluginException("Cannot initialize GeoSPARQL indexer!");
            }
        }
    }

    private void indexAllData(boolean forced, PluginConnection pluginConnection) {
        this.config.updateCurrentSettings();
        this.indexer.initSettings();
        try {
            if (forced) {
                this.getLogger().info(">>>>>>>> GeoSPARQL: Initializing force reindexing process...");
                new GeoSparqlForceReindexer(this.indexer, this).reindex(pluginConnection);
            } else {
                this.getLogger().info(">>>>>>>> GeoSPARQL: Initializing indexing process...");
                this.indexer.begin();
                new GeoSparqlForceReindexer(this.indexer, this).reindex(pluginConnection);
                this.indexer.commit();
            }
            GeoSparqlUtils.saveConfig(this.config, this.getDataDir().toPath());
            this.getLogger().info(">>>>>>>> GeoSPARQL: Indexing completed!");
        }
        catch (Exception e) {
            throw new PluginException("Unable to index GeoSPARQL geometries.", (Throwable)e);
        }
    }

    public boolean statementAdded(long subject, long predicate, long object, long context, boolean explicit, PluginConnection pluginConnection) {
        return this.updateListener.statementAdded(subject, predicate, object, context, explicit, pluginConnection);
    }

    public boolean statementRemoved(long subject, long predicate, long object, long context, boolean explicit, PluginConnection pluginConnection) {
        return this.updateListener.statementRemoved(subject, predicate, object, context, explicit, pluginConnection);
    }

    public void transactionStarted(PluginConnection pluginConnection) {
        this.updateListener.transactionStarted(pluginConnection);
    }

    public void transactionCommit(PluginConnection pluginConnection) {
        this.updateListener.transactionCommit(pluginConnection);
    }

    public void transactionCompleted(PluginConnection pluginConnection) {
        this.updateListener.transactionCompleted(pluginConnection);
    }

    public void transactionAborted(PluginConnection pluginConnection) {
        this.updateListener.transactionAborted(pluginConnection);
    }

    public void transactionAbortedByUser(PluginConnection pluginConnection) {
        this.updateListener.transactionAbortedByUser(pluginConnection);
    }
}

