/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.geosparql;

import com.ontotext.trree.geosparql.GeoSparqlIndexer;
import com.ontotext.trree.geosparql.GeoSparqlPlugin;
import com.ontotext.trree.sdk.PluginConnection;
import com.ontotext.trree.sdk.StatementIterator;
import org.locationtech.jts.geom.Geometry;

public class GeoSparqlForceReindexer {
    private final GeoSparqlIndexer indexer;
    private final GeoSparqlPlugin plugin;

    public GeoSparqlForceReindexer(GeoSparqlIndexer indexer, GeoSparqlPlugin plugin) {
        this.indexer = indexer;
        this.plugin = plugin;
    }

    public void reindex(PluginConnection pluginConnection) throws Exception {
        this.indexer.freshIndex();
        this.reindexGeometries(pluginConnection);
        this.reindexFeatures(pluginConnection);
    }

    private void reindexGeometries(final PluginConnection pluginConnection) {
        class Processor {
            Processor() {
            }

            String mapSubject(Long subject) {
                return pluginConnection.getEntities().get(subject.longValue()).stringValue();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void process(long predicate) {
                try (StatementIterator geoSerItty = pluginConnection.getStatements().get(0L, predicate, 0L);){
                    while (geoSerItty.next()) {
                        Geometry g = GeoSparqlForceReindexer.this.plugin.getGeometryFromLiteralId(geoSerItty.object, predicate, pluginConnection.getEntities());
                        if (g == null) continue;
                        GeoSparqlForceReindexer.this.indexer.indexGeometry(geoSerItty.subject, this::mapSubject, g);
                    }
                }
            }
        }
        Processor p = new Processor();
        p.process(this.plugin.asWKT);
        p.process(this.plugin.asGML);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reindexFeatures(final PluginConnection pluginConnection) {
        class Processor {
            Processor() {
            }

            String mapSubject(Long subject) {
                return pluginConnection.getEntities().get(subject.longValue()).stringValue();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void process(long feature, long subject, long predicate) {
                try (StatementIterator geoSerItty = pluginConnection.getStatements().get(subject, predicate, 0L);){
                    while (geoSerItty.next()) {
                        Geometry g = GeoSparqlForceReindexer.this.plugin.getGeometryFromLiteralId(geoSerItty.object, predicate, pluginConnection.getEntities());
                        if (g == null) continue;
                        GeoSparqlForceReindexer.this.indexer.indexGeometry(feature, this::mapSubject, g);
                    }
                }
            }
        }
        Processor p = new Processor();
        try (StatementIterator defGeoItty = pluginConnection.getStatements().get(0L, this.plugin.hasDefaultGeometry, 0L);){
            while (defGeoItty.next()) {
                p.process(defGeoItty.subject, defGeoItty.object, this.plugin.asWKT);
                p.process(defGeoItty.subject, defGeoItty.object, this.plugin.asGML);
            }
        }
    }
}

