/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.substitution.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.iq.node.ExtensionalDataNode;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.functionsymbol.BooleanFunctionSymbol;
import it.unibz.inf.ontop.substitution.Substitution;
import it.unibz.inf.ontop.substitution.SubstitutionOperations;
import it.unibz.inf.ontop.substitution.UnifierBuilder;
import it.unibz.inf.ontop.substitution.impl.AbstractSubstitutionBasicOperations;
import it.unibz.inf.ontop.substitution.impl.AbstractUnifierBuilder;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collector;

public abstract class AbstractSubstitutionOperations<T extends ImmutableTerm>
extends AbstractSubstitutionBasicOperations<T>
implements SubstitutionOperations<T> {
    private final Function<Variable, T> typeCast;
    private final Function<Substitution<Variable>, Substitution<? extends T>> substitutionTypeCast;
    private final Function<Map.Entry<Variable, T>, T> keyMapper;

    AbstractSubstitutionOperations(TermFactory termFactory, Function<Variable, T> typeCast, Function<Substitution<Variable>, Substitution<? extends T>> substitutionTypeCast) {
        super(termFactory);
        this.typeCast = typeCast;
        this.substitutionTypeCast = substitutionTypeCast;
        this.keyMapper = e -> (ImmutableTerm)typeCast.apply((Variable)e.getKey());
    }

    @Override
    public T apply(Substitution<? extends T> substitution, Variable variable) {
        return AbstractSubstitutionOperations.applyToVariable(substitution, variable, this.typeCast);
    }

    @Override
    public ImmutableFunctionalTerm apply(Substitution<? extends T> substitution, ImmutableFunctionalTerm term) {
        if (term.getFunctionSymbol() instanceof BooleanFunctionSymbol) {
            return this.apply(substitution, (ImmutableExpression)term);
        }
        if (substitution.isEmpty()) {
            return term;
        }
        return this.termFactory.getImmutableFunctionalTerm(term.getFunctionSymbol(), substitution.applyToTerms(term.getTerms()));
    }

    @Override
    public ImmutableExpression apply(Substitution<? extends T> substitution, ImmutableExpression expression) {
        if (substitution.isEmpty()) {
            return expression;
        }
        return this.termFactory.getImmutableExpression(expression.getFunctionSymbol(), substitution.applyToTerms(expression.getTerms()));
    }

    @Override
    public ImmutableList<T> apply(Substitution<? extends T> substitution, ImmutableList<? extends Variable> variables) {
        return (ImmutableList)variables.stream().map(v -> this.apply(substitution, (Variable)v)).collect(ImmutableCollectors.toList());
    }

    @Override
    public ImmutableSet<T> apply(Substitution<? extends T> substitution, ImmutableSet<? extends Variable> terms) {
        return (ImmutableSet)terms.stream().map(v -> this.apply(substitution, (Variable)v)).collect(ImmutableCollectors.toSet());
    }

    @Override
    public T rename(Substitution<Variable> renaming, T t) {
        return this.applyToTerm(this.substitutionTypeCast.apply(renaming), t);
    }

    protected Substitution<T> emptySubstitution() {
        return this.termFactory.getSubstitution(ImmutableMap.of());
    }

    @Override
    public AbstractUnifierBuilder<T> unifierBuilder() {
        return this.unifierBuilder((Substitution)this.emptySubstitution());
    }

    @Override
    public abstract AbstractUnifierBuilder<T> unifierBuilder(Substitution<T> var1);

    @Override
    public Collector<Substitution<T>, ?, Optional<Substitution<T>>> toUnifier() {
        return Collector.of(() -> this.unifierBuilder(), (a, s) -> a.unify(s.stream(), this.keyMapper, Map.Entry::getValue), AbstractUnifierBuilder::merge, UnifierBuilder::build, new Collector.Characteristics[0]);
    }

    @Override
    public Collector<ImmutableMap<Integer, ? extends T>, ?, Optional<SubstitutionOperations.ArgumentMapUnifier<T>>> toArgumentMapUnifier() {
        return Collector.of(() -> new ArgumentMapUnifierBuilder(), ArgumentMapUnifierBuilder::unify, ArgumentMapUnifierBuilder::merge, ArgumentMapUnifierBuilder::build, new Collector.Characteristics[0]);
    }

    private final class ArgumentMapUnifierBuilder {
        private Optional<SubstitutionOperations.ArgumentMapUnifier<T>> optional;

        ArgumentMapUnifierBuilder() {
            this.optional = Optional.of(new ArgumentMapUnifierImpl(ImmutableMap.of(), AbstractSubstitutionOperations.this.emptySubstitution()));
        }

        void unify(ImmutableMap<Integer, ? extends T> argumentMap) {
            if (this.optional.isEmpty()) {
                return;
            }
            SubstitutionOperations.ArgumentMapUnifier unifier = this.optional.get();
            ImmutableMap updatedArgumentMap = AbstractSubstitutionOperations.this.applyToTerms(unifier.getSubstitution(), argumentMap);
            Optional<Substitution<ImmutableTerm>> optionalUpdatedSubstitution = ((AbstractUnifierBuilder)AbstractSubstitutionOperations.this.unifierBuilder()).unify(Sets.intersection((Set)unifier.getArgumentMap().keySet(), (Set)updatedArgumentMap.keySet()).stream(), arg_0 -> unifier.getArgumentMap().get(arg_0), arg_0 -> updatedArgumentMap.get(arg_0)).build();
            this.optional = optionalUpdatedSubstitution.flatMap(u -> ((AbstractUnifierBuilder)AbstractSubstitutionOperations.this.unifierBuilder(unifier.getSubstitution())).unify(u.stream(), AbstractSubstitutionOperations.this.keyMapper, Map.Entry::getValue).build().map(s -> new ArgumentMapUnifierImpl(AbstractSubstitutionOperations.this.applyToTerms(u, ExtensionalDataNode.union(unifier.getArgumentMap(), updatedArgumentMap)), s)));
        }

        ArgumentMapUnifierBuilder merge(ArgumentMapUnifierBuilder another) {
            throw new MinorOntopInternalBugException("Not expected to be run in parallel");
        }

        Optional<SubstitutionOperations.ArgumentMapUnifier<T>> build() {
            return this.optional;
        }
    }

    private static final class ArgumentMapUnifierImpl<T extends ImmutableTerm>
    implements SubstitutionOperations.ArgumentMapUnifier<T> {
        private final ImmutableMap<Integer, ? extends T> argumentMap;
        private final Substitution<T> substitution;

        ArgumentMapUnifierImpl(ImmutableMap<Integer, ? extends T> argumentMap, Substitution<T> substitution) {
            this.argumentMap = argumentMap;
            this.substitution = substitution;
        }

        @Override
        public ImmutableMap<Integer, ? extends T> getArgumentMap() {
            return this.argumentMap;
        }

        @Override
        public Substitution<T> getSubstitution() {
            return this.substitution;
        }

        public String toString() {
            return this.argumentMap + " with " + this.substitution;
        }
    }
}

