/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.type.impl;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import it.unibz.inf.ontop.model.type.ConcreteNumericRDFDatatype;
import it.unibz.inf.ontop.model.type.DBTypeFactory;
import it.unibz.inf.ontop.model.type.MetaRDFTermType;
import it.unibz.inf.ontop.model.type.NumericRDFDatatype;
import it.unibz.inf.ontop.model.type.ObjectRDFType;
import it.unibz.inf.ontop.model.type.RDFDatatype;
import it.unibz.inf.ontop.model.type.RDFTermType;
import it.unibz.inf.ontop.model.type.TermType;
import it.unibz.inf.ontop.model.type.TypeFactory;
import it.unibz.inf.ontop.model.type.impl.AbstractNumericRDFDatatype;
import it.unibz.inf.ontop.model.type.impl.AbstractObjectRDFType;
import it.unibz.inf.ontop.model.type.impl.BlankNodeTermType;
import it.unibz.inf.ontop.model.type.impl.ConcreteNumericRDFDatatypeImpl;
import it.unibz.inf.ontop.model.type.impl.IRITermType;
import it.unibz.inf.ontop.model.type.impl.LangDatatype;
import it.unibz.inf.ontop.model.type.impl.LanguageTagImpl;
import it.unibz.inf.ontop.model.type.impl.MetaRDFTermTypeImpl;
import it.unibz.inf.ontop.model.type.impl.RDFTermTypeImpl;
import it.unibz.inf.ontop.model.type.impl.SimpleRDFDatatype;
import it.unibz.inf.ontop.model.type.impl.TermTypeImpl;
import it.unibz.inf.ontop.model.type.impl.UnsupportedRDFDatatype;
import it.unibz.inf.ontop.model.vocabulary.OWL;
import it.unibz.inf.ontop.model.vocabulary.OntopInternal;
import it.unibz.inf.ontop.model.vocabulary.RDFS;
import it.unibz.inf.ontop.model.vocabulary.XSD;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.rdf.api.IRI;
import org.apache.commons.rdf.api.RDF;

@Singleton
public class TypeFactoryImpl
implements TypeFactory {
    private final Map<IRI, RDFDatatype> datatypeCache = new ConcurrentHashMap<IRI, RDFDatatype>();
    private final Map<String, RDFDatatype> langTypeCache = new ConcurrentHashMap<String, RDFDatatype>();
    private final TermType rootTermType = TermTypeImpl.createOriginTermType();
    private final MetaRDFTermType metaRDFTermType;
    private final RDFTermType rootRDFTermType = RDFTermTypeImpl.createRDFTermRoot(this.rootTermType.getAncestry());
    private final ObjectRDFType objectRDFType;
    private final ObjectRDFType iriTermType;
    private final ObjectRDFType blankNodeTermType;
    private final RDFDatatype rdfsLiteralDatatype;
    private final RDFDatatype dateOrDatetimeDatatype;
    private final NumericRDFDatatype numericDatatype;
    private final NumericRDFDatatype owlRealDatatype;
    private final ConcreteNumericRDFDatatype owlRationalDatatype;
    private final ConcreteNumericRDFDatatype xsdDecimalDatatype;
    private final ConcreteNumericRDFDatatype xsdDoubleDatatype;
    private final ConcreteNumericRDFDatatype xsdFloatDatatype;
    private final ConcreteNumericRDFDatatype xsdIntegerDatatype;
    private final ConcreteNumericRDFDatatype xsdLongDatatype;
    private final ConcreteNumericRDFDatatype xsdIntDatatype;
    private final ConcreteNumericRDFDatatype xsdShortDatatype;
    private final ConcreteNumericRDFDatatype xsdByteDatatype;
    private final ConcreteNumericRDFDatatype xsdNonPositiveIntegerDatatype;
    private final ConcreteNumericRDFDatatype xsdNegativeIntegerDatatype;
    private final ConcreteNumericRDFDatatype xsdNonNegativeIntegerDatatype;
    private final ConcreteNumericRDFDatatype xsdPositiveIntegerDatatype;
    private final ConcreteNumericRDFDatatype xsdUnsignedLongDatatype;
    private final ConcreteNumericRDFDatatype xsdUnsignedIntDatatype;
    private final ConcreteNumericRDFDatatype xsdUnsignedShortDatatype;
    private final ConcreteNumericRDFDatatype xsdUnsignedByteDatatype;
    private final RDFDatatype defaultUnsupportedDatatype;
    private final RDFDatatype xsdStringDatatype;
    private final RDFDatatype xsdBooleanDatatype;
    private final RDFDatatype xsdBase64Datatype;
    private final RDFDatatype xsdTimeDatatype;
    private final RDFDatatype xsdDateDatatype;
    private final RDFDatatype xsdDatetimeDatatype;
    private final RDFDatatype xsdDatetimeStampDatatype;
    private final RDFDatatype xsdGYearDatatype;
    private final DBTypeFactory dbTypeFactory;

    @Inject
    private TypeFactoryImpl(DBTypeFactory.Factory dbTypeFactoryFactory, RDF rdfFactory) {
        this.metaRDFTermType = MetaRDFTermTypeImpl.createMetaRDFTermType(this.rootRDFTermType.getAncestry());
        this.objectRDFType = AbstractObjectRDFType.createAbstractObjectRDFType(this.rootRDFTermType.getAncestry());
        this.iriTermType = new IRITermType(this.objectRDFType.getAncestry());
        this.blankNodeTermType = new BlankNodeTermType(this.objectRDFType.getAncestry());
        this.rdfsLiteralDatatype = SimpleRDFDatatype.createSimpleAbstractRDFDatatype(RDFS.LITERAL, this.rootRDFTermType.getAncestry());
        this.registerDatatype(this.rdfsLiteralDatatype);
        this.numericDatatype = AbstractNumericRDFDatatype.createAbstractNumericTermType(OntopInternal.NUMERIC, this.rdfsLiteralDatatype.getAncestry());
        this.registerDatatype(this.numericDatatype);
        this.xsdDoubleDatatype = ConcreteNumericRDFDatatypeImpl.createTopConcreteNumericTermType(XSD.DOUBLE, this.numericDatatype, DBTypeFactory::getDBDoubleType);
        this.registerDatatype(this.xsdDoubleDatatype);
        this.xsdFloatDatatype = ConcreteNumericRDFDatatypeImpl.createConcreteNumericTermType(XSD.FLOAT, this.numericDatatype.getAncestry(), this.xsdDoubleDatatype.getPromotionSubstitutionHierarchy(), true, DBTypeFactory::getDBDoubleType);
        this.registerDatatype(this.xsdFloatDatatype);
        this.owlRealDatatype = AbstractNumericRDFDatatype.createAbstractNumericTermType(OWL.REAL, this.numericDatatype.getAncestry());
        this.registerDatatype(this.owlRealDatatype);
        this.owlRationalDatatype = ConcreteNumericRDFDatatypeImpl.createConcreteNumericTermType(OWL.RATIONAL, this.owlRealDatatype.getAncestry(), this.xsdFloatDatatype.getPromotionSubstitutionHierarchy(), false, DBTypeFactory::getDBDecimalType);
        this.registerDatatype(this.owlRationalDatatype);
        this.xsdDecimalDatatype = ConcreteNumericRDFDatatypeImpl.createConcreteNumericTermType(XSD.DECIMAL, this.owlRationalDatatype.getAncestry(), this.xsdFloatDatatype.getPromotionSubstitutionHierarchy(), true, DBTypeFactory::getDBDecimalType);
        this.registerDatatype(this.xsdDecimalDatatype);
        this.xsdIntegerDatatype = ConcreteNumericRDFDatatypeImpl.createConcreteNumericTermType(XSD.INTEGER, this.xsdDecimalDatatype, true, DBTypeFactory::getDBLargeIntegerType);
        this.registerDatatype(this.xsdIntegerDatatype);
        this.xsdNonPositiveIntegerDatatype = ConcreteNumericRDFDatatypeImpl.createConcreteNumericTermType(XSD.NON_POSITIVE_INTEGER, this.xsdIntegerDatatype, false, DBTypeFactory::getDBLargeIntegerType);
        this.registerDatatype(this.xsdNonPositiveIntegerDatatype);
        this.xsdNegativeIntegerDatatype = ConcreteNumericRDFDatatypeImpl.createConcreteNumericTermType(XSD.NEGATIVE_INTEGER, this.xsdNonPositiveIntegerDatatype, false, DBTypeFactory::getDBLargeIntegerType);
        this.registerDatatype(this.xsdNegativeIntegerDatatype);
        this.xsdLongDatatype = ConcreteNumericRDFDatatypeImpl.createConcreteNumericTermType(XSD.LONG, this.xsdIntegerDatatype, false, DBTypeFactory::getDBLargeIntegerType);
        this.registerDatatype(this.xsdLongDatatype);
        this.xsdIntDatatype = ConcreteNumericRDFDatatypeImpl.createConcreteNumericTermType(XSD.INT, this.xsdLongDatatype, false, DBTypeFactory::getDBLargeIntegerType);
        this.registerDatatype(this.xsdIntDatatype);
        this.xsdShortDatatype = ConcreteNumericRDFDatatypeImpl.createConcreteNumericTermType(XSD.SHORT, this.xsdIntDatatype, false, DBTypeFactory::getDBLargeIntegerType);
        this.registerDatatype(this.xsdShortDatatype);
        this.xsdByteDatatype = ConcreteNumericRDFDatatypeImpl.createConcreteNumericTermType(XSD.BYTE, this.xsdShortDatatype, false, DBTypeFactory::getDBLargeIntegerType);
        this.registerDatatype(this.xsdByteDatatype);
        this.xsdNonNegativeIntegerDatatype = ConcreteNumericRDFDatatypeImpl.createConcreteNumericTermType(XSD.NON_NEGATIVE_INTEGER, this.xsdIntegerDatatype, false, DBTypeFactory::getDBLargeIntegerType);
        this.registerDatatype(this.xsdNonNegativeIntegerDatatype);
        this.xsdUnsignedLongDatatype = ConcreteNumericRDFDatatypeImpl.createConcreteNumericTermType(XSD.UNSIGNED_LONG, this.xsdIntegerDatatype, false, DBTypeFactory::getDBLargeIntegerType);
        this.registerDatatype(this.xsdUnsignedLongDatatype);
        this.xsdUnsignedIntDatatype = ConcreteNumericRDFDatatypeImpl.createConcreteNumericTermType(XSD.UNSIGNED_INT, this.xsdUnsignedLongDatatype, false, DBTypeFactory::getDBLargeIntegerType);
        this.registerDatatype(this.xsdUnsignedIntDatatype);
        this.xsdUnsignedShortDatatype = ConcreteNumericRDFDatatypeImpl.createConcreteNumericTermType(XSD.UNSIGNED_SHORT, this.xsdUnsignedIntDatatype, false, DBTypeFactory::getDBLargeIntegerType);
        this.registerDatatype(this.xsdUnsignedShortDatatype);
        this.xsdUnsignedByteDatatype = ConcreteNumericRDFDatatypeImpl.createConcreteNumericTermType(XSD.UNSIGNED_BYTE, this.xsdUnsignedShortDatatype, false, DBTypeFactory::getDBLargeIntegerType);
        this.registerDatatype(this.xsdUnsignedByteDatatype);
        this.xsdPositiveIntegerDatatype = ConcreteNumericRDFDatatypeImpl.createConcreteNumericTermType(XSD.POSITIVE_INTEGER, this.xsdNonNegativeIntegerDatatype, false, DBTypeFactory::getDBLargeIntegerType);
        this.registerDatatype(this.xsdPositiveIntegerDatatype);
        this.xsdBooleanDatatype = SimpleRDFDatatype.createSimpleConcreteRDFDatatype(XSD.BOOLEAN, this.rdfsLiteralDatatype.getAncestry(), DBTypeFactory::getDBBooleanType);
        this.registerDatatype(this.xsdBooleanDatatype);
        this.xsdStringDatatype = SimpleRDFDatatype.createSimpleConcreteRDFDatatype(XSD.STRING, this.rdfsLiteralDatatype.getAncestry(), DBTypeFactory::getDBStringType);
        this.registerDatatype(this.xsdStringDatatype);
        this.defaultUnsupportedDatatype = UnsupportedRDFDatatype.createUnsupportedDatatype(this.rdfsLiteralDatatype.getAncestry());
        this.xsdTimeDatatype = SimpleRDFDatatype.createSimpleConcreteRDFDatatype(XSD.TIME, this.rdfsLiteralDatatype.getAncestry(), DBTypeFactory::getDBTimeType);
        this.registerDatatype(this.xsdTimeDatatype);
        this.dateOrDatetimeDatatype = SimpleRDFDatatype.createSimpleAbstractRDFDatatype(OntopInternal.DATE_OR_DATETIME, this.rdfsLiteralDatatype.getAncestry());
        this.registerDatatype(this.dateOrDatetimeDatatype);
        this.xsdDateDatatype = SimpleRDFDatatype.createSimpleConcreteRDFDatatype(XSD.DATE, this.dateOrDatetimeDatatype.getAncestry(), DBTypeFactory::getDBDateType);
        this.registerDatatype(this.xsdDateDatatype);
        this.xsdDatetimeDatatype = SimpleRDFDatatype.createSimpleConcreteRDFDatatype(XSD.DATETIME, this.dateOrDatetimeDatatype.getAncestry(), DBTypeFactory::getDBDateTimestampType);
        this.registerDatatype(this.xsdDatetimeDatatype);
        this.xsdDatetimeStampDatatype = SimpleRDFDatatype.createSimpleConcreteRDFDatatype(XSD.DATETIMESTAMP, this.xsdDatetimeDatatype.getAncestry(), DBTypeFactory::getDBDateTimestampType);
        this.registerDatatype(this.xsdDatetimeStampDatatype);
        this.xsdGYearDatatype = SimpleRDFDatatype.createSimpleConcreteRDFDatatype(XSD.GYEAR, this.rdfsLiteralDatatype.getAncestry(), DBTypeFactory::getDBStringType);
        this.registerDatatype(this.xsdGYearDatatype);
        this.xsdBase64Datatype = SimpleRDFDatatype.createSimpleConcreteRDFDatatype(XSD.BASE64BINARY, this.rdfsLiteralDatatype.getAncestry(), DBTypeFactory::getDBStringType);
        this.registerDatatype(this.xsdBase64Datatype);
        this.dbTypeFactory = dbTypeFactoryFactory.createDBFactory(this.rootTermType, this);
    }

    private void registerDatatype(RDFDatatype datatype) {
        this.datatypeCache.put(datatype.getIRI(), datatype);
    }

    @Override
    public RDFDatatype getLangTermType(String languageTagString) {
        return this.langTypeCache.computeIfAbsent(languageTagString.toLowerCase(), this::createLangStringDatatype);
    }

    @Override
    public RDFDatatype getDatatype(IRI iri) {
        return this.datatypeCache.computeIfAbsent(iri, i -> SimpleRDFDatatype.createSimpleConcreteRDFDatatype(i, this.rdfsLiteralDatatype.getAncestry(), DBTypeFactory::getDBStringType));
    }

    @Override
    public ObjectRDFType getIRITermType() {
        return this.iriTermType;
    }

    @Override
    public ObjectRDFType getBlankNodeType() {
        return this.blankNodeTermType;
    }

    @Override
    public RDFDatatype getUnsupportedDatatype() {
        return this.defaultUnsupportedDatatype;
    }

    @Override
    public RDFDatatype getAbstractOntopNumericDatatype() {
        return this.numericDatatype;
    }

    @Override
    public RDFDatatype getAbstractOntopDateOrDatetimeDatatype() {
        return this.dateOrDatetimeDatatype;
    }

    @Override
    public RDFDatatype getAbstractRDFSLiteral() {
        return this.rdfsLiteralDatatype;
    }

    @Override
    public TermType getAbstractAtomicTermType() {
        return this.rootTermType;
    }

    @Override
    public RDFTermType getAbstractRDFTermType() {
        return this.rootRDFTermType;
    }

    @Override
    public ObjectRDFType getAbstractObjectRDFType() {
        return this.objectRDFType;
    }

    @Override
    public MetaRDFTermType getMetaRDFTermType() {
        return this.metaRDFTermType;
    }

    @Override
    public DBTypeFactory getDBTypeFactory() {
        return this.dbTypeFactory;
    }

    private RDFDatatype createLangStringDatatype(String languageTagString) {
        return LangDatatype.createLangDatatype(new LanguageTagImpl(languageTagString), this.xsdStringDatatype.getAncestry(), this);
    }
}

