/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.term.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.model.term.FunctionalTermSimplification;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.IncrementalEvaluation;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.functionsymbol.FunctionSymbol;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public abstract class ImmutableFunctionalTermImpl
implements ImmutableFunctionalTerm {
    private final FunctionSymbol functionSymbol;
    private final ImmutableList<? extends ImmutableTerm> terms;
    protected final TermFactory termFactory;
    private @Nullable ImmutableSet<Variable> variables;
    private String string;

    protected ImmutableFunctionalTermImpl(FunctionSymbol functor, TermFactory termFactory, ImmutableTerm ... terms) {
        this(functor, (ImmutableList<? extends ImmutableTerm>)ImmutableList.copyOf((Object[])terms), termFactory);
    }

    protected ImmutableFunctionalTermImpl(FunctionSymbol functionSymbol, ImmutableList<? extends ImmutableTerm> terms, TermFactory termFactory) {
        this.functionSymbol = functionSymbol;
        this.terms = terms;
        this.termFactory = termFactory;
        this.string = null;
        this.variables = null;
        if (functionSymbol.getArity() != terms.size()) {
            throw new IllegalArgumentException("Arity violation: " + functionSymbol + " was expecting " + functionSymbol.getArity() + ", not " + terms.size());
        }
    }

    @Override
    public ImmutableTerm getTerm(int index) {
        return (ImmutableTerm)this.terms.get(index);
    }

    @Override
    public FunctionSymbol getFunctionSymbol() {
        return this.functionSymbol;
    }

    @Override
    public int getArity() {
        return this.functionSymbol.getArity();
    }

    @Override
    public ImmutableList<? extends ImmutableTerm> getTerms() {
        return this.terms;
    }

    @Override
    public synchronized ImmutableSet<Variable> getVariables() {
        if (this.variables == null) {
            this.variables = (ImmutableSet)this.getVariableStream().collect(ImmutableCollectors.toSet());
        }
        return this.variables;
    }

    @Override
    public Stream<Variable> getVariableStream() {
        return this.variables == null ? this.terms.stream().flatMap(ImmutableTerm::getVariableStream) : this.variables.stream();
    }

    public String toString() {
        if (this.string == null) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.functionSymbol.toString());
            sb.append("(");
            List argumentStrings = this.terms.stream().map(Object::toString).collect(Collectors.toList());
            sb.append(String.join((CharSequence)",", argumentStrings));
            sb.append(")");
            this.string = sb.toString();
        }
        return this.string;
    }

    public boolean equals(Object other) {
        if (other instanceof ImmutableFunctionalTerm) {
            return this.toString().equals(other.toString());
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public IncrementalEvaluation evaluateStrictEq(ImmutableTerm otherTerm, VariableNullability variableNullability) {
        return this.functionSymbol.evaluateStrictEq(this.getTerms(), otherTerm, this.termFactory, variableNullability);
    }

    @Override
    public IncrementalEvaluation evaluateIsNotNull(VariableNullability variableNullability) {
        return this.functionSymbol.evaluateIsNotNull(this.getTerms(), this.termFactory, variableNullability);
    }

    @Override
    public ImmutableTerm simplify(VariableNullability variableNullability) {
        return this.functionSymbol.simplify(this.getTerms(), this.termFactory, variableNullability);
    }

    @Override
    public ImmutableTerm simplify() {
        return this.functionSymbol.simplify(this.getTerms(), this.termFactory, this.termFactory.createDummyVariableNullability(this));
    }

    @Override
    public Optional<ImmutableFunctionalTerm.FunctionalTermDecomposition> analyzeInjectivity(ImmutableSet<Variable> nonFreeVariables, VariableNullability variableNullability, VariableGenerator variableGenerator) {
        return this.getFunctionSymbol().analyzeInjectivity(this.getTerms(), nonFreeVariables, variableNullability, variableGenerator, this.termFactory);
    }

    @Override
    public Stream<Variable> proposeProvenanceVariables() {
        return this.functionSymbol.proposeProvenanceVariables(this.getTerms());
    }

    @Override
    public FunctionalTermSimplification simplifyAsGuaranteedToBeNonNull() {
        return this.functionSymbol.simplifyAsGuaranteedToBeNonNull(this.getTerms(), this.termFactory);
    }

    @Override
    public boolean canBePostProcessed() {
        return this.functionSymbol.canBePostProcessed(this.terms);
    }

    @Override
    public boolean isNullable(ImmutableSet<Variable> nullableVariables) {
        ImmutableSet nullableIndexes = (ImmutableSet)IntStream.range(0, this.getArity()).filter(i -> this.getTerm(i).isNullable(nullableVariables)).boxed().collect(ImmutableCollectors.toSet());
        return this.functionSymbol.isNullable((ImmutableSet<Integer>)nullableIndexes);
    }
}

