/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.term.functionsymbol.impl.geof;

import com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.model.term.Constant;
import it.unibz.inf.ontop.model.term.DBConstant;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.NonGroundFunctionalTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBConcatFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.geof.AbstractGeofIRIFunctionSymbolImpl;
import it.unibz.inf.ontop.model.type.RDFDatatype;
import it.unibz.inf.ontop.model.type.TermType;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.apache.commons.rdf.api.IRI;

public class GeofGetSRIDFunctionSymbolImpl
extends AbstractGeofIRIFunctionSymbolImpl {
    public static final String defaultSRID = "http://www.opengis.net/def/crs/OGC/1.3/CRS84";

    public GeofGetSRIDFunctionSymbolImpl(@Nonnull IRI functionIRI, RDFDatatype wktLiteralType, RDFDatatype xsdAnyUri) {
        super("GEOF_GETSRID", functionIRI, (ImmutableList<TermType>)ImmutableList.of((Object)wktLiteralType), xsdAnyUri);
    }

    @Override
    protected ImmutableTerm computeDBTerm(ImmutableList<ImmutableTerm> subLexicalTerms, ImmutableList<ImmutableTerm> typeTerms, TermFactory termFactory) {
        ImmutableTerm term = (ImmutableTerm)subLexicalTerms.get(0);
        String sridString = this.getSRIDFromDbConstant(Optional.of(term)).orElseGet(() -> this.getSRIDFromDbConstant(this.getArg0FromTemplate(term)).orElse(defaultSRID));
        return termFactory.getDBStringConstant(sridString);
    }

    private Optional<ImmutableTerm> getArg0FromTemplate(ImmutableTerm term) {
        return Optional.of(term).filter(t -> t instanceof NonGroundFunctionalTerm).map(t -> (NonGroundFunctionalTerm)t).filter(t -> t.getFunctionSymbol() instanceof DBConcatFunctionSymbol).map(t -> t.getTerm(0));
    }

    private Optional<String> getSRIDFromDbConstant(Optional<ImmutableTerm> immutableTerm) {
        return immutableTerm.filter(t -> t instanceof DBConstant).map(t -> (DBConstant)t).map(Constant::getValue).filter(v -> v.startsWith("<") && v.indexOf(">") > 0).map(v -> v.substring(1, v.indexOf(">")));
    }
}

