/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.term.functionsymbol.impl;

import com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.RDFTermTypeConstant;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.BooleanFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBIfElseNullFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBIfThenFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.BooleanFunctionSymbolImpl;
import it.unibz.inf.ontop.model.type.ConcreteNumericRDFDatatype;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.model.type.DBTypeFactory;
import it.unibz.inf.ontop.model.type.MetaRDFTermType;
import it.unibz.inf.ontop.model.type.RDFDatatype;
import it.unibz.inf.ontop.model.type.RDFTermType;
import it.unibz.inf.ontop.model.type.TermType;
import java.util.Optional;
import java.util.stream.Stream;

public abstract class AbstractLexicalNonStrictEqOrInequalityFunctionSymbol
extends BooleanFunctionSymbolImpl {
    private final RDFDatatype xsdBooleanType;
    private final RDFDatatype xsdDateTimeType;
    private final RDFDatatype xsdStringType;
    private final RDFDatatype xsdDateTimeStampType;
    private final RDFDatatype xsdDate;

    protected AbstractLexicalNonStrictEqOrInequalityFunctionSymbol(String functionSymbolName, MetaRDFTermType metaRDFTermType, RDFDatatype xsdBooleanType, RDFDatatype xsdDateTimeType, RDFDatatype xsdStringType, DBTermType dbStringType, DBTermType dbBooleanType, RDFDatatype xsdDateTimeStampType, RDFDatatype xsdDate) {
        super(functionSymbolName, (ImmutableList<TermType>)ImmutableList.of((Object)dbStringType, (Object)metaRDFTermType, (Object)dbStringType, (Object)metaRDFTermType), dbBooleanType);
        this.xsdBooleanType = xsdBooleanType;
        this.xsdDateTimeType = xsdDateTimeType;
        this.xsdStringType = xsdStringType;
        this.xsdDateTimeStampType = xsdDateTimeStampType;
        this.xsdDate = xsdDate;
    }

    @Override
    protected boolean tolerateNulls() {
        return false;
    }

    @Override
    protected boolean mayReturnNullWithoutNullArguments() {
        return true;
    }

    @Override
    public boolean isAlwaysInjectiveInTheAbsenceOfNonInjectiveFunctionalTerms() {
        return false;
    }

    @Override
    public boolean canBePostProcessed(ImmutableList<? extends ImmutableTerm> arguments) {
        return true;
    }

    @Override
    protected ImmutableTerm buildTermAfterEvaluation(ImmutableList<ImmutableTerm> newTerms, TermFactory termFactory, VariableNullability variableNullability) {
        DBTypeFactory dbTypeFactory = termFactory.getTypeFactory().getDBTypeFactory();
        ImmutableTerm lexicalTerm1 = (ImmutableTerm)newTerms.get(0);
        ImmutableTerm lexicalTerm2 = (ImmutableTerm)newTerms.get(2);
        ImmutableTerm typeTerm1 = this.unwrapIfElseNull((ImmutableTerm)newTerms.get(1));
        ImmutableTerm typeTerm2 = this.unwrapIfElseNull((ImmutableTerm)newTerms.get(3));
        if (typeTerm1 instanceof RDFTermTypeConstant && typeTerm2 instanceof RDFTermTypeConstant) {
            return this.simplifyWithConstantTypes(termFactory, variableNullability, dbTypeFactory, lexicalTerm1, lexicalTerm2, (RDFTermTypeConstant)typeTerm1, (RDFTermTypeConstant)typeTerm2);
        }
        return this.tryToLiftMagicNumbers(newTerms, termFactory, variableNullability).orElseGet(() -> this.liftFirstIfThen(lexicalTerm1, lexicalTerm2, typeTerm1, typeTerm2, termFactory).map(t -> t.simplify(variableNullability)).orElseGet(() -> termFactory.getImmutableExpression((BooleanFunctionSymbol)this, lexicalTerm1, typeTerm1, lexicalTerm2, typeTerm2)));
    }

    private Optional<ImmutableExpression> liftFirstIfThen(ImmutableTerm lexicalTerm1, ImmutableTerm lexicalTerm2, ImmutableTerm typeTerm1, ImmutableTerm typeTerm2, TermFactory termFactory) {
        Optional<ImmutableFunctionalTerm> firstIfThenType = Stream.of(typeTerm1, typeTerm2).filter(t -> t instanceof ImmutableFunctionalTerm).map(t -> (ImmutableFunctionalTerm)t).filter(t -> t.getFunctionSymbol() instanceof DBIfThenFunctionSymbol).findAny();
        return firstIfThenType.map(ifThenTypeTerm -> {
            DBIfThenFunctionSymbol functionSymbol = (DBIfThenFunctionSymbol)ifThenTypeTerm.getFunctionSymbol();
            int ifThenIndex = typeTerm1 == ifThenTypeTerm ? 1 : 3;
            ImmutableExpression expressionBeforeLifting = termFactory.getImmutableExpression((BooleanFunctionSymbol)this, lexicalTerm1, typeTerm1, lexicalTerm2, typeTerm2);
            return functionSymbol.pushDownExpression(expressionBeforeLifting, ifThenIndex, termFactory);
        });
    }

    protected ImmutableTerm simplifyWithConstantTypes(TermFactory termFactory, VariableNullability variableNullability, DBTypeFactory dbTypeFactory, ImmutableTerm lexicalTerm1, ImmutableTerm lexicalTerm2, RDFTermTypeConstant typeTerm1, RDFTermTypeConstant typeTerm2) {
        RDFTermType termType1 = typeTerm1.getRDFTermType();
        RDFTermType termType2 = typeTerm2.getRDFTermType();
        ImmutableFunctionalTerm dbTerm1 = termFactory.getConversionFromRDFLexical2DB(termType1.getClosestDBType(dbTypeFactory), lexicalTerm1, termType1);
        ImmutableFunctionalTerm dbTerm2 = termFactory.getConversionFromRDFLexical2DB(termType1.getClosestDBType(dbTypeFactory), lexicalTerm2, termType2);
        if (termType1 instanceof ConcreteNumericRDFDatatype && termType2 instanceof ConcreteNumericRDFDatatype) {
            return this.computeNumericEqualityOrInequality(dbTerm1, dbTerm2, termFactory, variableNullability);
        }
        if (termType1.equals(termType2)) {
            if (termType1.equals(this.xsdBooleanType)) {
                return this.computeBooleanEqualityOrInequality(dbTerm1, dbTerm2, termFactory, variableNullability);
            }
            if (termType1.equals(this.xsdStringType)) {
                return this.computeStringEqualityOrInequality(dbTerm1, dbTerm2, termFactory, variableNullability);
            }
            if (termType1.equals(this.xsdDateTimeType) || termType1.equals(this.xsdDateTimeStampType)) {
                return this.computeDatetimeEqualityOrInequality(dbTerm1, dbTerm2, termFactory, variableNullability);
            }
            if (termType1.equals(this.xsdDate)) {
                return this.computeDateEqualityOrInequality(dbTerm1, dbTerm2, termFactory, variableNullability);
            }
            return this.computeDefaultSameTypeEqualityOrInequality(termType1, dbTerm1, dbTerm2, termFactory, variableNullability);
        }
        return this.computeDefaultDifferentTypeEqualityOrInequality(termType1, termType2, termFactory);
    }

    private ImmutableTerm unwrapIfElseNull(ImmutableTerm term) {
        return Optional.of(term).filter(t -> t instanceof ImmutableFunctionalTerm).map(t -> (ImmutableFunctionalTerm)t).filter(t -> t.getFunctionSymbol() instanceof DBIfElseNullFunctionSymbol).map(t -> t.getTerm(1)).orElse(term);
    }

    @Override
    public boolean blocksNegation() {
        return true;
    }

    @Override
    public ImmutableExpression negate(ImmutableList<? extends ImmutableTerm> subTerms, TermFactory termFactory) {
        throw new UnsupportedOperationException();
    }

    protected abstract ImmutableTerm computeNumericEqualityOrInequality(ImmutableTerm var1, ImmutableTerm var2, TermFactory var3, VariableNullability var4);

    protected abstract ImmutableTerm computeBooleanEqualityOrInequality(ImmutableTerm var1, ImmutableTerm var2, TermFactory var3, VariableNullability var4);

    protected abstract ImmutableTerm computeStringEqualityOrInequality(ImmutableTerm var1, ImmutableTerm var2, TermFactory var3, VariableNullability var4);

    protected abstract ImmutableTerm computeDatetimeEqualityOrInequality(ImmutableTerm var1, ImmutableTerm var2, TermFactory var3, VariableNullability var4);

    protected abstract ImmutableTerm computeDefaultSameTypeEqualityOrInequality(RDFTermType var1, ImmutableTerm var2, ImmutableTerm var3, TermFactory var4, VariableNullability var5);

    protected abstract ImmutableTerm computeDefaultDifferentTypeEqualityOrInequality(RDFTermType var1, RDFTermType var2, TermFactory var3);

    protected abstract ImmutableTerm computeDateEqualityOrInequality(ImmutableTerm var1, ImmutableTerm var2, TermFactory var3, VariableNullability var4);
}

