/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.term.functionsymbol.db.impl;

import com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.model.template.Template;
import it.unibz.inf.ontop.model.term.DBConstant;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.FunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.BnodeStringTemplateFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.ObjectStringTemplateFunctionSymbolImpl;
import it.unibz.inf.ontop.model.type.TypeFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.UUID;
import java.util.function.Function;
import org.apache.commons.codec.binary.Hex;

public class BnodeStringTemplateFunctionSymbolWithSalt
extends ObjectStringTemplateFunctionSymbolImpl
implements BnodeStringTemplateFunctionSymbol {
    private final UUID salt;

    protected BnodeStringTemplateFunctionSymbolWithSalt(ImmutableList<Template.Component> template, UUID salt, TypeFactory typeFactory) {
        super(template, "-salted", typeFactory);
        this.salt = salt;
    }

    @Override
    protected ImmutableTerm simplifyWithAllParametersConstant(ImmutableList<DBConstant> newTerms, TermFactory termFactory, VariableNullability variableNullability) {
        String originalLabel = this.buildString(newTerms, termFactory, variableNullability);
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(this.salt.toString().getBytes());
            md.update(originalLabel.getBytes());
            String externalLabel = Hex.encodeHexString((byte[])md.digest());
            return termFactory.getDBStringConstant(externalLabel.toLowerCase());
        }
        catch (NoSuchAlgorithmException e) {
            throw new MinorOntopInternalBugException(e.getMessage());
        }
    }

    @Override
    public String getNativeDBString(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        ObjectStringTemplateFunctionSymbolImpl newFunctionSymbol = new ObjectStringTemplateFunctionSymbolImpl(this.getTemplateComponents(), termFactory.getTypeFactory()){

            @Override
            public String getNativeDBString(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
                return super.getNativeDBString(terms, termConverter, termFactory);
            }
        };
        ImmutableFunctionalTerm bnodeTemplateBeforeHashing = termFactory.getImmutableFunctionalTerm((FunctionSymbol)newFunctionSymbol, terms);
        ImmutableFunctionalTerm newTerm = termFactory.getDBSha256(termFactory.getNullRejectingDBConcatFunctionalTerm((ImmutableList<? extends ImmutableTerm>)ImmutableList.of((Object)termFactory.getDBStringConstant(this.salt.toString()), (Object)bnodeTemplateBeforeHashing)));
        return termConverter.apply(newTerm);
    }
}

