/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.template;

import com.google.common.collect.ImmutableList;
import java.util.Objects;

public class Template {
    public static Builder builder() {
        return new Builder();
    }

    public static ImmutableList<Component> replaceFirst(ImmutableList<Component> components, String prefix) {
        if (prefix.isEmpty()) {
            return components.subList(1, components.size());
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)new Component(-1, prefix));
        builder.addAll((Iterable)components.subList(1, components.size()));
        return builder.build();
    }

    public static ImmutableList<Component> replaceLast(ImmutableList<Component> components, String suffix) {
        if (suffix.isEmpty()) {
            return components.subList(0, components.size() - 1);
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll((Iterable)components.subList(0, components.size() - 1));
        builder.add((Object)new Component(-1, suffix));
        return builder.build();
    }

    public static class Component {
        private final String component;
        private final int index;
        private static final int STRING_INDEX = -1;

        private Component(int index, String component) {
            this.index = index;
            this.component = Objects.requireNonNull(component);
        }

        public boolean isColumn() {
            return this.index != -1;
        }

        public String getComponent() {
            return this.component;
        }

        public int getIndex() {
            return this.index;
        }

        public String toString() {
            return this.index == -1 ? this.component : "_" + this.index + "/" + this.component + "_";
        }

        public boolean equals(Object o) {
            if (o instanceof Component) {
                Component other = (Component)o;
                return this.index == other.index && (this.index != -1 || this.component.equals(other.component));
            }
            return false;
        }

        public int hashCode() {
            return this.index == -1 ? this.component.hashCode() : Integer.hashCode(this.index);
        }
    }

    public static class Builder {
        private final ImmutableList.Builder<Component> builder = ImmutableList.builder();
        private int index = 0;

        public Builder placeholder() {
            return this.column("");
        }

        public Builder column(String column) {
            int index1 = this.index++;
            this.builder.add((Object)new Component(index1, column));
            return this;
        }

        public Builder string(String str) {
            this.builder.add((Object)new Component(-1, str));
            return this;
        }

        public ImmutableList<Component> build() {
            return this.builder.build();
        }
    }
}

