/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.atom.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.model.atom.AtomPredicate;
import it.unibz.inf.ontop.model.atom.DataAtom;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.VariableOrGroundTerm;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public abstract class AbstractDataAtomImpl<P extends AtomPredicate>
implements DataAtom<P> {
    private final P predicate;
    private final ImmutableList<? extends VariableOrGroundTerm> arguments;
    private @Nullable String string;

    protected AbstractDataAtomImpl(P predicate, ImmutableList<? extends VariableOrGroundTerm> variableOrGroundTerms) {
        this.predicate = predicate;
        this.arguments = variableOrGroundTerms;
        this.string = null;
        if (predicate.getArity() != this.arguments.size()) {
            throw new IllegalArgumentException("Arity violation: " + predicate + " was expecting " + predicate.getArity() + ", not " + this.arguments.size());
        }
    }

    protected AbstractDataAtomImpl(P predicate, VariableOrGroundTerm ... variableOrGroundTerms) {
        this(predicate, (ImmutableList<? extends VariableOrGroundTerm>)ImmutableList.copyOf((Object[])variableOrGroundTerms));
    }

    @Override
    public P getPredicate() {
        return this.predicate;
    }

    @Override
    public int getArity() {
        return this.predicate.getArity();
    }

    @Override
    public int getEffectiveArity() {
        return this.arguments.size();
    }

    @Override
    public ImmutableList<? extends VariableOrGroundTerm> getArguments() {
        return this.arguments;
    }

    @Override
    public VariableOrGroundTerm getTerm(int index) {
        return (VariableOrGroundTerm)this.arguments.get(index);
    }

    @Override
    public ImmutableSet<Variable> getVariables() {
        return (ImmutableSet)this.arguments.stream().flatMap(ImmutableTerm::getVariableStream).collect(ImmutableCollectors.toSet());
    }

    public boolean equals(Object other) {
        if (other instanceof DataAtom) {
            return this.toString().equals(other.toString());
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        if (this.string == null) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.predicate.toString());
            sb.append("(");
            Stream<String> argumentStrings = this.arguments.stream().map(Object::toString);
            sb.append(argumentStrings.collect(Collectors.joining(", ")));
            sb.append(")");
            this.string = sb.toString();
        }
        return this.string;
    }
}

