/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.type.impl;

import com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.transform.IQTreeTransformer;
import it.unibz.inf.ontop.iq.type.PartiallyTypedSimpleCastTransformer;
import it.unibz.inf.ontop.iq.type.SingleTermTypeExtractor;
import it.unibz.inf.ontop.iq.type.impl.AbstractExpressionTransformer;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.FunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBTypeConversionFunctionSymbol;
import it.unibz.inf.ontop.model.type.DBTermType;
import java.util.Optional;
import javax.inject.Inject;

public class PartiallyTypedSimpleCastTransformerImpl
implements PartiallyTypedSimpleCastTransformer {
    private final IQTreeTransformer expressionTransformer;

    @Inject
    protected PartiallyTypedSimpleCastTransformerImpl(IntermediateQueryFactory iqFactory, SingleTermTypeExtractor typeExtractor, TermFactory termFactory) {
        this.expressionTransformer = new ExpressionTransformer(iqFactory, typeExtractor, termFactory);
    }

    @Override
    public IQTree transform(IQTree tree) {
        return this.expressionTransformer.transform(tree);
    }

    protected static class ExpressionTransformer
    extends AbstractExpressionTransformer {
        protected ExpressionTransformer(IntermediateQueryFactory iqFactory, SingleTermTypeExtractor typeExtractor, TermFactory termFactory) {
            super(iqFactory, typeExtractor, termFactory);
        }

        @Override
        protected boolean isFunctionSymbolToReplace(FunctionSymbol functionSymbol) {
            if (!(functionSymbol instanceof DBTypeConversionFunctionSymbol)) {
                return false;
            }
            DBTypeConversionFunctionSymbol conversionFunctionSymbol = (DBTypeConversionFunctionSymbol)functionSymbol;
            return conversionFunctionSymbol.isSimple() && !conversionFunctionSymbol.isTemporary() && !conversionFunctionSymbol.getInputType().isPresent() && conversionFunctionSymbol.getArity() == 1 && conversionFunctionSymbol.getTargetType().getCategory() != DBTermType.Category.DATE;
        }

        @Override
        protected ImmutableFunctionalTerm replaceFunctionSymbol(FunctionSymbol functionSymbol, ImmutableList<ImmutableTerm> newTerms, IQTree tree) {
            ImmutableTerm subTerm = (ImmutableTerm)newTerms.get(0);
            Optional<DBTermType> inputType = this.typeExtractor.extractSingleTermType(subTerm, tree).filter(t -> t instanceof DBTermType).map(t -> (DBTermType)t);
            return inputType.map(t -> this.termFactory.getDBCastFunctionalTerm((DBTermType)t, ((DBTypeConversionFunctionSymbol)functionSymbol).getTargetType(), subTerm)).orElseGet(() -> this.termFactory.getImmutableFunctionalTerm(functionSymbol, (ImmutableList<? extends ImmutableTerm>)newTerms));
        }
    }
}

