/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.request;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import it.unibz.inf.ontop.iq.request.impl.FunctionalDependenciesImpl;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.substitution.InjectiveSubstitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collector;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public interface FunctionalDependencies {
    public boolean isEmpty();

    public Stream<Map.Entry<ImmutableSet<Variable>, ImmutableSet<Variable>>> stream();

    public FunctionalDependencies rename(InjectiveSubstitution<Variable> var1, SubstitutionFactory var2);

    public FunctionalDependencies concat(FunctionalDependencies var1);

    public FunctionalDependencies merge(FunctionalDependencies var1);

    public boolean contains(ImmutableSet<Variable> var1, ImmutableSet<Variable> var2);

    public ImmutableSet<ImmutableSet<Variable>> getDeterminantsOf(Variable var1);

    public static FunctionalDependencies of(ImmutableSet<Variable> ... dependencies) {
        if (dependencies.length % 2 != 0) {
            throw new IllegalArgumentException("FunctionalDependency must be built of 2n ImmutableSets.");
        }
        Stream<ImmutableSet> determinants = IntStream.range(0, dependencies.length).filter(i -> i % 2 == 0).mapToObj(i -> dependencies[i]);
        Stream<ImmutableSet> dependents = IntStream.range(0, dependencies.length).filter(i -> i % 2 == 1).mapToObj(i -> dependencies[i]);
        return new FunctionalDependenciesImpl((ImmutableSet<Map.Entry<ImmutableSet<Variable>, ImmutableSet<Variable>>>)((ImmutableSet)Streams.zip(determinants, dependents, (a, b) -> Maps.immutableEntry((Object)a, (Object)b)).collect(ImmutableCollectors.toSet())));
    }

    public static FunctionalDependencies empty() {
        return new FunctionalDependenciesImpl((ImmutableSet<Map.Entry<ImmutableSet<Variable>, ImmutableSet<Variable>>>)ImmutableSet.of());
    }

    public static Collector<Map.Entry<ImmutableSet<Variable>, ImmutableSet<Variable>>, ?, FunctionalDependencies> toFunctionalDependencies() {
        return FunctionalDependenciesImpl.getCollector();
    }

    public static FunctionalDependencies fromUniqueConstraints(ImmutableSet<ImmutableSet<Variable>> uniqueConstraints, ImmutableSet<Variable> allVariables) {
        return uniqueConstraints.stream().map(uc -> Maps.immutableEntry((Object)uc, (Object)Sets.difference((Set)allVariables, (Set)uc).immutableCopy())).filter(fd -> !((ImmutableSet)fd.getValue()).isEmpty()).collect(FunctionalDependencies.toFunctionalDependencies());
    }
}

