/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.node.normalization.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.iq.node.impl.UnsatisfiableConditionException;
import it.unibz.inf.ontop.iq.node.normalization.ConditionSimplifier;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.VariableOrGroundTerm;
import it.unibz.inf.ontop.substitution.InjectiveSubstitution;
import it.unibz.inf.ontop.substitution.Substitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.Optional;
import java.util.Set;
import java.util.stream.IntStream;
import java.util.stream.Stream;

@Singleton
public class JoinLikeChildBindingLifter {
    private final ConditionSimplifier conditionSimplifier;
    private final TermFactory termFactory;
    private final SubstitutionFactory substitutionFactory;

    @Inject
    private JoinLikeChildBindingLifter(ConditionSimplifier conditionSimplifier, TermFactory termFactory, SubstitutionFactory substitutionFactory) {
        this.conditionSimplifier = conditionSimplifier;
        this.termFactory = termFactory;
        this.substitutionFactory = substitutionFactory;
    }

    public <R> R liftRegularChildBinding(ConstructionNode selectedChildConstructionNode, int selectedChildPosition, IQTree selectedGrandChild, ImmutableList<IQTree> children, ImmutableSet<Variable> nonLiftableVariables, Optional<ImmutableExpression> initialJoiningCondition, VariableGenerator variableGenerator, VariableNullability variableNullability, BindingLiftConverter<R> bindingLiftConverter) throws UnsatisfiableConditionException {
        Substitution<ImmutableTerm> selectedChildSubstitution = selectedChildConstructionNode.getSubstitution();
        Substitution<VariableOrGroundTerm> downPropagableFragment = selectedChildSubstitution.restrictRangeTo(VariableOrGroundTerm.class);
        Substitution<ImmutableFunctionalTerm> nonDownPropagableFragment = selectedChildSubstitution.restrictRangeTo(ImmutableFunctionalTerm.class);
        ImmutableSet otherChildrenVariables = (ImmutableSet)IntStream.range(0, children.size()).filter(i -> i != selectedChildPosition).mapToObj(arg_0 -> children.get(arg_0)).flatMap(iq -> iq.getVariables().stream()).collect(ImmutableCollectors.toSet());
        InjectiveSubstitution<Variable> freshRenaming = Sets.intersection(nonDownPropagableFragment.getDomain(), (Set)otherChildrenVariables).stream().collect(this.substitutionFactory.toFreshRenamingSubstitution(variableGenerator));
        Stream<ImmutableExpression> equalities = freshRenaming.builder().toStream((v, t) -> this.termFactory.getStrictEquality(selectedChildSubstitution.apply((Variable)v), (ImmutableTerm)t, new ImmutableTerm[0]));
        ConditionSimplifier.ExpressionAndSubstitution expressionResults = this.conditionSimplifier.simplifyCondition(this.termFactory.getConjunction(initialJoiningCondition.map(selectedChildSubstitution::apply), equalities), nonLiftableVariables, children, variableNullability);
        Optional<ImmutableExpression> newCondition = expressionResults.getOptionalExpression();
        Substitution<ImmutableTerm> naiveAscendingSubstitution = expressionResults.getSubstitution().compose(selectedChildSubstitution);
        Substitution<VariableOrGroundTerm> descendingSubstitution = this.substitutionFactory.onVariableOrGroundTerms().compose(expressionResults.getSubstitution(), this.substitutionFactory.union(freshRenaming, downPropagableFragment.removeFromDomain((Set<Variable>)freshRenaming.getDomain())));
        return bindingLiftConverter.convert(children, selectedGrandChild, selectedChildPosition, newCondition, naiveAscendingSubstitution, descendingSubstitution);
    }

    @FunctionalInterface
    public static interface BindingLiftConverter<R> {
        public R convert(ImmutableList<IQTree> var1, IQTree var2, int var3, Optional<ImmutableExpression> var4, Substitution<ImmutableTerm> var5, Substitution<? extends VariableOrGroundTerm> var6);
    }
}

