/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.node.normalization.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.injection.CoreSingletons;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.iq.node.ExtendedProjectionNode;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.NonFunctionalTerm;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.substitution.Substitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class InjectiveBindingLiftState {
    private final ImmutableList<ConstructionNode> ancestors;
    private final IQTree grandChildTree;
    private final @Nullable ConstructionNode childConstructionNode;
    private final VariableGenerator variableGenerator;
    private final CoreSingletons coreSingletons;

    protected InjectiveBindingLiftState(@Nonnull ConstructionNode childConstructionNode, IQTree grandChildTree, VariableGenerator variableGenerator, CoreSingletons coreSingletons) {
        this.coreSingletons = coreSingletons;
        this.ancestors = ImmutableList.of();
        this.grandChildTree = grandChildTree;
        this.childConstructionNode = childConstructionNode;
        this.variableGenerator = variableGenerator;
    }

    private InjectiveBindingLiftState(ImmutableList<ConstructionNode> ancestors, IQTree grandChildTree, VariableGenerator variableGenerator, CoreSingletons coreSingletons) {
        this.ancestors = ancestors;
        this.grandChildTree = grandChildTree;
        this.coreSingletons = coreSingletons;
        this.childConstructionNode = null;
        this.variableGenerator = variableGenerator;
    }

    private InjectiveBindingLiftState(ImmutableList<ConstructionNode> ancestors, IQTree grandChildTree, VariableGenerator variableGenerator, @Nonnull ConstructionNode childConstructionNode, CoreSingletons coreSingletons) {
        this.ancestors = ancestors;
        this.grandChildTree = grandChildTree;
        this.childConstructionNode = childConstructionNode;
        this.variableGenerator = variableGenerator;
        this.coreSingletons = coreSingletons;
    }

    public IQTree getGrandChildTree() {
        return this.grandChildTree;
    }

    public Optional<ConstructionNode> getChildConstructionNode() {
        return Optional.ofNullable(this.childConstructionNode);
    }

    public ImmutableList<ConstructionNode> getAncestors() {
        return this.ancestors;
    }

    public InjectiveBindingLiftState liftBindings() {
        if (this.childConstructionNode == null) {
            return this;
        }
        Substitution<ImmutableTerm> childSubstitution = this.childConstructionNode.getSubstitution();
        if (childSubstitution.isEmpty()) {
            return this;
        }
        VariableNullability grandChildVariableNullability = this.grandChildTree.getVariableNullability();
        ImmutableSet<Variable> nonFreeVariables = this.childConstructionNode.getVariables();
        ImmutableMap injectivityDecompositionMap = childSubstitution.builder().restrictRangeTo(ImmutableFunctionalTerm.class).toMapIgnoreOptional((v, t) -> t.analyzeInjectivity(nonFreeVariables, grandChildVariableNullability, this.variableGenerator));
        SubstitutionFactory substitutionFactory = this.coreSingletons.getSubstitutionFactory();
        Substitution<ImmutableTerm> liftedSubstitution = substitutionFactory.union(childSubstitution.restrictRangeTo(NonFunctionalTerm.class), childSubstitution.builder().restrictRangeTo(ImmutableFunctionalTerm.class).transformOrRemove(arg_0 -> injectivityDecompositionMap.get(arg_0), ImmutableFunctionalTerm.FunctionalTermDecomposition::getLiftableTerm).build());
        IntermediateQueryFactory iqFactory = this.coreSingletons.getIQFactory();
        Optional<ConstructionNode> liftedConstructionNode = Optional.of(liftedSubstitution).filter(s -> !s.isEmpty()).map(s -> iqFactory.createConstructionNode(this.childConstructionNode.getVariables(), (Substitution<? extends ImmutableTerm>)s));
        ImmutableSet newChildVariables = liftedConstructionNode.map(ExtendedProjectionNode::getChildVariables).orElseGet(this.childConstructionNode::getVariables);
        Substitution<ImmutableFunctionalTerm> newChildSubstitution = childSubstitution.builder().restrictRangeTo(ImmutableFunctionalTerm.class).flatTransform(arg_0 -> injectivityDecompositionMap.get(arg_0), ImmutableFunctionalTerm.FunctionalTermDecomposition::getSubstitution).build();
        Optional<ConstructionNode> newChildConstructionNode = Optional.of(newChildSubstitution).filter(s -> !s.isEmpty()).map(s -> iqFactory.createConstructionNode((ImmutableSet<Variable>)newChildVariables, (Substitution<? extends ImmutableTerm>)s)).or(() -> newChildVariables.equals(this.grandChildTree.getVariables()) ? Optional.empty() : Optional.of(iqFactory.createConstructionNode((ImmutableSet<Variable>)newChildVariables)));
        if (newChildConstructionNode.filter(n -> n.equals(this.childConstructionNode)).isPresent()) {
            if (liftedConstructionNode.isPresent()) {
                throw new MinorOntopInternalBugException("Unexpected lifted construction node");
            }
            return this;
        }
        ImmutableList newAncestors = liftedConstructionNode.map(n -> (ImmutableList)Stream.concat(this.ancestors.stream(), Stream.of(n)).collect(ImmutableCollectors.toList())).orElseThrow(() -> new MinorOntopInternalBugException("A lifted construction node was expected"));
        return newChildConstructionNode.map(c -> new InjectiveBindingLiftState((ImmutableList<ConstructionNode>)newAncestors, this.grandChildTree, this.variableGenerator, (ConstructionNode)c, this.coreSingletons)).orElseGet(() -> new InjectiveBindingLiftState((ImmutableList<ConstructionNode>)newAncestors, this.grandChildTree, this.variableGenerator, this.coreSingletons));
    }
}

