/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.node.normalization.impl;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.IQTreeCache;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.iq.node.FlattenNode;
import it.unibz.inf.ontop.iq.node.QueryNode;
import it.unibz.inf.ontop.iq.node.normalization.FlattenNormalizer;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.substitution.Substitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.Set;

public class FlattenNormalizerImpl
implements FlattenNormalizer {
    private final IntermediateQueryFactory iqFactory;

    @Inject
    private FlattenNormalizerImpl(IntermediateQueryFactory iqFactory, SubstitutionFactory substitutionFactory) {
        this.iqFactory = iqFactory;
    }

    @Override
    public IQTree normalizeForOptimization(FlattenNode flattenNode, IQTree child, VariableGenerator variableGenerator, IQTreeCache treeCache) {
        IQTree normalizedChild = child.normalizeForOptimization(variableGenerator);
        QueryNode newChildNode = normalizedChild.getRootNode();
        IQTreeCache outputTreeCache = treeCache.declareAsNormalizedForOptimizationWithoutEffect();
        if (newChildNode instanceof ConstructionNode) {
            ConstructionNode cn = (ConstructionNode)newChildNode;
            Variable flattenedVar = flattenNode.getFlattenedVariable();
            Substitution<ImmutableTerm> flattenedVarSubstitution = cn.getSubstitution().builder().restrict((v, t) -> v.equals(flattenedVar) || t.getVariableStream().anyMatch(tv -> tv.equals(flattenedVar))).build();
            Substitution<ImmutableTerm> primeSubstitution = cn.getSubstitution().removeFromDomain((Set<Variable>)flattenedVarSubstitution.getDomain());
            if (primeSubstitution.isEmpty()) {
                return this.iqFactory.createUnaryIQTree(flattenNode, normalizedChild, outputTreeCache);
            }
            ConstructionNode newParentCn = this.iqFactory.createConstructionNode((ImmutableSet<Variable>)Sets.union(flattenNode.getLocallyDefinedVariables(), (Set)Sets.difference(cn.getVariables(), (Set)ImmutableSet.of((Object)flattenedVar))).immutableCopy(), primeSubstitution);
            IQTree grandChild = (IQTree)normalizedChild.getChildren().get(0);
            IQTree updatedChild = flattenedVarSubstitution.isEmpty() ? grandChild : this.iqFactory.createUnaryIQTree(this.iqFactory.createConstructionNode((ImmutableSet<Variable>)Sets.union((Set)ImmutableSet.of((Object)flattenedVar), (Set)Sets.difference(newParentCn.getLocallyRequiredVariables(), flattenNode.getLocallyDefinedVariables())).immutableCopy(), flattenedVarSubstitution), grandChild).normalizeForOptimization(variableGenerator);
            return this.iqFactory.createUnaryIQTree(newParentCn, this.iqFactory.createUnaryIQTree(flattenNode, updatedChild).normalizeForOptimization(variableGenerator), outputTreeCache);
        }
        return this.iqFactory.createUnaryIQTree(flattenNode, normalizedChild, outputTreeCache);
    }
}

