/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.node.normalization.impl;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.injection.CoreSingletons;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.IQTreeCache;
import it.unibz.inf.ontop.iq.NaryIQTree;
import it.unibz.inf.ontop.iq.UnaryIQTree;
import it.unibz.inf.ontop.iq.impl.IQTreeTools;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.iq.node.DistinctNode;
import it.unibz.inf.ontop.iq.node.FilterNode;
import it.unibz.inf.ontop.iq.node.OrderByNode;
import it.unibz.inf.ontop.iq.node.QueryNode;
import it.unibz.inf.ontop.iq.node.UnaryOperatorNode;
import it.unibz.inf.ontop.iq.node.UnionNode;
import it.unibz.inf.ontop.iq.node.ValuesNode;
import it.unibz.inf.ontop.iq.node.normalization.DistinctNormalizer;
import it.unibz.inf.ontop.iq.node.normalization.impl.InjectiveBindingLiftState;
import it.unibz.inf.ontop.model.term.Constant;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.Optional;
import javax.annotation.Nullable;

@Singleton
public class DistinctNormalizerImpl
implements DistinctNormalizer {
    private static final int MAX_ITERATIONS = 10000;
    private final IntermediateQueryFactory iqFactory;
    private final CoreSingletons coreSingletons;
    private final IQTreeTools iqTreeTools;

    @Inject
    private DistinctNormalizerImpl(CoreSingletons coreSingletons, IQTreeTools iqTreeTools) {
        this.iqFactory = coreSingletons.getIQFactory();
        this.coreSingletons = coreSingletons;
        this.iqTreeTools = iqTreeTools;
    }

    @Override
    public IQTree normalizeForOptimization(DistinctNode distinctNode, IQTree initialChild, VariableGenerator variableGenerator, IQTreeCache treeCache) {
        Optional<IQTree> newTree;
        IQTree child = initialChild.normalizeForOptimization(variableGenerator);
        if (child.isDistinct()) {
            return child;
        }
        if (child.getVariables().isEmpty()) {
            UnaryIQTree limitTree = this.iqFactory.createUnaryIQTree(this.iqFactory.createSliceNode(0L, 1L), child);
            return limitTree.normalizeForOptimization(variableGenerator);
        }
        QueryNode childRoot = child.getRootNode();
        if (childRoot instanceof ConstructionNode) {
            ConstructionNode constructionNode = (ConstructionNode)childRoot;
            if (this.isConstructionNodeWithoutChildVariablesAndDeterministic(constructionNode)) {
                return this.iqFactory.createUnaryIQTree(this.iqFactory.createSliceNode(0L, 1L), child).normalizeForOptimization(variableGenerator);
            }
            return this.liftBindingConstructionChild(constructionNode, treeCache, (UnaryIQTree)child, variableGenerator);
        }
        if (childRoot instanceof ValuesNode) {
            ValuesNode valuesNode = (ValuesNode)childRoot;
            return this.iqFactory.createValuesNode(valuesNode.getOrderedVariables(), (ImmutableList<ImmutableList<Constant>>)((ImmutableList)valuesNode.getValues().stream().distinct().collect(ImmutableCollectors.toList())));
        }
        if (childRoot instanceof UnionNode) {
            Optional<IQTree> newTree2 = this.simplifyUnion(child, distinctNode, null, null, variableGenerator);
            if (newTree2.isPresent()) {
                return newTree2.get();
            }
        } else if (childRoot instanceof OrderByNode && ((IQTree)child.getChildren().get(0)).getRootNode() instanceof UnionNode) {
            Optional<IQTree> newTree3 = this.simplifyUnion((IQTree)child.getChildren().get(0), distinctNode, (OrderByNode)childRoot, null, variableGenerator);
            if (newTree3.isPresent()) {
                return newTree3.get();
            }
        } else if (childRoot instanceof OrderByNode && ((IQTree)child.getChildren().get(0)).getRootNode() instanceof FilterNode && ((IQTree)((IQTree)child.getChildren().get(0)).getChildren().get(0)).getRootNode() instanceof UnionNode) {
            Optional<IQTree> newTree4 = this.simplifyUnion((IQTree)((IQTree)child.getChildren().get(0)).getChildren().get(0), distinctNode, (OrderByNode)childRoot, (FilterNode)((IQTree)child.getChildren().get(0)).getRootNode(), variableGenerator);
            if (newTree4.isPresent()) {
                return newTree4.get();
            }
        } else if (childRoot instanceof FilterNode && ((IQTree)child.getChildren().get(0)).getRootNode() instanceof UnionNode && (newTree = this.simplifyUnion((IQTree)child.getChildren().get(0), distinctNode, null, (FilterNode)childRoot, variableGenerator)).isPresent()) {
            return newTree.get();
        }
        return child.equals(initialChild) ? this.createDistinctTree(distinctNode, child, treeCache.declareAsNormalizedForOptimizationWithoutEffect()) : this.createDistinctTree(distinctNode, child, treeCache.declareAsNormalizedForOptimizationWithEffect());
    }

    private IQTree createDistinctTree(DistinctNode distinctNode, IQTree child, IQTreeCache treeCache) {
        return child.isDistinct() ? child : this.iqFactory.createUnaryIQTree(distinctNode, child, treeCache);
    }

    private IQTree liftBindingConstructionChild(ConstructionNode constructionNode, IQTreeCache treeCache, UnaryIQTree child, VariableGenerator variableGenerator) {
        InjectiveBindingLiftState state = new InjectiveBindingLiftState(constructionNode, child.getChild(), variableGenerator, this.coreSingletons);
        for (int i = 0; i < 10000; ++i) {
            InjectiveBindingLiftState newState = state.liftBindings();
            if (newState.equals(state)) {
                return this.createNormalizedTree(newState, treeCache, variableGenerator);
            }
            state = newState;
        }
        throw new MinorOntopInternalBugException("DistinctNormalizerImpl.liftBindingConstructionChild() did not converge after 10000");
    }

    private Optional<IQTree> simplifyUnion(IQTree child, DistinctNode distinctNode, @Nullable OrderByNode orderByNode, @Nullable FilterNode filterNode, VariableGenerator variableGenerator) {
        ImmutableList newUnionChildren;
        ImmutableList<IQTree> unionChildren = child.getChildren();
        if (unionChildren.equals((Object)(newUnionChildren = (ImmutableList)unionChildren.stream().map(c -> this.simplifyUnionChild((IQTree)c, variableGenerator)).collect(ImmutableCollectors.toList())))) {
            return Optional.empty();
        }
        NaryIQTree newUnionTree = this.iqFactory.createNaryIQTree((UnionNode)child.getRootNode(), (ImmutableList<IQTree>)newUnionChildren);
        IQTree newFilterTree = this.iqTreeTools.createOptionalUnaryIQTree(Optional.ofNullable(filterNode), newUnionTree);
        IQTree newOrderByTree = this.iqTreeTools.createOptionalUnaryIQTree(Optional.ofNullable(orderByNode), newFilterTree);
        UnaryIQTree newTree = this.iqFactory.createUnaryIQTree(distinctNode, newOrderByTree);
        return Optional.of(newTree.normalizeForOptimization(variableGenerator));
    }

    private IQTree simplifyUnionChild(IQTree unionChild, VariableGenerator variableGenerator) {
        ConstructionNode constructionNode;
        if (unionChild.isDistinct()) {
            return unionChild;
        }
        if (unionChild instanceof ValuesNode) {
            ValuesNode valuesNode = (ValuesNode)unionChild;
            return this.iqFactory.createValuesNode(valuesNode.getOrderedVariables(), (ImmutableList<ImmutableList<Constant>>)((ImmutableList)valuesNode.getValues().stream().distinct().collect(ImmutableCollectors.toList())));
        }
        QueryNode unionChildRoot = unionChild.getRootNode();
        if (unionChildRoot instanceof ConstructionNode && this.isConstructionNodeWithoutChildVariablesAndDeterministic(constructionNode = (ConstructionNode)unionChildRoot)) {
            return this.iqFactory.createUnaryIQTree(this.iqFactory.createSliceNode(0L, 1L), unionChild).normalizeForOptimization(variableGenerator);
        }
        return unionChild;
    }

    private boolean isConstructionNodeWithoutChildVariablesAndDeterministic(ConstructionNode constructionNode) {
        return constructionNode.getChildVariables().isEmpty() && constructionNode.getSubstitution().rangeAllMatch(this::isConstantOrDeterministic);
    }

    private boolean isConstantOrDeterministic(ImmutableTerm term) {
        if (term instanceof Constant) {
            return true;
        }
        if (term instanceof ImmutableFunctionalTerm) {
            ImmutableFunctionalTerm functionalTerm = (ImmutableFunctionalTerm)term;
            if (!functionalTerm.getFunctionSymbol().isDeterministic()) {
                return false;
            }
            return functionalTerm.getTerms().stream().allMatch(this::isConstantOrDeterministic);
        }
        throw new MinorOntopInternalBugException("The term was expected to be grounded");
    }

    private IQTree createNormalizedTree(InjectiveBindingLiftState state, IQTreeCache treeCache, VariableGenerator variableGenerator) {
        IQTree grandChildTree = state.getGrandChildTree();
        IQTree newGrandChildTree = grandChildTree.getRootNode() instanceof DistinctNode ? ((UnaryIQTree)grandChildTree).getChild() : grandChildTree;
        IQTreeCache childTreeCache = this.iqFactory.createIQTreeCache(newGrandChildTree == grandChildTree);
        IQTree newChildTree = state.getChildConstructionNode().map(c -> this.iqFactory.createUnaryIQTree((UnaryOperatorNode)c, newGrandChildTree, childTreeCache)).map(t -> t.normalizeForOptimization(variableGenerator)).orElse(newGrandChildTree);
        IQTree distinctTree = this.createDistinctTree(this.iqFactory.createDistinctNode(), newChildTree, treeCache.declareAsNormalizedForOptimizationWithEffect());
        return this.iqTreeTools.createAncestorsUnaryIQTree((ImmutableList<? extends UnaryOperatorNode>)state.getAncestors().reverse(), distinctTree).normalizeForOptimization(variableGenerator);
    }
}

