/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.node.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.model.term.Constant;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.NonFunctionalTerm;
import it.unibz.inf.ontop.model.term.NonVariableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.functionsymbol.FunctionSymbol;
import it.unibz.inf.ontop.substitution.ArgumentSubstitution;
import it.unibz.inf.ontop.substitution.InjectiveSubstitution;
import it.unibz.inf.ontop.substitution.Substitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.CoreUtilsFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public class VariableNullabilityImpl
implements VariableNullability {
    private final ImmutableSet<ImmutableSet<Variable>> nullableGroups;
    private final ImmutableSet<Variable> scope;
    private final CoreUtilsFactory coreUtilsFactory;
    private final TermFactory termFactory;
    private final SubstitutionFactory substitutionFactory;
    private @Nullable ImmutableSet<Variable> nullableVariables;
    private @Nullable ImmutableMap<Variable, Integer> variableMap;

    @AssistedInject
    private VariableNullabilityImpl(@Assisted(value="nullableGroups") ImmutableSet<ImmutableSet<Variable>> nullableGroups, @Assisted(value="scope") ImmutableSet<Variable> scope, CoreUtilsFactory coreUtilsFactory, TermFactory termFactory, SubstitutionFactory substitutionFactory) {
        this.nullableGroups = nullableGroups;
        this.scope = scope;
        this.coreUtilsFactory = coreUtilsFactory;
        this.termFactory = termFactory;
        this.substitutionFactory = substitutionFactory;
    }

    @AssistedInject
    private VariableNullabilityImpl(@Assisted ImmutableSet<Variable> scope, CoreUtilsFactory coreUtilsFactory, TermFactory termFactory, SubstitutionFactory substitutionFactory) {
        this((ImmutableSet<ImmutableSet<Variable>>)ImmutableSet.of(), scope, coreUtilsFactory, termFactory, substitutionFactory);
    }

    @AssistedInject
    private VariableNullabilityImpl(@Assisted ImmutableFunctionalTerm functionalTerm, CoreUtilsFactory coreUtilsFactory, TermFactory termFactory, SubstitutionFactory substitutionFactory) {
        this(functionalTerm.getVariableStream(), coreUtilsFactory, termFactory, substitutionFactory);
    }

    @AssistedInject
    protected VariableNullabilityImpl(@Assisted Stream<Variable> variableStream, CoreUtilsFactory coreUtilsFactory, TermFactory termFactory, SubstitutionFactory substitutionFactory) {
        this.scope = (ImmutableSet)variableStream.collect(ImmutableCollectors.toSet());
        this.nullableGroups = (ImmutableSet)this.scope.stream().map(ImmutableSet::of).collect(ImmutableCollectors.toSet());
        this.coreUtilsFactory = coreUtilsFactory;
        this.termFactory = termFactory;
        this.substitutionFactory = substitutionFactory;
        this.nullableVariables = this.scope;
    }

    @Override
    public boolean isPossiblyNullable(Variable variable) {
        return !this.scope.contains((Object)variable) || this.getNullableVariables().contains((Object)variable);
    }

    @Override
    public ImmutableSet<Variable> getNullableVariables() {
        if (this.nullableVariables == null) {
            this.nullableVariables = (ImmutableSet)this.nullableGroups.stream().flatMap(Collection::stream).collect(ImmutableCollectors.toSet());
        }
        return this.nullableVariables;
    }

    @Override
    public boolean canPossiblyBeNullSeparately(ImmutableSet<Variable> variables) {
        if (this.variableMap == null) {
            this.variableMap = VariableNullabilityImpl.extractVariableMap((ImmutableList<ImmutableSet<Variable>>)ImmutableList.copyOf(this.nullableGroups));
        }
        return variables.stream().filter(arg_0 -> this.variableMap.containsKey(arg_0)).map(arg_0 -> this.variableMap.get(arg_0)).distinct().count() > 1L;
    }

    @Override
    public ImmutableSet<ImmutableSet<Variable>> getNullableGroups() {
        return this.nullableGroups;
    }

    private VariableNullabilityImpl appendNewVariables(ImmutableMap<Variable, Variable> nullabilityBindings, ImmutableSet<Variable> newScope) {
        ImmutableList groupList = ImmutableList.copyOf(this.nullableGroups);
        ImmutableMap<Variable, Integer> originalVariableMap = VariableNullabilityImpl.extractVariableMap((ImmutableList<ImmutableSet<Variable>>)groupList);
        AtomicInteger groupCount = new AtomicInteger(groupList.size());
        ImmutableMultimap<Integer, Variable> newVariableMultimap = nullabilityBindings.entrySet().stream().collect(ImmutableCollectors.toMultimap(e -> ((Variable)e.getKey()).equals(e.getValue()) ? groupCount.getAndIncrement() : ((Integer)originalVariableMap.get(e.getValue())).intValue(), Map.Entry::getKey));
        ImmutableSet newNullableGroups = (ImmutableSet)IntStream.range(0, groupCount.get()).mapToObj(i -> i < groupList.size() ? Sets.union((Set)((Set)groupList.get(i)), (Set)ImmutableSet.copyOf((Collection)newVariableMultimap.get((Object)i))).immutableCopy() : ImmutableSet.copyOf((Collection)newVariableMultimap.get((Object)i))).collect(ImmutableCollectors.toSet());
        return new VariableNullabilityImpl((ImmutableSet<ImmutableSet<Variable>>)newNullableGroups, newScope, this.coreUtilsFactory, this.termFactory, this.substitutionFactory);
    }

    @Override
    public VariableNullability update(Substitution<? extends ImmutableTerm> substitution, ImmutableSet<Variable> newScope) {
        VariableGenerator variableGenerator = this.coreUtilsFactory.createVariableGenerator((Collection<Variable>)Sets.union(substitution.getDomain(), this.getNullableVariables()).immutableCopy());
        return this.update(substitution, newScope, variableGenerator);
    }

    @Override
    public VariableNullability applyFreshRenaming(InjectiveSubstitution<Variable> freshRenamingSubstitution) {
        ImmutableSet<Variable> newScope = this.substitutionFactory.apply(freshRenamingSubstitution, this.scope);
        ImmutableSet newNullableGroups = (ImmutableSet)this.nullableGroups.stream().map(s -> this.substitutionFactory.apply((Substitution<Variable>)freshRenamingSubstitution, (ImmutableSet<Variable>)s)).collect(ImmutableCollectors.toSet());
        return this.coreUtilsFactory.createVariableNullability((ImmutableSet<ImmutableSet<Variable>>)newNullableGroups, newScope);
    }

    @Override
    public VariableNullability extendToExternalVariables(Stream<Variable> possiblyExternalVariables) {
        ImmutableSet externalVariables = (ImmutableSet)possiblyExternalVariables.filter(v -> !this.scope.contains(v)).collect(ImmutableCollectors.toSet());
        if (externalVariables.isEmpty()) {
            return this;
        }
        ImmutableSet newScope = Sets.union(this.scope, (Set)externalVariables).immutableCopy();
        ImmutableSet newNullableGroups = (ImmutableSet)Stream.concat(externalVariables.stream().map(ImmutableSet::of), this.nullableGroups.stream()).collect(ImmutableCollectors.toSet());
        return this.coreUtilsFactory.createVariableNullability((ImmutableSet<ImmutableSet<Variable>>)newNullableGroups, (ImmutableSet<Variable>)newScope);
    }

    private VariableNullability update(Substitution<?> substitution, ImmutableSet<Variable> newScope, VariableGenerator variableGenerator) {
        VariableNullability nullabilityBeforeProjectingOut = this.splitSubstitution(substitution, variableGenerator).reduce(this, this::updateVariableNullability, (n1, n2) -> {
            throw new MinorOntopInternalBugException("vns are not expected to be combined");
        });
        ImmutableSet nullableGroups = (ImmutableSet)nullabilityBeforeProjectingOut.getNullableGroups().stream().map(g -> Sets.intersection((Set)g, (Set)newScope).immutableCopy()).filter(g -> !g.isEmpty()).collect(ImmutableCollectors.toSet());
        return this.coreUtilsFactory.createVariableNullability((ImmutableSet<ImmutableSet<Variable>>)nullableGroups, newScope);
    }

    private Stream<Substitution<? extends ImmutableTerm>> splitSubstitution(Substitution<? extends ImmutableTerm> substitution, VariableGenerator variableGenerator) {
        ImmutableMap<Variable, SplitImmutableFunctionalTerm> subTermNames = substitution.builder().restrictRangeTo(ImmutableFunctionalTerm.class).toMap((v, t) -> new SplitImmutableFunctionalTerm((ImmutableFunctionalTerm)t, variableGenerator));
        if (subTermNames.values().stream().allMatch(SplitImmutableFunctionalTerm::isEmpty)) {
            return Stream.of(substitution);
        }
        Substitution<ImmutableTerm> parentSubstitution = substitution.builder().restrictRangeTo(ImmutableFunctionalTerm.class).transformOrRetain(arg_0 -> subTermNames.get(arg_0), (t, split) -> split.getSplitTerm()).build();
        Substitution childSubstitution = subTermNames.values().stream().map(SplitImmutableFunctionalTerm::getSubstitution).reduce(this.substitutionFactory.getSubstitution(), this.substitutionFactory::union);
        Stream<Substitution> nonFunctionalSubstitution = Optional.of(substitution.restrictRangeTo(NonFunctionalTerm.class)).filter(s -> !s.isEmpty()).stream();
        return Stream.concat(this.splitSubstitution(childSubstitution, variableGenerator), Stream.concat(Stream.of(parentSubstitution), nonFunctionalSubstitution));
    }

    private VariableNullabilityImpl updateVariableNullability(VariableNullabilityImpl childNullability, Substitution<? extends ImmutableTerm> nonNestedSubstitution) {
        ImmutableMap nullabilityBindings = nonNestedSubstitution.builder().toMapIgnoreOptional((v, t) -> this.evaluateTermNullability((ImmutableTerm)t, childNullability, (Variable)v));
        ImmutableSet newScope = Sets.union(childNullability.scope, nonNestedSubstitution.getDomain()).immutableCopy();
        return childNullability.appendNewVariables(nullabilityBindings, (ImmutableSet<Variable>)newScope);
    }

    private Optional<Variable> evaluateTermNullability(ImmutableTerm term, VariableNullability childNullability, Variable key) {
        if (term instanceof Constant) {
            return term.isNull() ? Optional.of(key) : Optional.empty();
        }
        if (term instanceof Variable) {
            return Optional.of((Variable)term).filter(childNullability::isPossiblyNullable);
        }
        ImmutableFunctionalTerm functionalTerm = (ImmutableFunctionalTerm)term;
        FunctionSymbol.FunctionalTermNullability results = functionalTerm.getFunctionSymbol().evaluateNullability(functionalTerm.getTerms(), childNullability, this.termFactory);
        return results.isNullable() ? Optional.of(results.getBoundVariable().orElse(key)) : Optional.empty();
    }

    private static ImmutableMap<Variable, Integer> extractVariableMap(ImmutableList<ImmutableSet<Variable>> groupList) {
        return IntStream.range(0, groupList.size()).boxed().flatMap(i -> ((ImmutableSet)groupList.get(i.intValue())).stream().map(v -> Maps.immutableEntry((Object)v, (Object)i))).collect(ImmutableCollectors.toMap());
    }

    @Override
    public boolean canPossiblyBeNullSeparately(ImmutableList<? extends ImmutableTerm> terms) {
        ImmutableSet variables = (ImmutableSet)terms.stream().filter(t -> t instanceof Variable).map(t -> (Variable)t).collect(ImmutableCollectors.toSet());
        if (terms.stream().allMatch(t -> t instanceof Variable)) {
            return this.canPossiblyBeNullSeparately((ImmutableSet<Variable>)variables);
        }
        VariableGenerator variableGenerator = this.coreUtilsFactory.createVariableGenerator((Collection)Stream.concat(terms.stream().flatMap(ImmutableTerm::getVariableStream), this.getNullableVariables().stream()).collect(ImmutableCollectors.toSet()));
        Substitution<ImmutableTerm> substitution = terms.stream().filter(t -> t instanceof NonVariableTerm).collect(this.substitutionFactory.toSubstitution(t -> variableGenerator.generateNewVariable(), t -> t));
        VariableNullability newVariableNullability = this.update(substitution, substitution.getDomain(), variableGenerator);
        ImmutableSet newVariables = Sets.union((Set)variables, substitution.getDomain()).immutableCopy();
        return newVariableNullability.canPossiblyBeNullSeparately((ImmutableSet<Variable>)newVariables);
    }

    private final class SplitImmutableFunctionalTerm {
        final ImmutableFunctionalTerm term;
        final ArgumentSubstitution<ImmutableTerm> map;

        SplitImmutableFunctionalTerm(ImmutableFunctionalTerm term, VariableGenerator variableGenerator) {
            this.term = term;
            ImmutableMap m = IntStream.range(0, term.getArity()).filter(i -> term.getTerm(i) instanceof ImmutableFunctionalTerm).mapToObj(i -> Maps.immutableEntry((Object)i, (Object)variableGenerator.generateNewVariable())).collect(ImmutableCollectors.toMap());
            this.map = new ArgumentSubstitution(m, Optional::ofNullable);
        }

        ImmutableFunctionalTerm getSplitTerm() {
            if (this.map.isEmpty()) {
                return this.term;
            }
            return VariableNullabilityImpl.this.termFactory.getImmutableFunctionalTerm(this.term.getFunctionSymbol(), this.map.replaceTerms(this.term.getTerms()));
        }

        Substitution<ImmutableTerm> getSubstitution() {
            return this.map.getSubstitution(VariableNullabilityImpl.this.substitutionFactory, this.term.getTerms());
        }

        boolean isEmpty() {
            return this.map.isEmpty();
        }
    }
}

