/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.node.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.evaluator.TermNullabilityEvaluator;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.exception.InvalidIntermediateQueryException;
import it.unibz.inf.ontop.iq.impl.IQTreeTools;
import it.unibz.inf.ontop.iq.node.JoinOrFilterNode;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.iq.node.impl.CompositeQueryNodeImpl;
import it.unibz.inf.ontop.iq.node.impl.JoinOrFilterVariableNullabilityTools;
import it.unibz.inf.ontop.iq.node.normalization.ConditionSimplifier;
import it.unibz.inf.ontop.iq.request.VariableNonRequirement;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.type.TypeFactory;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Optional;

public abstract class JoinOrFilterNodeImpl
extends CompositeQueryNodeImpl
implements JoinOrFilterNode {
    private final Optional<ImmutableExpression> optionalFilterCondition;
    protected final TermNullabilityEvaluator nullabilityEvaluator;
    protected final TypeFactory typeFactory;
    protected final JoinOrFilterVariableNullabilityTools variableNullabilityTools;
    protected final ConditionSimplifier conditionSimplifier;

    protected JoinOrFilterNodeImpl(Optional<ImmutableExpression> optionalFilterCondition, TermNullabilityEvaluator nullabilityEvaluator, TermFactory termFactory, IntermediateQueryFactory iqFactory, TypeFactory typeFactory, SubstitutionFactory substitutionFactory, JoinOrFilterVariableNullabilityTools variableNullabilityTools, ConditionSimplifier conditionSimplifier, IQTreeTools iqTreeTools) {
        super(substitutionFactory, termFactory, iqFactory, iqTreeTools);
        this.optionalFilterCondition = optionalFilterCondition;
        this.nullabilityEvaluator = nullabilityEvaluator;
        this.typeFactory = typeFactory;
        this.variableNullabilityTools = variableNullabilityTools;
        this.conditionSimplifier = conditionSimplifier;
    }

    @Override
    public Optional<ImmutableExpression> getOptionalFilterCondition() {
        return this.optionalFilterCondition;
    }

    protected String getOptionalFilterString() {
        return this.getOptionalFilterCondition().map(f -> " " + f).orElse("");
    }

    @Override
    public ImmutableSet<Variable> getLocalVariables() {
        return this.getOptionalFilterCondition().map(ImmutableFunctionalTerm::getVariables).orElse(ImmutableSet.of());
    }

    protected boolean isFilteringNullValue(Variable variable) {
        return this.getOptionalFilterCondition().filter(e -> this.nullabilityEvaluator.isFilteringNullValue((ImmutableExpression)e, variable)).isPresent();
    }

    @Override
    public ImmutableSet<Variable> getLocallyRequiredVariables() {
        return this.getLocalVariables();
    }

    @Override
    public ImmutableSet<Variable> getLocallyDefinedVariables() {
        return ImmutableSet.of();
    }

    protected void checkExpression(ImmutableExpression expression, ImmutableList<IQTree> children) throws InvalidIntermediateQueryException {
        ImmutableSet<Variable> childrenVariables = this.iqTreeTools.getChildrenVariables(children);
        ImmutableSet unboundVariables = (ImmutableSet)expression.getVariableStream().filter(v -> !childrenVariables.contains(v)).collect(ImmutableCollectors.toSet());
        if (!unboundVariables.isEmpty()) {
            throw new InvalidIntermediateQueryException("Expression " + expression + " of " + expression + " uses unbound variables (" + unboundVariables + ").\n" + this);
        }
    }

    protected VariableNonRequirement applyFilterToVariableNonRequirement(VariableNonRequirement nonRequirementBeforeFilter, ImmutableList<IQTree> children) {
        return this.applyFilterToVariableNonRequirement(nonRequirementBeforeFilter);
    }

    protected VariableNonRequirement applyFilterToVariableNonRequirement(VariableNonRequirement nonRequirementBeforeFilter) {
        ImmutableSet<Variable> filterVariables = this.getLocallyRequiredVariables();
        return nonRequirementBeforeFilter.filter((v, conds) -> !filterVariables.contains(v));
    }

    protected boolean isDistinct(IQTree tree, ImmutableList<IQTree> children) {
        if (children.stream().noneMatch(child -> JoinOrFilterNodeImpl.mayChildCauseParentBeingNonDistinct(tree, child))) {
            return true;
        }
        ImmutableSet<ImmutableSet<Variable>> constraints = tree.inferUniqueConstraints();
        if (constraints.isEmpty()) {
            return false;
        }
        VariableNullability variableNullability = tree.getVariableNullability();
        return constraints.stream().anyMatch(c -> c.stream().noneMatch(variableNullability::isPossiblyNullable));
    }

    private static boolean mayChildCauseParentBeingNonDistinct(IQTree parentTree, IQTree child) {
        if (child.isDistinct()) {
            return false;
        }
        VariableNullability parentVariableNullability = parentTree.getVariableNullability();
        return child.inferUniqueConstraints().stream().noneMatch(c -> c.stream().noneMatch(parentVariableNullability::isPossiblyNullable));
    }
}

