/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.node.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Multiset;
import com.google.common.collect.Sets;
import it.unibz.inf.ontop.evaluator.TermNullabilityEvaluator;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.exception.InvalidIntermediateQueryException;
import it.unibz.inf.ontop.iq.impl.IQTreeTools;
import it.unibz.inf.ontop.iq.node.JoinLikeNode;
import it.unibz.inf.ontop.iq.node.impl.JoinOrFilterNodeImpl;
import it.unibz.inf.ontop.iq.node.impl.JoinOrFilterVariableNullabilityTools;
import it.unibz.inf.ontop.iq.node.normalization.ConditionSimplifier;
import it.unibz.inf.ontop.iq.request.VariableNonRequirement;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.type.TypeFactory;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public abstract class JoinLikeNodeImpl
extends JoinOrFilterNodeImpl
implements JoinLikeNode {
    protected JoinLikeNodeImpl(Optional<ImmutableExpression> optionalJoinCondition, TermNullabilityEvaluator nullabilityEvaluator, TermFactory termFactory, IntermediateQueryFactory iqFactory, TypeFactory typeFactory, SubstitutionFactory substitutionFactory, JoinOrFilterVariableNullabilityTools variableNullabilityTools, ConditionSimplifier conditionSimplifier, IQTreeTools iqTreeTools) {
        super(optionalJoinCondition, nullabilityEvaluator, termFactory, iqFactory, typeFactory, substitutionFactory, variableNullabilityTools, conditionSimplifier, iqTreeTools);
    }

    protected void checkNonProjectedVariables(ImmutableList<IQTree> children) throws InvalidIntermediateQueryException {
        HashSet allVariables = new HashSet();
        children.forEach(c -> allVariables.addAll(c.getVariables()));
        for (IQTree child : children) {
            ImmutableSet<Variable> childProjectedVariables = child.getVariables();
            Sets.SetView childNonProjectedVariables = Sets.difference(child.getKnownVariables(), childProjectedVariables);
            Sets.SetView conflictingVariables = Sets.intersection((Set)childNonProjectedVariables, allVariables);
            if (!conflictingVariables.isEmpty()) {
                throw new InvalidIntermediateQueryException("The following non-projected variables " + (Set)conflictingVariables + " are appearing in different children of " + this + ": \n" + children.stream().filter(arg_0 -> JoinLikeNodeImpl.lambda$checkNonProjectedVariables$1((Set)conflictingVariables, arg_0)).map(c -> "\n" + c).collect(ImmutableCollectors.toList()));
            }
            allVariables.addAll(childNonProjectedVariables);
        }
    }

    protected VariableNonRequirement computeVariableNonRequirement(ImmutableList<IQTree> children) {
        ImmutableMultimap childRequirementMultimap = children.stream().map(IQTree::getVariableNonRequirement).flatMap(r -> r.getNotRequiredVariables().stream().map(v -> Maps.immutableEntry((Object)v, r.getCondition((Variable)v)))).collect(ImmutableCollectors.toMultimap());
        ImmutableMap<Variable, ImmutableSet> candidates = childRequirementMultimap.asMap().entrySet().stream().filter(e -> ((Collection)e.getValue()).size() == 1).collect(ImmutableCollectors.toMap(Map.Entry::getKey, e -> (ImmutableSet)((Collection)e.getValue()).iterator().next()));
        if (candidates.isEmpty()) {
            return VariableNonRequirement.empty();
        }
        ImmutableMultiset childVariableMultiset = (ImmutableMultiset)children.stream().flatMap(c -> c.getVariables().stream()).collect(ImmutableCollectors.toMultiset());
        ImmutableSet notSharedVariables = (ImmutableSet)childVariableMultiset.entrySet().stream().filter(e -> e.getCount() == 1).map(Multiset.Entry::getElement).collect(ImmutableCollectors.toSet());
        VariableNonRequirement nonRequirementBeforeFilter = VariableNonRequirement.of(candidates.entrySet().stream().filter(e -> notSharedVariables.contains(e.getKey())).collect(ImmutableCollectors.toMap()));
        return this.getOptionalFilterCondition().map(f -> this.applyFilterToVariableNonRequirement(nonRequirementBeforeFilter, children)).orElse(nonRequirementBeforeFilter);
    }

    private static /* synthetic */ boolean lambda$checkNonProjectedVariables$1(Set conflictingVariables, IQTree c) {
        return !Sets.intersection(c.getKnownVariables(), (Set)conflictingVariables).isEmpty();
    }
}

