/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.node.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import it.unibz.inf.ontop.evaluator.TermNullabilityEvaluator;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.IQTreeCache;
import it.unibz.inf.ontop.iq.UnaryIQTree;
import it.unibz.inf.ontop.iq.exception.InvalidIntermediateQueryException;
import it.unibz.inf.ontop.iq.exception.QueryNodeTransformationException;
import it.unibz.inf.ontop.iq.impl.IQTreeTools;
import it.unibz.inf.ontop.iq.node.FilterNode;
import it.unibz.inf.ontop.iq.node.QueryNode;
import it.unibz.inf.ontop.iq.node.QueryNodeVisitor;
import it.unibz.inf.ontop.iq.node.UnionNode;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.iq.node.impl.JoinOrFilterNodeImpl;
import it.unibz.inf.ontop.iq.node.impl.JoinOrFilterVariableNullabilityTools;
import it.unibz.inf.ontop.iq.node.impl.UnsatisfiableConditionException;
import it.unibz.inf.ontop.iq.node.normalization.ConditionSimplifier;
import it.unibz.inf.ontop.iq.node.normalization.FilterNormalizer;
import it.unibz.inf.ontop.iq.request.FunctionalDependencies;
import it.unibz.inf.ontop.iq.request.VariableNonRequirement;
import it.unibz.inf.ontop.iq.transform.IQTreeExtendedTransformer;
import it.unibz.inf.ontop.iq.transform.IQTreeVisitingTransformer;
import it.unibz.inf.ontop.iq.transform.node.HomogeneousQueryNodeTransformer;
import it.unibz.inf.ontop.iq.visit.IQVisitor;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.NonVariableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.VariableOrGroundTerm;
import it.unibz.inf.ontop.model.type.TypeFactory;
import it.unibz.inf.ontop.substitution.InjectiveSubstitution;
import it.unibz.inf.ontop.substitution.Substitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.CoreUtilsFactory;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.Optional;

public class FilterNodeImpl
extends JoinOrFilterNodeImpl
implements FilterNode {
    private static final String FILTER_NODE_STR = "FILTER";
    private final CoreUtilsFactory coreUtilsFactory;
    private final FilterNormalizer normalizer;

    @AssistedInject
    private FilterNodeImpl(@Assisted ImmutableExpression filterCondition, TermNullabilityEvaluator nullabilityEvaluator, TermFactory termFactory, TypeFactory typeFactory, SubstitutionFactory substitutionFactory, IntermediateQueryFactory iqFactory, IQTreeTools iqTreeTools, ConditionSimplifier conditionSimplifier, CoreUtilsFactory coreUtilsFactory, FilterNormalizer normalizer, JoinOrFilterVariableNullabilityTools variableNullabilityTools) {
        super(Optional.of(filterCondition), nullabilityEvaluator, termFactory, iqFactory, typeFactory, substitutionFactory, variableNullabilityTools, conditionSimplifier, iqTreeTools);
        this.coreUtilsFactory = coreUtilsFactory;
        this.normalizer = normalizer;
    }

    @Override
    public void acceptVisitor(QueryNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public FilterNode acceptNodeTransformer(HomogeneousQueryNodeTransformer transformer) throws QueryNodeTransformationException {
        return transformer.transform(this);
    }

    @Override
    public ImmutableExpression getFilterCondition() {
        return this.getOptionalFilterCondition().get();
    }

    @Override
    public FilterNode changeFilterCondition(ImmutableExpression newFilterCondition) {
        return this.iqFactory.createFilterNode(newFilterCondition);
    }

    @Override
    public VariableNullability getVariableNullability(IQTree child) {
        return this.variableNullabilityTools.updateWithFilter(this.getFilterCondition(), child.getVariableNullability().getNullableGroups(), child.getVariables());
    }

    @Override
    public IQTree liftIncompatibleDefinitions(Variable variable, IQTree child, VariableGenerator variableGenerator) {
        UnionNode unionNode;
        IQTree newChild = child.liftIncompatibleDefinitions(variable, variableGenerator);
        QueryNode newChildRoot = newChild.getRootNode();
        if (newChildRoot instanceof UnionNode && (unionNode = (UnionNode)newChildRoot).hasAChildWithLiftableDefinition(variable, newChild.getChildren())) {
            ImmutableList<IQTree> newChildren = this.iqTreeTools.createUnaryOperatorChildren(this, newChild);
            return this.iqFactory.createNaryIQTree(unionNode, newChildren);
        }
        return this.iqFactory.createUnaryIQTree(this, newChild);
    }

    @Override
    public IQTree propagateDownConstraint(ImmutableExpression constraint, IQTree child, VariableGenerator variableGenerator) {
        try {
            VariableNullability extendedChildVariableNullability = child.getVariableNullability().extendToExternalVariables(constraint.getVariableStream());
            ConditionSimplifier.ExpressionAndSubstitution conditionSimplificationResults = this.conditionSimplifier.simplifyCondition(this.getFilterCondition(), (ImmutableList<IQTree>)ImmutableList.of((Object)child), extendedChildVariableNullability);
            Optional<ImmutableExpression> downConstraint = this.conditionSimplifier.computeDownConstraint(Optional.of(constraint), conditionSimplificationResults, extendedChildVariableNullability);
            IQTree newChild = Optional.of(conditionSimplificationResults.getSubstitution()).filter(s -> !s.isEmpty()).map(s -> child.applyDescendingSubstitution((Substitution<? extends VariableOrGroundTerm>)s, downConstraint, variableGenerator)).orElseGet(() -> downConstraint.map(c -> child.propagateDownConstraint((ImmutableExpression)c, variableGenerator)).orElse(child));
            Optional<FilterNode> filterNode = conditionSimplificationResults.getOptionalExpression().map(e -> e.equals(this.getFilterCondition()) ? this : this.iqFactory.createFilterNode((ImmutableExpression)e));
            IQTree filterLevelTree = this.iqTreeTools.createOptionalUnaryIQTree(filterNode, newChild);
            return this.iqTreeTools.createConstructionNodeTreeIfNontrivial(filterLevelTree, conditionSimplificationResults.getSubstitution(), child::getVariables);
        }
        catch (UnsatisfiableConditionException e2) {
            return this.iqFactory.createEmptyNode(child.getVariables());
        }
    }

    @Override
    public IQTree acceptTransformer(IQTree tree, IQTreeVisitingTransformer transformer, IQTree child) {
        return transformer.transformFilter(tree, this, child);
    }

    @Override
    public <T> IQTree acceptTransformer(IQTree tree, IQTreeExtendedTransformer<T> transformer, IQTree child, T context) {
        return transformer.transformFilter(tree, this, child, context);
    }

    @Override
    public <T> T acceptVisitor(IQVisitor<T> visitor, IQTree child) {
        return visitor.visitFilter(this, child);
    }

    @Override
    public void validateNode(IQTree child) throws InvalidIntermediateQueryException {
        this.checkExpression(this.getFilterCondition(), (ImmutableList<IQTree>)ImmutableList.of((Object)child));
    }

    @Override
    public ImmutableSet<Substitution<NonVariableTerm>> getPossibleVariableDefinitions(IQTree child) {
        return child.getPossibleVariableDefinitions();
    }

    @Override
    public IQTree removeDistincts(IQTree child, IQTreeCache treeCache) {
        IQTree newChild = child.removeDistincts();
        IQTreeCache newTreeCache = treeCache.declareDistinctRemoval(newChild.equals(child));
        return this.iqFactory.createUnaryIQTree(this, newChild, newTreeCache);
    }

    @Override
    public ImmutableSet<ImmutableSet<Variable>> inferUniqueConstraints(IQTree child) {
        return child.inferUniqueConstraints();
    }

    @Override
    public FunctionalDependencies inferFunctionalDependencies(IQTree child, ImmutableSet<ImmutableSet<Variable>> uniqueConstraints, ImmutableSet<Variable> variables) {
        return child.inferFunctionalDependencies();
    }

    @Override
    public VariableNonRequirement computeVariableNonRequirement(IQTree child) {
        return this.applyFilterToVariableNonRequirement(child.getVariableNonRequirement());
    }

    @Override
    public ImmutableSet<Variable> inferStrictDependents(UnaryIQTree tree, IQTree child) {
        return child.inferStrictDependents();
    }

    @Override
    public boolean isConstructed(Variable variable, IQTree child) {
        return child.isConstructed(variable);
    }

    @Override
    public boolean isDistinct(IQTree tree, IQTree child) {
        return this.isDistinct(tree, (ImmutableList<IQTree>)ImmutableList.of((Object)child));
    }

    @Override
    public int hashCode() {
        return this.getFilterCondition().hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof FilterNodeImpl) {
            FilterNodeImpl that = (FilterNodeImpl)o;
            return this.getFilterCondition().equals(that.getFilterCondition());
        }
        return false;
    }

    public String toString() {
        return FILTER_NODE_STR + this.getOptionalFilterString();
    }

    @Override
    public IQTree normalizeForOptimization(IQTree initialChild, VariableGenerator variableGenerator, IQTreeCache treeCache) {
        return this.normalizer.normalizeForOptimization(this, initialChild, variableGenerator, treeCache);
    }

    @Override
    public IQTree applyDescendingSubstitution(Substitution<? extends VariableOrGroundTerm> descendingSubstitution, Optional<ImmutableExpression> constraint, IQTree child, VariableGenerator variableGenerator) {
        ImmutableExpression unoptimizedExpression = descendingSubstitution.apply(this.getFilterCondition());
        ImmutableSet<Variable> newlyProjectedVariables = this.iqTreeTools.computeNewProjectedVariables(descendingSubstitution, child.getVariables());
        VariableNullability simplifiedFutureChildVariableNullability = this.coreUtilsFactory.createSimplifiedVariableNullability(newlyProjectedVariables.stream());
        try {
            ConditionSimplifier.ExpressionAndSubstitution expressionAndSubstitution = this.conditionSimplifier.simplifyCondition(unoptimizedExpression, (ImmutableList<IQTree>)ImmutableList.of((Object)child), simplifiedFutureChildVariableNullability);
            VariableNullability extendedVariableNullability = constraint.map(c -> simplifiedFutureChildVariableNullability.extendToExternalVariables(c.getVariableStream())).orElse(simplifiedFutureChildVariableNullability);
            Optional<ImmutableExpression> downConstraint = this.conditionSimplifier.computeDownConstraint(constraint, expressionAndSubstitution, extendedVariableNullability);
            Substitution<VariableOrGroundTerm> downSubstitution = this.substitutionFactory.onVariableOrGroundTerms().compose(descendingSubstitution, expressionAndSubstitution.getSubstitution());
            IQTree newChild = child.applyDescendingSubstitution(downSubstitution, downConstraint, variableGenerator);
            Optional<FilterNode> filterNode = expressionAndSubstitution.getOptionalExpression().map(this.iqFactory::createFilterNode);
            IQTree filterLevelTree = this.iqTreeTools.createOptionalUnaryIQTree(filterNode, newChild);
            return this.iqTreeTools.createConstructionNodeTreeIfNontrivial(filterLevelTree, expressionAndSubstitution.getSubstitution(), () -> newlyProjectedVariables);
        }
        catch (UnsatisfiableConditionException e) {
            return this.iqFactory.createEmptyNode(newlyProjectedVariables);
        }
    }

    @Override
    public IQTree applyDescendingSubstitutionWithoutOptimizing(Substitution<? extends VariableOrGroundTerm> descendingSubstitution, IQTree child, VariableGenerator variableGenerator) {
        FilterNode newFilterNode = this.iqFactory.createFilterNode(descendingSubstitution.apply(this.getFilterCondition()));
        return this.iqFactory.createUnaryIQTree(newFilterNode, child.applyDescendingSubstitutionWithoutOptimizing(descendingSubstitution, variableGenerator));
    }

    @Override
    public IQTree applyFreshRenaming(InjectiveSubstitution<Variable> renamingSubstitution, IQTree child, IQTreeCache treeCache) {
        IQTree newChild = child.applyFreshRenaming(renamingSubstitution);
        ImmutableExpression newCondition = renamingSubstitution.apply(this.getFilterCondition());
        FilterNodeImpl newFilterNode = newCondition.equals(this.getFilterCondition()) ? this : this.iqFactory.createFilterNode(newCondition);
        IQTreeCache newTreeCache = treeCache.applyFreshRenaming(renamingSubstitution);
        return this.iqFactory.createUnaryIQTree(newFilterNode, newChild, newTreeCache);
    }
}

