/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.node.impl;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.injection.OntopModelSettings;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.IQTreeCache;
import it.unibz.inf.ontop.iq.UnaryIQTree;
import it.unibz.inf.ontop.iq.exception.InvalidIntermediateQueryException;
import it.unibz.inf.ontop.iq.exception.InvalidQueryNodeException;
import it.unibz.inf.ontop.iq.exception.QueryNodeTransformationException;
import it.unibz.inf.ontop.iq.impl.IQTreeTools;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.iq.node.ExtendedProjectionNode;
import it.unibz.inf.ontop.iq.node.QueryNode;
import it.unibz.inf.ontop.iq.node.QueryNodeVisitor;
import it.unibz.inf.ontop.iq.node.SliceNode;
import it.unibz.inf.ontop.iq.node.TrueNode;
import it.unibz.inf.ontop.iq.node.UnaryOperatorNode;
import it.unibz.inf.ontop.iq.node.UnionNode;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.iq.node.impl.ExtendedProjectionNodeImpl;
import it.unibz.inf.ontop.iq.node.normalization.ConstructionSubstitutionNormalizer;
import it.unibz.inf.ontop.iq.node.normalization.NotRequiredVariableRemover;
import it.unibz.inf.ontop.iq.request.FunctionalDependencies;
import it.unibz.inf.ontop.iq.request.VariableNonRequirement;
import it.unibz.inf.ontop.iq.transform.IQTreeExtendedTransformer;
import it.unibz.inf.ontop.iq.transform.IQTreeVisitingTransformer;
import it.unibz.inf.ontop.iq.transform.node.HomogeneousQueryNodeTransformer;
import it.unibz.inf.ontop.iq.visit.IQVisitor;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.NonVariableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.substitution.InjectiveSubstitution;
import it.unibz.inf.ontop.substitution.Substitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.VariableGenerator;
import it.unibz.inf.ontop.utils.impl.VariableGeneratorImpl;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ConstructionNodeImpl
extends ExtendedProjectionNodeImpl
implements ConstructionNode {
    private static final String CONSTRUCTION_NODE_STR = "CONSTRUCT";
    private final ImmutableSet<Variable> projectedVariables;
    private final Substitution<ImmutableTerm> substitution;
    private final ImmutableSet<Variable> childVariables;
    private final ConstructionSubstitutionNormalizer substitutionNormalizer;
    private final NotRequiredVariableRemover notRequiredVariableRemover;

    @AssistedInject
    private ConstructionNodeImpl(@Assisted ImmutableSet<Variable> projectedVariables, @Assisted Substitution<? extends ImmutableTerm> substitution, SubstitutionFactory substitutionFactory, TermFactory termFactory, IntermediateQueryFactory iqFactory, OntopModelSettings settings, IQTreeTools iqTreeTools, ConstructionSubstitutionNormalizer substitutionNormalizer, NotRequiredVariableRemover notRequiredVariableRemover) {
        super(substitutionFactory, iqFactory, iqTreeTools, termFactory);
        this.projectedVariables = projectedVariables;
        this.substitution = substitutionFactory.covariantCast(substitution);
        this.substitutionNormalizer = substitutionNormalizer;
        this.notRequiredVariableRemover = notRequiredVariableRemover;
        this.childVariables = Sets.difference((Set)Sets.union(this.projectedVariables, this.substitution.getRangeVariables()), this.substitution.getDomain()).immutableCopy();
        if (settings.isTestModeEnabled()) {
            this.validateNode();
        }
    }

    @AssistedInject
    private ConstructionNodeImpl(@Assisted ImmutableSet<Variable> projectedVariables, IQTreeTools iqTreeTools, SubstitutionFactory substitutionFactory, TermFactory termFactory, IntermediateQueryFactory iqFactory, OntopModelSettings settings, ConstructionSubstitutionNormalizer substitutionNormalizer, NotRequiredVariableRemover notRequiredVariableRemover) {
        this(projectedVariables, substitutionFactory.getSubstitution(), substitutionFactory, termFactory, iqFactory, settings, iqTreeTools, substitutionNormalizer, notRequiredVariableRemover);
    }

    private void validateNode() throws InvalidQueryNodeException {
        ImmutableSet<Variable> substitutionDomain = this.substitution.getDomain();
        if (!this.projectedVariables.containsAll(substitutionDomain)) {
            throw new InvalidQueryNodeException("ConstructionNode: all the domain variables of the substitution must be projected.\n" + this);
        }
        if (!Sets.intersection(substitutionDomain, this.childVariables).isEmpty()) {
            throw new InvalidQueryNodeException("ConstructionNode: variables defined by the substitution cannot be used for defining other variables.\n" + this);
        }
        if (!Sets.difference(this.substitution.restrictRangeTo(Variable.class).getRangeSet(), this.projectedVariables).isEmpty()) {
            throw new InvalidQueryNodeException("ConstructionNode: substituting a variable by a non-projected variable is incorrect.\n" + this);
        }
    }

    @Override
    public ImmutableSet<Variable> getVariables() {
        return this.projectedVariables;
    }

    @Override
    public Substitution<ImmutableTerm> getSubstitution() {
        return this.substitution;
    }

    @Override
    public ConstructionNode acceptNodeTransformer(HomogeneousQueryNodeTransformer transformer) throws QueryNodeTransformationException {
        return transformer.transform(this);
    }

    @Override
    public ImmutableSet<Variable> getChildVariables() {
        return this.childVariables;
    }

    @Override
    public ImmutableSet<Variable> getLocalVariables() {
        return Sets.union(this.projectedVariables, this.substitution.getRangeVariables()).immutableCopy();
    }

    @Override
    public boolean isDistinct(IQTree tree, IQTree child) {
        ImmutableSet<ImmutableSet<Variable>> ucs = this.inferUniqueConstraints(child);
        if (!ucs.isEmpty()) {
            VariableNullability variableNullability = tree.getVariableNullability();
            if (ucs.stream().anyMatch(uc -> uc.stream().noneMatch(variableNullability::isPossiblyNullable))) {
                return true;
            }
        }
        if (child instanceof TrueNode) {
            return true;
        }
        QueryNode childRoot = child.getRootNode();
        return childRoot instanceof SliceNode && ((SliceNode)childRoot).getLimit().filter(l -> l == 1L).isPresent();
    }

    @Override
    public IQTree liftIncompatibleDefinitions(Variable variable, IQTree child, VariableGenerator variableGenerator) {
        if (!this.childVariables.contains((Object)variable)) {
            return this.iqFactory.createUnaryIQTree(this, child);
        }
        IQTree newChild = child.liftIncompatibleDefinitions(variable, variableGenerator);
        QueryNode newChildRoot = newChild.getRootNode();
        if (newChildRoot instanceof UnionNode && ((UnionNode)newChildRoot).hasAChildWithLiftableDefinition(variable, newChild.getChildren())) {
            ImmutableList<IQTree> newChildren = this.iqTreeTools.createUnaryOperatorChildren(this, newChild);
            return this.iqFactory.createNaryIQTree(this.iqFactory.createUnionNode(this.getVariables()), newChildren);
        }
        return this.iqFactory.createUnaryIQTree(this, newChild);
    }

    @Override
    public IQTree acceptTransformer(IQTree tree, IQTreeVisitingTransformer transformer, IQTree child) {
        return transformer.transformConstruction(tree, this, child);
    }

    @Override
    public <T> IQTree acceptTransformer(IQTree tree, IQTreeExtendedTransformer<T> transformer, IQTree child, T context) {
        return transformer.transformConstruction(tree, this, child, context);
    }

    @Override
    public <T> T acceptVisitor(IQVisitor<T> visitor, IQTree child) {
        return visitor.visitConstruction(this, child);
    }

    @Override
    public void validateNode(IQTree child) throws InvalidQueryNodeException, InvalidIntermediateQueryException {
        this.validateNode();
        ImmutableSet<Variable> requiredChildVariables = this.getChildVariables();
        if (!child.getVariables().containsAll(requiredChildVariables)) {
            throw new InvalidIntermediateQueryException("This child " + child + " does not project all the variables required by the CONSTRUCTION node (" + requiredChildVariables + ")\n" + this);
        }
    }

    @Override
    public ImmutableSet<Substitution<NonVariableTerm>> getPossibleVariableDefinitions(IQTree child) {
        ImmutableSet<Substitution<NonVariableTerm>> childDefs = child.getPossibleVariableDefinitions();
        if (childDefs.isEmpty()) {
            Substitution<NonVariableTerm> def = this.substitution.restrictRangeTo(NonVariableTerm.class);
            return def.isEmpty() ? ImmutableSet.of() : ImmutableSet.of(def);
        }
        return (ImmutableSet)childDefs.stream().map(childDef -> childDef.compose(this.substitution)).map(s -> s.builder().restrictDomainTo((Set<Variable>)this.projectedVariables).restrictRangeTo(NonVariableTerm.class).build()).collect(ImmutableCollectors.toSet());
    }

    @Override
    public IQTree removeDistincts(IQTree child, IQTreeCache treeCache) {
        IQTree newChild = child.removeDistincts();
        IQTreeCache newTreeCache = treeCache.declareDistinctRemoval(newChild.equals(child));
        return this.iqFactory.createUnaryIQTree(this, newChild, newTreeCache);
    }

    @Override
    public ImmutableSet<ImmutableSet<Variable>> inferUniqueConstraints(IQTree child) {
        if (child instanceof TrueNode) {
            return (ImmutableSet)this.projectedVariables.stream().map(ImmutableSet::of).collect(ImmutableCollectors.toSet());
        }
        ImmutableSet<ImmutableSet<Variable>> childConstraints = child.inferUniqueConstraints();
        if (childConstraints.isEmpty()) {
            return ImmutableSet.of();
        }
        ImmutableSet preservedConstraints = (ImmutableSet)childConstraints.stream().filter(arg_0 -> this.projectedVariables.containsAll(arg_0)).collect(ImmutableCollectors.toSet());
        if (this.substitution.isEmpty()) {
            return preservedConstraints;
        }
        VariableNullability variableNullability = this.getVariableNullability(child);
        ImmutableMap<Variable, ImmutableSet<Variable>> determinedByMap = this.getDeterminedByMap(variableNullability);
        ImmutableSet transformedConstraints = (ImmutableSet)childConstraints.stream().flatMap(childConstraint -> this.extractTransformedUniqueConstraint((ImmutableSet<Variable>)childConstraint, determinedByMap)).collect(ImmutableCollectors.toSet());
        return transformedConstraints.isEmpty() ? preservedConstraints : (preservedConstraints.isEmpty() ? transformedConstraints : Sets.union((Set)preservedConstraints, (Set)transformedConstraints).immutableCopy());
    }

    private Stream<ImmutableSet<Variable>> extractTransformedUniqueConstraint(ImmutableSet<Variable> childConstraint, ImmutableMap<Variable, ImmutableSet<Variable>> determinedByMap) {
        return this.getNewRepresentations(childConstraint, determinedByMap).stream();
    }

    private ImmutableMap<Variable, ImmutableSet<Variable>> getDeterminedByMap(VariableNullability variableNullability) {
        return this.projectedVariables.stream().collect(ImmutableCollectors.toMap(v -> v, v -> this.getDeterminedBy(this.substitution.apply((Variable)v), variableNullability)));
    }

    private ImmutableSet<Variable> getDeterminedBy(ImmutableTerm term, VariableNullability variableNullability) {
        if (term instanceof Variable) {
            return ImmutableSet.of((Object)((Variable)term));
        }
        if (term instanceof ImmutableFunctionalTerm) {
            ImmutableFunctionalTerm functionalTerm = (ImmutableFunctionalTerm)term;
            VariableGeneratorImpl uselessVariableGenerator = new VariableGeneratorImpl((Collection<Variable>)ImmutableSet.of(), this.termFactory);
            Optional<ImmutableFunctionalTerm.FunctionalTermDecomposition> analysis = functionalTerm.analyzeInjectivity((ImmutableSet<Variable>)ImmutableSet.of(), variableNullability, uselessVariableGenerator);
            return (ImmutableSet)analysis.map(t -> t.getLiftableTerm().getVariableStream()).orElse(Stream.of(new Variable[0])).filter(v -> term.getVariableStream().anyMatch(v::equals)).collect(ImmutableCollectors.toSet());
        }
        return ImmutableSet.of();
    }

    private ImmutableSet<ImmutableSet<Variable>> getNewRepresentations(ImmutableSet<Variable> previousUC, ImmutableMap<Variable, ImmutableSet<Variable>> determinedByMap) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        ImmutableSet relatedVariables = (ImmutableSet)this.projectedVariables.stream().filter(v -> previousUC.contains(v) || !Sets.intersection((Set)previousUC, (Set)((Set)determinedByMap.get(v))).isEmpty()).collect(ImmutableCollectors.toSet());
        if (!ConstructionNodeImpl.includesAll((ImmutableCollection<Variable>)relatedVariables, previousUC, determinedByMap)) {
            return ImmutableSet.of();
        }
        List setsToCheck = relatedVariables.stream().map(ImmutableList::of).collect(Collectors.toList());
        while (!setsToCheck.isEmpty()) {
            ImmutableList next = (ImmutableList)setsToCheck.remove(0);
            if (ConstructionNodeImpl.includesAll((ImmutableCollection<Variable>)next, previousUC, determinedByMap)) {
                builder.add((Object)((ImmutableSet)next.stream().collect(ImmutableCollectors.toSet())));
                continue;
            }
            setsToCheck.addAll(relatedVariables.stream().filter(v -> v.getName().compareTo(((Variable)next.get(next.size() - 1)).getName()) > 0).filter(v -> !ConstructionNodeImpl.includesAll((ImmutableCollection<Variable>)next, (ImmutableSet<Variable>)((ImmutableSet)determinedByMap.get(v)), determinedByMap)).map(v -> (ImmutableList)Stream.concat(next.stream(), Stream.of(v)).collect(ImmutableCollectors.toList())).collect(Collectors.toSet()));
        }
        ImmutableSet result = builder.build();
        return (ImmutableSet)result.stream().filter(uc -> result.stream().noneMatch(uc2 -> uc.containsAll((Collection)uc2) && !uc.equals(uc2))).collect(ImmutableCollectors.toSet());
    }

    private static boolean includesAll(ImmutableCollection<Variable> variables, ImmutableSet<Variable> target, ImmutableMap<Variable, ImmutableSet<Variable>> determinedByMap) {
        return ((ImmutableSet)variables.stream().flatMap(v -> Optional.ofNullable((ImmutableSet)determinedByMap.get(v)).orElseThrow().stream()).collect(ImmutableSet.toImmutableSet())).containsAll(target);
    }

    private boolean isAtomicConstraint(ImmutableFunctionalTerm functionalTerm, ImmutableSet<Variable> childConstraint, VariableNullability variableNullability) {
        if (!functionalTerm.getVariables().containsAll(childConstraint)) {
            return false;
        }
        VariableGeneratorImpl uselessVariableGenerator = new VariableGeneratorImpl((Collection<Variable>)ImmutableSet.of(), this.termFactory);
        Optional<ImmutableFunctionalTerm.FunctionalTermDecomposition> analysis = functionalTerm.analyzeInjectivity((ImmutableSet<Variable>)ImmutableSet.of(), variableNullability, uselessVariableGenerator);
        return analysis.map(ImmutableFunctionalTerm.FunctionalTermDecomposition::getLiftableTerm).filter(t -> ((ImmutableSet)t.getVariableStream().collect(ImmutableCollectors.toSet())).containsAll((Collection)childConstraint)).isPresent();
    }

    @Override
    public FunctionalDependencies inferFunctionalDependencies(IQTree child, ImmutableSet<ImmutableSet<Variable>> uniqueConstraints, ImmutableSet<Variable> variables) {
        FunctionalDependencies childFDs = child.inferFunctionalDependencies();
        VariableNullability nullability = this.getVariableNullability(child);
        ImmutableMap<Variable, ImmutableSet<Variable>> determinedByMap = this.getDeterminedByMap(nullability);
        return Stream.concat(childFDs.stream(), this.newDependenciesFromSubstitution(nullability)).flatMap(e -> this.translateFunctionalDependency((ImmutableSet<Variable>)((ImmutableSet)e.getKey()), (ImmutableSet<Variable>)((ImmutableSet)e.getValue()), determinedByMap)).collect(FunctionalDependencies.toFunctionalDependencies()).concat(FunctionalDependencies.fromUniqueConstraints(uniqueConstraints, variables));
    }

    private Stream<Map.Entry<ImmutableSet<Variable>, ImmutableSet<Variable>>> newDependenciesFromSubstitution(VariableNullability nullability) {
        Stream<Map.Entry> variableToSubstitution = this.substitution.stream().filter(e -> ConstructionNodeImpl.isDeterministic((ImmutableTerm)e.getValue())).map(e -> Maps.immutableEntry((Object)((ImmutableSet)((ImmutableTerm)e.getValue()).getVariableStream().collect(ImmutableCollectors.toSet())), (Object)ImmutableSet.of((Object)((Variable)e.getKey())))).filter(e -> !((ImmutableSet)e.getKey()).isEmpty());
        Stream<Map.Entry> substitutionToVariable = this.substitution.restrictRangeTo(ImmutableFunctionalTerm.class).stream().filter(e -> this.isAtomicConstraint((ImmutableFunctionalTerm)e.getValue(), ((ImmutableFunctionalTerm)e.getValue()).getVariables(), nullability)).map(e -> Maps.immutableEntry((Object)ImmutableSet.of((Object)((Variable)e.getKey())), ((ImmutableFunctionalTerm)e.getValue()).getVariables())).filter(e -> !((ImmutableSet)e.getValue()).isEmpty());
        Stream<Map.Entry> renamingDependencies = this.substitution.restrictRangeTo(Variable.class).stream().map(e -> Maps.immutableEntry((Object)ImmutableSet.of((Object)((Variable)e.getKey())), (Object)ImmutableSet.of((Object)((Variable)e.getValue()))));
        return Streams.concat((Stream[])new Stream[]{variableToSubstitution, substitutionToVariable, renamingDependencies});
    }

    private Stream<Map.Entry<ImmutableSet<Variable>, ImmutableSet<Variable>>> translateFunctionalDependency(ImmutableSet<Variable> determinants, ImmutableSet<Variable> dependents, ImmutableMap<Variable, ImmutableSet<Variable>> determinedByMap) {
        ImmutableSet<Variable> newDependents;
        Sets.SetView keptDependents = Sets.intersection(dependents, this.projectedVariables);
        Sets.SetView allDependents = Sets.union((Set)keptDependents, newDependents = this.substitution.builder().restrictRange(t -> t.getVariableStream().allMatch(arg_0 -> ((ImmutableSet)dependents).contains(arg_0)) && ConstructionNodeImpl.isDeterministic(t)).build().getDomain());
        if (allDependents.isEmpty()) {
            return Stream.of(new Map.Entry[0]);
        }
        Stream<ImmutableSet<Variable>> preservedDeterminants = this.projectedVariables.containsAll(determinants) ? Stream.of(determinants) : Stream.of(new ImmutableSet[0]);
        Stream<ImmutableSet<Variable>> newDeterminants = this.extractTransformedUniqueConstraint(determinants, determinedByMap);
        Stream allDeterminants = Streams.concat((Stream[])new Stream[]{preservedDeterminants, newDeterminants});
        return allDeterminants.map(arg_0 -> ConstructionNodeImpl.lambda$translateFunctionalDependency$26((Set)allDependents, arg_0)).filter(e -> !((ImmutableSet)e.getValue()).isEmpty());
    }

    private static boolean isDeterministic(ImmutableTerm term) {
        if (!(term instanceof ImmutableFunctionalTerm)) {
            return true;
        }
        ImmutableFunctionalTerm f = (ImmutableFunctionalTerm)term;
        if (!f.getFunctionSymbol().isDeterministic()) {
            return false;
        }
        return f.getTerms().stream().allMatch(t -> ConstructionNodeImpl.isDeterministic(t));
    }

    @Override
    public VariableNonRequirement computeVariableNonRequirement(IQTree child) {
        return VariableNonRequirement.of(this.getVariables());
    }

    @Override
    public ImmutableSet<Variable> inferStrictDependents(UnaryIQTree tree, IQTree child) {
        ImmutableSet<Variable> childStrictDependents = child.inferStrictDependents();
        if (childStrictDependents.isEmpty()) {
            VariableNullability nullability = this.getVariableNullability(child);
            return (ImmutableSet)this.newDependenciesFromSubstitution(nullability).filter(e -> this.projectedVariables.containsAll((Collection)e.getKey())).flatMap(e -> ((ImmutableSet)e.getValue()).stream()).collect(ImmutableSet.toImmutableSet());
        }
        Sets.SetView childDeterminants = Sets.difference(child.getVariables(), childStrictDependents);
        if (this.projectedVariables.containsAll((Collection)childDeterminants)) {
            VariableNullability nullability = this.getVariableNullability(child);
            return (ImmutableSet)Stream.concat(Sets.intersection(childStrictDependents, this.projectedVariables).stream(), this.newDependenciesFromSubstitution(nullability).filter(e -> this.projectedVariables.containsAll((Collection)e.getKey())).flatMap(e -> ((ImmutableSet)e.getValue()).stream())).collect(ImmutableSet.toImmutableSet());
        }
        return IQTreeTools.computeStrictDependentsFromFunctionalDependencies(tree);
    }

    @Override
    public ImmutableSet<Variable> getLocallyRequiredVariables() {
        return this.getChildVariables();
    }

    @Override
    public ImmutableSet<Variable> getLocallyDefinedVariables() {
        return this.substitution.getDomain();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ConstructionNodeImpl) {
            ConstructionNodeImpl that = (ConstructionNodeImpl)o;
            return this.projectedVariables.equals(that.projectedVariables) && this.substitution.equals(that.substitution);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.projectedVariables, this.substitution);
    }

    @Override
    public void acceptVisitor(QueryNodeVisitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        return "CONSTRUCT " + this.projectedVariables + " [" + this.substitution + "]";
    }

    @Override
    public IQTree normalizeForOptimization(IQTree child, VariableGenerator variableGenerator, IQTreeCache treeCache) {
        IQTree liftedChild = child.normalizeForOptimization(variableGenerator);
        IQTree shrunkChild = this.notRequiredVariableRemover.optimize(liftedChild, this.childVariables, variableGenerator);
        QueryNode shrunkChildRoot = shrunkChild.getRootNode();
        if (shrunkChildRoot instanceof ConstructionNode) {
            return this.mergeWithChild((ConstructionNode)shrunkChildRoot, (UnaryIQTree)shrunkChild, treeCache, variableGenerator);
        }
        if (shrunkChild.isDeclaredAsEmpty()) {
            return this.iqFactory.createEmptyNode(this.projectedVariables);
        }
        if (shrunkChild.getVariables().equals(this.projectedVariables)) {
            return shrunkChild;
        }
        ConstructionSubstitutionNormalizer.ConstructionSubstitutionNormalization normalization = this.substitutionNormalizer.normalizeSubstitution(this.substitution.transform(t -> t.simplify(shrunkChild.getVariableNullability())), this.projectedVariables);
        Optional<ConstructionNode> newTopConstructionNode = normalization.generateTopConstructionNode();
        IQTree updatedChild = normalization.updateChild(shrunkChild, variableGenerator);
        IQTree newChild = newTopConstructionNode.map(c -> this.notRequiredVariableRemover.optimize(updatedChild, c.getChildVariables(), variableGenerator)).orElse(updatedChild).normalizeForOptimization(variableGenerator);
        return newTopConstructionNode.map(c -> this.iqFactory.createUnaryIQTree((UnaryOperatorNode)c, newChild, treeCache.declareAsNormalizedForOptimizationWithEffect())).orElseGet(() -> this.iqTreeTools.createConstructionNodeTreeIfNontrivial(newChild, this.projectedVariables));
    }

    @Override
    public IQTree applyFreshRenaming(InjectiveSubstitution<Variable> renamingSubstitution, IQTree child, IQTreeCache treeCache) {
        IQTree newChild = child.applyFreshRenaming(renamingSubstitution);
        ConstructionNode newConstructionNode = this.iqFactory.createConstructionNode(this.substitutionFactory.apply(renamingSubstitution, this.projectedVariables), this.substitutionFactory.rename(renamingSubstitution, this.substitution));
        IQTreeCache newTreeCache = treeCache.applyFreshRenaming(renamingSubstitution);
        return this.iqFactory.createUnaryIQTree(newConstructionNode, newChild, newTreeCache);
    }

    @Override
    protected Optional<ExtendedProjectionNode> computeNewProjectionNode(ImmutableSet<Variable> newProjectedVariables, Substitution<ImmutableTerm> theta, IQTree newChild) {
        return Optional.of(theta).filter(t -> !t.isEmpty() || !newProjectedVariables.equals(newChild.getVariables())).map(t -> this.iqFactory.createConstructionNode(newProjectedVariables, (Substitution<? extends ImmutableTerm>)t));
    }

    private IQTree mergeWithChild(ConstructionNode childConstructionNode, UnaryIQTree childIQ, IQTreeCache treeCache, VariableGenerator variableGenerator) {
        IQTree grandChild = childIQ.getChild();
        ConstructionSubstitutionNormalizer.ConstructionSubstitutionNormalization substitutionNormalization = this.substitutionNormalizer.normalizeSubstitution(childConstructionNode.getSubstitution().compose(this.substitution).transform(t -> t.simplify(grandChild.getVariableNullability())), this.projectedVariables);
        Substitution<ImmutableTerm> newSubstitution = substitutionNormalization.getNormalizedSubstitution();
        ConstructionNode newConstructionNode = this.iqFactory.createConstructionNode(this.projectedVariables, newSubstitution);
        IQTree updatedGrandChild = substitutionNormalization.updateChild(grandChild, variableGenerator);
        IQTree newGrandChild = this.notRequiredVariableRemover.optimize(updatedGrandChild, newConstructionNode.getChildVariables(), variableGenerator).normalizeForOptimization(variableGenerator);
        return newGrandChild.getVariables().equals(newConstructionNode.getVariables()) ? newGrandChild : this.iqFactory.createUnaryIQTree(newConstructionNode, newGrandChild, treeCache.declareAsNormalizedForOptimizationWithEffect());
    }

    private static /* synthetic */ Map.Entry lambda$translateFunctionalDependency$26(Set allDependents, ImmutableSet determinant) {
        return Maps.immutableEntry((Object)determinant, (Object)Sets.difference((Set)allDependents, (Set)determinant).immutableCopy());
    }
}

