/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.node.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.injection.OntopModelSettings;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.IQTreeCache;
import it.unibz.inf.ontop.iq.UnaryIQTree;
import it.unibz.inf.ontop.iq.exception.InvalidIntermediateQueryException;
import it.unibz.inf.ontop.iq.exception.QueryNodeTransformationException;
import it.unibz.inf.ontop.iq.impl.IQTreeTools;
import it.unibz.inf.ontop.iq.node.AggregationNode;
import it.unibz.inf.ontop.iq.node.ExtendedProjectionNode;
import it.unibz.inf.ontop.iq.node.FilterNode;
import it.unibz.inf.ontop.iq.node.QueryNodeVisitor;
import it.unibz.inf.ontop.iq.node.impl.ExtendedProjectionNodeImpl;
import it.unibz.inf.ontop.iq.node.normalization.AggregationNormalizer;
import it.unibz.inf.ontop.iq.request.FunctionalDependencies;
import it.unibz.inf.ontop.iq.request.VariableNonRequirement;
import it.unibz.inf.ontop.iq.transform.IQTreeExtendedTransformer;
import it.unibz.inf.ontop.iq.transform.IQTreeVisitingTransformer;
import it.unibz.inf.ontop.iq.transform.node.HomogeneousQueryNodeTransformer;
import it.unibz.inf.ontop.iq.visit.IQVisitor;
import it.unibz.inf.ontop.model.term.GroundTerm;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.NonVariableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.VariableOrGroundTerm;
import it.unibz.inf.ontop.substitution.InjectiveSubstitution;
import it.unibz.inf.ontop.substitution.Substitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;

public class AggregationNodeImpl
extends ExtendedProjectionNodeImpl
implements AggregationNode {
    private static final String AGGREGATE_NODE_STR = "AGGREGATE";
    private final ImmutableSet<Variable> projectedVariables;
    private final ImmutableSet<Variable> groupingVariables;
    private final Substitution<ImmutableFunctionalTerm> substitution;
    private final ImmutableSet<Variable> childVariables;
    private final AggregationNormalizer aggregationNormalizer;

    @AssistedInject
    protected AggregationNodeImpl(@Assisted ImmutableSet<Variable> groupingVariables, @Assisted Substitution<ImmutableFunctionalTerm> substitution, SubstitutionFactory substitutionFactory, IntermediateQueryFactory iqFactory, AggregationNormalizer aggregationNormalizer, IQTreeTools iqTreeTools, TermFactory termFactory, OntopModelSettings settings) {
        super(substitutionFactory, iqFactory, iqTreeTools, termFactory);
        this.groupingVariables = groupingVariables;
        this.substitution = substitution;
        this.aggregationNormalizer = aggregationNormalizer;
        this.projectedVariables = Sets.union(groupingVariables, substitution.getDomain()).immutableCopy();
        this.childVariables = iqTreeTools.extractChildVariables(groupingVariables, substitution);
        if (settings.isTestModeEnabled()) {
            this.validateNode();
        }
    }

    @Override
    public IQTree applyDescendingSubstitution(Substitution<? extends VariableOrGroundTerm> descendingSubstitution, Optional<ImmutableExpression> constraint, IQTree child, VariableGenerator variableGenerator) {
        return this.applyDescendingSubstitutionOrBlock(descendingSubstitution, s -> super.applyDescendingSubstitution((Substitution<? extends VariableOrGroundTerm>)s, constraint, child, variableGenerator), variableGenerator);
    }

    @Override
    public IQTree applyDescendingSubstitutionWithoutOptimizing(Substitution<? extends VariableOrGroundTerm> descendingSubstitution, IQTree child, VariableGenerator variableGenerator) {
        return this.applyDescendingSubstitutionOrBlock(descendingSubstitution, s -> super.applyDescendingSubstitutionWithoutOptimizing((Substitution<? extends VariableOrGroundTerm>)s, child, variableGenerator), variableGenerator);
    }

    private IQTree applyDescendingSubstitutionOrBlock(Substitution<? extends VariableOrGroundTerm> descendingSubstitution, Function<Substitution<? extends VariableOrGroundTerm>, IQTree> applyNonBlockedSubstitutionFct, VariableGenerator variableGenerator) {
        ImmutableSet<Variable> aggregationVariables = this.substitution.getDomain();
        Substitution<GroundTerm> blockedGroundTermSubstitution = descendingSubstitution.builder().restrictDomainTo((Set<Variable>)aggregationVariables).restrictRangeTo(GroundTerm.class).build();
        Substitution<Variable> descendingVar2Var = descendingSubstitution.restrictRangeTo(Variable.class);
        ImmutableSet blockedVariables = (ImmutableSet)descendingVar2Var.getRangeSet().stream().flatMap(v -> this.extractBlockedDomainVars((Variable)v, descendingVar2Var.getPreImage(t -> t.equals(v)), aggregationVariables).stream()).collect(ImmutableCollectors.toSet());
        Substitution<Variable> blockedVariableSubstitution = descendingVar2Var.restrictDomainTo((Set<Variable>)blockedVariables);
        Substitution<Variable> blockedSubstitution = this.substitutionFactory.union(blockedGroundTermSubstitution, blockedVariableSubstitution);
        Substitution<? extends VariableOrGroundTerm> nonBlockedSubstitution = descendingSubstitution.removeFromDomain((Set<Variable>)blockedSubstitution.getDomain());
        IQTree newSubTree = applyNonBlockedSubstitutionFct.apply(nonBlockedSubstitution);
        if (blockedSubstitution.isEmpty()) {
            return newSubTree;
        }
        ImmutableExpression condition = this.termFactory.getConjunction((ImmutableList<ImmutableExpression>)((ImmutableList)blockedSubstitution.builder().toStream((x$0, x$1) -> this.termFactory.getStrictEquality((ImmutableTerm)x$0, (ImmutableTerm)x$1, new ImmutableTerm[0])).collect(ImmutableCollectors.toList())));
        FilterNode filterNode = this.iqFactory.createFilterNode(condition);
        InjectiveSubstitution<Variable> renamingSubstitution = filterNode.getLocalVariables().stream().collect(this.substitutionFactory.toFreshRenamingSubstitution(variableGenerator));
        IQTree filterTree = this.iqFactory.createUnaryIQTree(filterNode, newSubTree).applyFreshRenaming(renamingSubstitution);
        return this.iqFactory.createUnaryIQTree(this.iqFactory.createConstructionNode(this.iqTreeTools.computeNewProjectedVariables(descendingSubstitution, this.getVariables())), filterTree);
    }

    private Set<Variable> extractBlockedDomainVars(Variable rangeVariable, ImmutableSet<Variable> domainVariables, ImmutableSet<Variable> aggregationVariables) {
        if (aggregationVariables.contains((Object)rangeVariable)) {
            return domainVariables;
        }
        Sets.SetView aggregationDomainVariables = Sets.intersection(domainVariables, aggregationVariables);
        if (this.groupingVariables.contains((Object)rangeVariable)) {
            return aggregationDomainVariables;
        }
        Variable dominantVariable = aggregationDomainVariables.stream().findAny().orElseGet(() -> (Variable)domainVariables.iterator().next());
        return Sets.difference((Set)aggregationDomainVariables, (Set)ImmutableSet.of((Object)dominantVariable));
    }

    @Override
    protected Optional<ExtendedProjectionNode> computeNewProjectionNode(ImmutableSet<Variable> newProjectedVariables, Substitution<ImmutableTerm> theta, IQTree newChild) {
        return Optional.of(this.iqFactory.createAggregationNode((ImmutableSet<Variable>)Sets.difference(newProjectedVariables, theta.getDomain()).immutableCopy(), theta.transform(t -> (ImmutableFunctionalTerm)t)));
    }

    @Override
    public IQTree normalizeForOptimization(IQTree child, VariableGenerator variableGenerator, IQTreeCache treeCache) {
        return this.aggregationNormalizer.normalizeForOptimization(this, child, variableGenerator, treeCache);
    }

    @Override
    public IQTree applyFreshRenaming(InjectiveSubstitution<Variable> renamingSubstitution, IQTree child, IQTreeCache treeCache) {
        IQTree newChild = child.applyFreshRenaming(renamingSubstitution);
        ImmutableSet<Variable> newGroupingVariables = this.substitutionFactory.apply(renamingSubstitution, this.groupingVariables);
        AggregationNode newNode = this.iqFactory.createAggregationNode(newGroupingVariables, this.substitutionFactory.onImmutableFunctionalTerms().rename(renamingSubstitution, this.substitution));
        return this.iqFactory.createUnaryIQTree(newNode, newChild, treeCache.applyFreshRenaming(renamingSubstitution));
    }

    @Override
    public boolean isDistinct(IQTree tree, IQTree child) {
        return true;
    }

    @Override
    public IQTree liftIncompatibleDefinitions(Variable variable, IQTree child, VariableGenerator variableGenerator) {
        return this.iqFactory.createUnaryIQTree(this, child);
    }

    @Override
    public IQTree acceptTransformer(IQTree tree, IQTreeVisitingTransformer transformer, IQTree child) {
        return transformer.transformAggregation(tree, this, child);
    }

    @Override
    public <T> IQTree acceptTransformer(IQTree tree, IQTreeExtendedTransformer<T> transformer, IQTree child, T context) {
        return transformer.transformAggregation(tree, this, child, context);
    }

    @Override
    public <T> T acceptVisitor(IQVisitor<T> visitor, IQTree child) {
        return visitor.visitAggregation(this, child);
    }

    @Override
    public void acceptVisitor(QueryNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public AggregationNode acceptNodeTransformer(HomogeneousQueryNodeTransformer transformer) throws QueryNodeTransformationException {
        return transformer.transform(this);
    }

    @Override
    public ImmutableSet<Variable> getLocalVariables() {
        return Sets.union(this.getChildVariables(), this.substitution.getDomain()).immutableCopy();
    }

    @Override
    public ImmutableSet<Variable> getLocallyRequiredVariables() {
        return this.getChildVariables();
    }

    @Override
    public ImmutableSet<Variable> getLocallyDefinedVariables() {
        return this.substitution.getDomain();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof AggregationNodeImpl) {
            AggregationNodeImpl that = (AggregationNodeImpl)o;
            return this.groupingVariables.equals(that.groupingVariables) && this.substitution.equals(that.substitution);
        }
        return false;
    }

    @Override
    public boolean wouldKeepDescendingGroundTermInFilterAbove(Variable variable, boolean isConstant) {
        return this.substitution.isDefining(variable);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.groupingVariables, this.substitution);
    }

    @Override
    public void validateNode(IQTree child) throws InvalidIntermediateQueryException {
        this.validateNode();
        Sets.SetView missingVariables = Sets.difference(this.getLocallyRequiredVariables(), child.getVariables());
        if (!missingVariables.isEmpty()) {
            throw new InvalidIntermediateQueryException("The child of the aggregation node is missing some variables: " + (Set)missingVariables);
        }
    }

    protected void validateNode() throws InvalidIntermediateQueryException {
        if (!Sets.intersection(this.groupingVariables, this.substitution.getDomain()).isEmpty()) {
            throw new InvalidIntermediateQueryException(String.format("AggregationNode: the grouping variables (%s) and the substitution domain (%s) must be disjoint", this.groupingVariables, this.substitution.getDomain()));
        }
        if (this.substitution.rangeAnyMatch(t -> !t.getFunctionSymbol().isAggregation())) {
            throw new InvalidIntermediateQueryException(String.format("The substitution of the aggregation node should only define aggregates, not %s", this.substitution.builder().restrictRange(t -> !t.getFunctionSymbol().isAggregation()).build()));
        }
    }

    @Override
    public ImmutableSet<Substitution<NonVariableTerm>> getPossibleVariableDefinitions(IQTree child) {
        ImmutableSet groupingVariableDefs = (ImmutableSet)child.getPossibleVariableDefinitions().stream().map(s -> s.restrictDomainTo((Set<Variable>)this.groupingVariables)).collect(ImmutableCollectors.toSet());
        Substitution<NonVariableTerm> def = this.substitution.restrictRangeTo(NonVariableTerm.class);
        if (groupingVariableDefs.isEmpty()) {
            return def.isEmpty() ? ImmutableSet.of() : ImmutableSet.of(def);
        }
        return (ImmutableSet)groupingVariableDefs.stream().map(childDef -> this.substitutionFactory.union(childDef, def)).collect(ImmutableCollectors.toSet());
    }

    @Override
    public IQTree removeDistincts(IQTree child, IQTreeCache treeCache) {
        return this.iqFactory.createUnaryIQTree(this, child, treeCache.declareDistinctRemoval(true));
    }

    @Override
    public ImmutableSet<ImmutableSet<Variable>> inferUniqueConstraints(IQTree child) {
        return this.groupingVariables.isEmpty() ? ImmutableSet.of(this.getVariables()) : (ImmutableSet)Stream.concat(child.inferUniqueConstraints().stream().filter(arg_0 -> this.groupingVariables.containsAll(arg_0)), Stream.of(this.getGroupingVariables())).collect(ImmutableCollectors.toSet());
    }

    @Override
    public FunctionalDependencies inferFunctionalDependencies(IQTree child, ImmutableSet<ImmutableSet<Variable>> uniqueConstraints, ImmutableSet<Variable> variables) {
        FunctionalDependencies childFDs = child.inferFunctionalDependencies();
        return childFDs.stream().filter(e -> this.groupingVariables.containsAll((Collection)e.getKey())).filter(e -> ((ImmutableSet)e.getValue()).stream().anyMatch(arg_0 -> this.groupingVariables.contains(arg_0))).map(e -> Maps.immutableEntry((Object)((ImmutableSet)e.getKey()), (Object)((ImmutableSet)((ImmutableSet)e.getValue()).stream().filter(arg_0 -> this.groupingVariables.contains(arg_0)).collect(ImmutableCollectors.toSet())))).collect(FunctionalDependencies.toFunctionalDependencies()).concat(FunctionalDependencies.fromUniqueConstraints(uniqueConstraints, variables));
    }

    @Override
    public VariableNonRequirement computeVariableNonRequirement(IQTree child) {
        return VariableNonRequirement.of(this.substitution.getDomain());
    }

    @Override
    public ImmutableSet<Variable> inferStrictDependents(UnaryIQTree tree, IQTree child) {
        return IQTreeTools.computeStrictDependentsFromFunctionalDependencies(tree);
    }

    @Override
    public Substitution<ImmutableFunctionalTerm> getSubstitution() {
        return this.substitution;
    }

    @Override
    public ImmutableSet<Variable> getGroupingVariables() {
        return this.groupingVariables;
    }

    @Override
    public ImmutableSet<Variable> getChildVariables() {
        return this.childVariables;
    }

    @Override
    public ImmutableSet<Variable> getVariables() {
        return this.projectedVariables;
    }

    public String toString() {
        return "AGGREGATE " + this.groupingVariables + " [" + this.substitution + "]";
    }
}

