/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.injection.impl;

import com.google.common.collect.ImmutableList;
import com.google.inject.ConfigurationException;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.name.Names;
import it.unibz.inf.ontop.constraints.HomomorphismFactory;
import it.unibz.inf.ontop.dbschema.DatabaseInfoSupplier;
import it.unibz.inf.ontop.dbschema.QuotedIDFactory;
import it.unibz.inf.ontop.dbschema.impl.SQLStandardQuotedIDFactory;
import it.unibz.inf.ontop.evaluator.ExpressionNormalizer;
import it.unibz.inf.ontop.evaluator.QueryContext;
import it.unibz.inf.ontop.evaluator.TermNullabilityEvaluator;
import it.unibz.inf.ontop.injection.CoreSingletons;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.injection.OntopModelConfiguration;
import it.unibz.inf.ontop.injection.OntopModelSettings;
import it.unibz.inf.ontop.injection.QueryTransformerFactory;
import it.unibz.inf.ontop.injection.impl.CoreSingletonsImpl;
import it.unibz.inf.ontop.injection.impl.OntopAbstractModule;
import it.unibz.inf.ontop.iq.BinaryNonCommutativeIQTree;
import it.unibz.inf.ontop.iq.IQ;
import it.unibz.inf.ontop.iq.IQTreeCache;
import it.unibz.inf.ontop.iq.NaryIQTree;
import it.unibz.inf.ontop.iq.UnaryIQTree;
import it.unibz.inf.ontop.iq.node.AggregationNode;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.iq.node.DistinctNode;
import it.unibz.inf.ontop.iq.node.EmptyNode;
import it.unibz.inf.ontop.iq.node.ExtensionalDataNode;
import it.unibz.inf.ontop.iq.node.FilterNode;
import it.unibz.inf.ontop.iq.node.FlattenNode;
import it.unibz.inf.ontop.iq.node.InnerJoinNode;
import it.unibz.inf.ontop.iq.node.IntensionalDataNode;
import it.unibz.inf.ontop.iq.node.LeftJoinNode;
import it.unibz.inf.ontop.iq.node.NativeNode;
import it.unibz.inf.ontop.iq.node.OrderByNode;
import it.unibz.inf.ontop.iq.node.SliceNode;
import it.unibz.inf.ontop.iq.node.TrueNode;
import it.unibz.inf.ontop.iq.node.UnionNode;
import it.unibz.inf.ontop.iq.node.ValuesNode;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.iq.node.normalization.AggregationNormalizer;
import it.unibz.inf.ontop.iq.node.normalization.ConditionSimplifier;
import it.unibz.inf.ontop.iq.node.normalization.ConstructionSubstitutionNormalizer;
import it.unibz.inf.ontop.iq.node.normalization.DistinctNormalizer;
import it.unibz.inf.ontop.iq.node.normalization.FilterNormalizer;
import it.unibz.inf.ontop.iq.node.normalization.FlattenNormalizer;
import it.unibz.inf.ontop.iq.node.normalization.InnerJoinNormalizer;
import it.unibz.inf.ontop.iq.node.normalization.LeftJoinNormalizer;
import it.unibz.inf.ontop.iq.node.normalization.NotRequiredVariableRemover;
import it.unibz.inf.ontop.iq.node.normalization.OrderByNormalizer;
import it.unibz.inf.ontop.iq.tools.ProjectionDecomposer;
import it.unibz.inf.ontop.iq.tools.TypeConstantDictionary;
import it.unibz.inf.ontop.iq.transform.NoNullValueEnforcer;
import it.unibz.inf.ontop.iq.transform.QueryRenamer;
import it.unibz.inf.ontop.iq.type.NotYetTypedBinaryMathOperationTransformer;
import it.unibz.inf.ontop.iq.type.NotYetTypedEqualityTransformer;
import it.unibz.inf.ontop.iq.type.PartiallyTypedSimpleCastTransformer;
import it.unibz.inf.ontop.iq.type.SingleTermTypeExtractor;
import it.unibz.inf.ontop.model.atom.AtomFactory;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.FunctionSymbolFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBFunctionSymbolFactory;
import it.unibz.inf.ontop.model.type.DBTypeFactory;
import it.unibz.inf.ontop.model.type.TypeFactory;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.CoreUtilsFactory;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.lang.annotation.Annotation;
import java.util.Optional;
import org.apache.commons.rdf.api.RDF;
import org.eclipse.jdt.annotation.NonNullByDefault;

@NonNullByDefault
public class OntopModelModule
extends OntopAbstractModule {
    protected OntopModelModule(OntopModelConfiguration configuration) {
        this(configuration.getSettings());
    }

    protected OntopModelModule(OntopModelSettings settings) {
        super(settings);
    }

    protected void configure() {
        this.configureCoreConfiguration();
        this.bindFromSettings(TypeFactory.class);
        this.bindFromSettings(FunctionSymbolFactory.class);
        this.bindFromSettings(TermFactory.class);
        this.bindFromSettings(AtomFactory.class);
        this.bindFromSettings(SubstitutionFactory.class);
        this.bindFromSettings(HomomorphismFactory.class);
        this.bindFromSettings(TermNullabilityEvaluator.class);
        this.bindFromSettings(NoNullValueEnforcer.class);
        this.bindFromSettings(ExpressionNormalizer.class);
        this.bindFromSettings(ConditionSimplifier.class);
        this.bindFromSettings(ConstructionSubstitutionNormalizer.class);
        this.bindFromSettings(FilterNormalizer.class);
        this.bindFromSettings(FlattenNormalizer.class);
        this.bindFromSettings(InnerJoinNormalizer.class);
        this.bindFromSettings(LeftJoinNormalizer.class);
        this.bindFromSettings(OrderByNormalizer.class);
        this.bindFromSettings(DistinctNormalizer.class);
        this.bindFromSettings(AggregationNormalizer.class);
        this.bindFromSettings(NotRequiredVariableRemover.class);
        this.bindFromSettings(NotYetTypedEqualityTransformer.class);
        this.bindFromSettings(NotYetTypedBinaryMathOperationTransformer.class);
        this.bindFromSettings(PartiallyTypedSimpleCastTransformer.class);
        this.bindFromSettings(RDF.class);
        this.bindFromSettings(SingleTermTypeExtractor.class);
        this.bindFromSettings(DBFunctionSymbolFactory.class);
        this.bindFromSettings(TypeConstantDictionary.class);
        this.bindFromSettings(IQTreeCache.class);
        this.bindFromSettings(DatabaseInfoSupplier.class);
        this.bind(CoreSingletons.class).to(CoreSingletonsImpl.class);
        Module utilsModule = this.buildFactory((Iterable<Class<?>>)ImmutableList.of(VariableGenerator.class, VariableNullability.class, ProjectionDecomposer.class), (Class<?>)CoreUtilsFactory.class);
        this.install(utilsModule);
        Module dbTypeFactoryModule = this.buildFactory((Iterable<Class<?>>)ImmutableList.of(DBTypeFactory.class), (Class<?>)DBTypeFactory.Factory.class);
        this.install(dbTypeFactoryModule);
        Module iqFactoryModule = this.buildFactory(IntermediateQueryFactory.class, ConstructionNode.class, UnionNode.class, InnerJoinNode.class, LeftJoinNode.class, FilterNode.class, FlattenNode.class, ExtensionalDataNode.class, IntensionalDataNode.class, NativeNode.class, ValuesNode.class, EmptyNode.class, TrueNode.class, DistinctNode.class, SliceNode.class, OrderByNode.class, OrderByNode.OrderComparator.class, AggregationNode.class, UnaryIQTree.class, BinaryNonCommutativeIQTree.class, NaryIQTree.class, IQ.class, IQTreeCache.class);
        this.install(iqFactoryModule);
        Module queryTransformerModule = this.buildFactory((Iterable<Class<?>>)ImmutableList.of(QueryRenamer.class), (Class<?>)QueryTransformerFactory.class);
        this.install(queryTransformerModule);
        String idFactoryType = QuotedIDFactory.getIDFactoryType(SQLStandardQuotedIDFactory.class);
        this.bindFromSettings(Key.get(QuotedIDFactory.class, (Annotation)Names.named((String)idFactoryType)), SQLStandardQuotedIDFactory.class);
        Module queryContextModule = this.buildFactory((Iterable<Class<?>>)ImmutableList.of(QueryContext.class), (Class<?>)QueryContext.Factory.class);
        this.install(queryContextModule);
        this.bind(QuotedIDFactory.Supplier.class).toInstance((Object)new QuotedIDFactory.Supplier(){
            @Inject
            private Injector injector;

            @Override
            public Optional<QuotedIDFactory> get(String idFactoryType) {
                try {
                    return Optional.of((QuotedIDFactory)this.injector.getInstance(Key.get(QuotedIDFactory.class, (Annotation)Names.named((String)idFactoryType))));
                }
                catch (ConfigurationException ex) {
                    return Optional.empty();
                }
            }
        });
    }
}

