/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.injection.impl;

import com.google.inject.AbstractModule;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import com.google.inject.name.Named;
import it.unibz.inf.ontop.injection.OntopModelSettings;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public abstract class OntopAbstractModule
extends AbstractModule {
    private final OntopModelSettings settings;

    protected OntopAbstractModule(OntopModelSettings settings) {
        this.settings = settings;
    }

    protected final <T> Optional<Class<? extends T>> getImplementation(Key<T> qualifiedAbstractType) {
        return this.settings.getProperty(this.getSettingsProperty(qualifiedAbstractType)).map(implementationClassName -> {
            try {
                Class abstractClass = qualifiedAbstractType.getTypeLiteral().getRawType();
                return Class.forName(implementationClassName).asSubclass(abstractClass);
            }
            catch (ClassNotFoundException e) {
                throw new UnknownClassException(e.getMessage());
            }
        });
    }

    protected final Module buildFactory(Iterable<Class<?>> abstractTypes, Class<?> factoryInterface) {
        return this.buildFactory(Key.get(factoryInterface), (Key[])StreamSupport.stream(abstractTypes.spliterator(), false).map(Key::get).toArray(Key[]::new));
    }

    protected final Module buildFactory(Class<?> factoryInterface, Class<?> ... abstractTypes) {
        return this.buildFactory(Key.get(factoryInterface), (Key[])Stream.of(abstractTypes).map(Key::get).toArray(Key[]::new));
    }

    protected final Module buildFactory(Key<?> qualifiedFactoryInterface, Key<?> ... qualifiedAbstractTypes) {
        FactoryModuleBuilder builder = new FactoryModuleBuilder();
        for (Key<?> qualifiedAbstractType : qualifiedAbstractTypes) {
            Class<?> implementationClass = this.getImplementation(qualifiedAbstractType).orElseThrow(() -> new UnknownClassException(String.format("Cannot build factory %s: no property %s in the settings for abstract type %s.", qualifiedFactoryInterface.getTypeLiteral().toString(), this.getSettingsProperty(qualifiedAbstractType), qualifiedAbstractType.getTypeLiteral().toString())));
            builder = builder.implement(qualifiedAbstractType, implementationClass);
        }
        return builder.build(qualifiedFactoryInterface);
    }

    protected final void configureCoreConfiguration() {
        this.bind(OntopModelSettings.class).toInstance((Object)this.settings);
    }

    protected final OntopModelSettings getSettings() {
        return this.settings;
    }

    protected final String getSettingsProperty(Key<?> qualifiedAbstractType) {
        String typeName;
        Type type = qualifiedAbstractType.getTypeLiteral().getType();
        String string = typeName = type instanceof Class ? ((Class)type).getCanonicalName() : type.toString().replace('$', '.');
        if (qualifiedAbstractType.getAnnotationType() == null) {
            return typeName;
        }
        if (!qualifiedAbstractType.hasAttributes()) {
            return typeName + "@" + qualifiedAbstractType.getAnnotationType().getCanonicalName();
        }
        if (qualifiedAbstractType.getAnnotation() instanceof Named) {
            return typeName + "-" + ((Named)qualifiedAbstractType.getAnnotation()).value();
        }
        Annotation annotation = qualifiedAbstractType.getAnnotation();
        Class annotationType = qualifiedAbstractType.getAnnotationType();
        String sortedCommaSeparatedArgs = Arrays.stream(annotationType.getDeclaredMethods()).sorted(Comparator.comparing(Method::getName)).map(m -> {
            try {
                return String.valueOf(m.invoke((Object)annotation, new Object[0]));
            }
            catch (Throwable ex) {
                throw new Error("Could not access annotation value", ex);
            }
        }).collect(Collectors.joining(","));
        return typeName + "@" + annotationType.getCanonicalName() + "(" + sortedCommaSeparatedArgs + ")";
    }

    protected final <T> void bindFromSettings(Class<T> abstractType) {
        this.bindFromSettings(Key.get(abstractType));
    }

    protected final <T> void bindFromSettings(Key<T> qualifiedAbstractType) {
        this.bind(qualifiedAbstractType).to(this.getImplementation(qualifiedAbstractType).orElseThrow(() -> new UnknownClassException(String.format("No property %s in the settings for abstract type %s.", this.getSettingsProperty(qualifiedAbstractType), qualifiedAbstractType.getTypeLiteral().toString()))));
    }

    protected final <T> void bindFromSettings(Key<T> qualifiedAbstractType, Class<? extends T> defaultImplementationClass) {
        Objects.requireNonNull(defaultImplementationClass);
        this.bind(qualifiedAbstractType).to(this.getImplementation(qualifiedAbstractType).orElse(defaultImplementationClass));
    }

    public static class UnknownClassException
    extends RuntimeException {
        public UnknownClassException(String message) {
            super(message);
        }
    }
}

