/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.dbschema.impl;

import com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.dbschema.Lens;
import it.unibz.inf.ontop.dbschema.RelationDefinition;
import it.unibz.inf.ontop.dbschema.RelationID;
import it.unibz.inf.ontop.dbschema.impl.AbstractNamedRelationDefinition;
import it.unibz.inf.ontop.injection.CoreSingletons;
import it.unibz.inf.ontop.iq.IQ;
import it.unibz.inf.ontop.model.atom.AtomPredicate;
import it.unibz.inf.ontop.model.atom.DistinctVariableOnlyDataAtom;
import it.unibz.inf.ontop.model.atom.RelationPredicate;
import javax.annotation.Nonnull;

public class LensImpl
extends AbstractNamedRelationDefinition
implements Lens {
    private final int level;
    private @Nonnull IQ iq;
    private boolean isFrozen;

    public LensImpl(ImmutableList<RelationID> allIds, RelationDefinition.AttributeListBuilder builder, IQ iqWithTemporaryAtomPredicate, int level, CoreSingletons coreSingletons) {
        super(allIds, builder);
        this.iq = LensImpl.replaceAtomPredicate(this.getAtomPredicate(), iqWithTemporaryAtomPredicate, coreSingletons);
        this.level = level;
        if (level < 1) {
            throw new IllegalArgumentException("Minimum level for a lens is 1");
        }
        this.isFrozen = false;
    }

    private static IQ replaceAtomPredicate(RelationPredicate newAtomPredicate, IQ iqWithTemporaryAtomPredicate, CoreSingletons coreSingletons) {
        DistinctVariableOnlyDataAtom newProjectionAtom = coreSingletons.getAtomFactory().getDistinctVariableOnlyDataAtom((AtomPredicate)newAtomPredicate, iqWithTemporaryAtomPredicate.getProjectionAtom().getArguments());
        return coreSingletons.getIQFactory().createIQ(newProjectionAtom, iqWithTemporaryAtomPredicate.getTree());
    }

    @Override
    public IQ getIQ() {
        return this.iq;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public void updateIQ(@Nonnull IQ newIQ) throws IllegalStateException {
        if (this.isFrozen) {
            throw new IllegalStateException("Cannot change the IQ after freezing");
        }
        if (!this.iq.getProjectionAtom().getPredicate().equals(newIQ.getProjectionAtom().getPredicate())) {
            throw new IllegalArgumentException("IQ with a different atom predicate provided");
        }
        this.iq = newIQ;
    }

    @Override
    public void freeze() {
        this.isFrozen = true;
    }

    public String toString() {
        return "Lens " + this.getID();
    }
}

