/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.dbschema.impl;

import com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.dbschema.Attribute;
import it.unibz.inf.ontop.dbschema.AttributeNotFoundException;
import it.unibz.inf.ontop.dbschema.ForeignKeyConstraint;
import it.unibz.inf.ontop.dbschema.NamedRelationDefinition;
import it.unibz.inf.ontop.dbschema.QuotedID;
import java.util.stream.Collectors;

public class ForeignKeyConstraintImpl
implements ForeignKeyConstraint {
    private final String name;
    private final ImmutableList<ForeignKeyConstraint.Component> components;
    private final NamedRelationDefinition relation;
    private final NamedRelationDefinition referencedRelation;

    public static ForeignKeyConstraint.Builder builder(String name, NamedRelationDefinition relation, NamedRelationDefinition referencedRelation) {
        return new BuilderImpl(name, relation, referencedRelation);
    }

    private ForeignKeyConstraintImpl(String name, ImmutableList<ForeignKeyConstraint.Component> components) {
        this.name = name;
        this.components = components;
        this.relation = (NamedRelationDefinition)((ForeignKeyConstraint.Component)components.get(0)).getAttribute().getRelation();
        this.referencedRelation = (NamedRelationDefinition)((ForeignKeyConstraint.Component)components.get(0)).getReferencedAttribute().getRelation();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ImmutableList<ForeignKeyConstraint.Component> getComponents() {
        return this.components;
    }

    @Override
    public NamedRelationDefinition getReferencedRelation() {
        return this.referencedRelation;
    }

    @Override
    public NamedRelationDefinition getRelation() {
        return this.relation;
    }

    public String toString() {
        return "ALTER TABLE " + this.relation.getID().getSQLRendering() + " ADD CONSTRAINT " + this.name + " FOREIGN KEY (" + this.components.stream().map(c -> c.getAttribute().getID().toString()).collect(Collectors.joining(", ")) + ") REFERENCES " + this.referencedRelation.getID().getSQLRendering() + " (" + this.components.stream().map(c -> c.getReferencedAttribute().getID().toString()).collect(Collectors.joining(", ")) + ")";
    }

    private static final class BuilderImpl
    implements ForeignKeyConstraint.Builder {
        private final String name;
        private final ImmutableList.Builder<ForeignKeyConstraint.Component> builder = ImmutableList.builder();
        private final NamedRelationDefinition relation;
        private final NamedRelationDefinition referencedRelation;

        private BuilderImpl(String name, NamedRelationDefinition relation, NamedRelationDefinition referencedRelation) {
            this.name = name;
            this.relation = relation;
            this.referencedRelation = referencedRelation;
        }

        @Override
        public ForeignKeyConstraint.Builder add(int attributeIndex, int referencedAttributeIndex) {
            this.builder.add((Object)new ComponentImpl(this.relation.getAttribute(attributeIndex), this.referencedRelation.getAttribute(referencedAttributeIndex)));
            return this;
        }

        @Override
        public ForeignKeyConstraint.Builder add(QuotedID attributeId, QuotedID referencedAttributeId) throws AttributeNotFoundException {
            this.builder.add((Object)new ComponentImpl(this.relation.getAttribute(attributeId), this.referencedRelation.getAttribute(referencedAttributeId)));
            return this;
        }

        @Override
        public void build() {
            ImmutableList components = this.builder.build();
            if (components.isEmpty()) {
                throw new IllegalArgumentException("No attributes in a foreign key");
            }
            this.relation.addForeignKeyConstraint(new ForeignKeyConstraintImpl(this.name, (ImmutableList<ForeignKeyConstraint.Component>)components));
        }
    }

    private static final class ComponentImpl
    implements ForeignKeyConstraint.Component {
        private final Attribute attribute;
        private final Attribute referencedAttribute;

        private ComponentImpl(Attribute attribute, Attribute referencedAttribute) {
            this.attribute = attribute;
            this.referencedAttribute = referencedAttribute;
        }

        @Override
        public Attribute getAttribute() {
            return this.attribute;
        }

        @Override
        public Attribute getReferencedAttribute() {
            return this.referencedAttribute;
        }
    }
}

