/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.dbschema.impl;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.dbschema.Attribute;
import it.unibz.inf.ontop.dbschema.AttributeNotFoundException;
import it.unibz.inf.ontop.dbschema.QuotedID;
import it.unibz.inf.ontop.dbschema.RelationDefinition;
import it.unibz.inf.ontop.dbschema.impl.AttributeImpl;
import it.unibz.inf.ontop.model.atom.RelationPredicate;
import it.unibz.inf.ontop.model.atom.impl.AtomPredicateImpl;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.model.type.TermType;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public abstract class AbstractRelationDefinition
implements RelationDefinition {
    private final ImmutableList<Attribute> attributes;
    private final ImmutableMap<QuotedID, Attribute> map;
    private final RelationPredicate predicate;

    protected AbstractRelationDefinition(String predicateName, RelationDefinition.AttributeListBuilder builder) {
        this.attributes = builder.build(this);
        this.map = this.attributes.stream().collect(ImmutableCollectors.toMap(Attribute::getID, Function.identity()));
        this.predicate = new RelationPredicateImpl(predicateName);
    }

    @Override
    public Attribute getAttribute(int index) {
        return (Attribute)this.attributes.get(index - 1);
    }

    @Override
    public Attribute getAttribute(QuotedID id) throws AttributeNotFoundException {
        Attribute attribute = (Attribute)this.map.get((Object)id);
        if (attribute == null) {
            throw new AttributeNotFoundException(this, id);
        }
        return attribute;
    }

    @Override
    @JsonProperty(value="columns")
    public ImmutableList<Attribute> getAttributes() {
        return this.attributes;
    }

    @Override
    @JsonIgnore
    public RelationPredicate getAtomPredicate() {
        return this.predicate;
    }

    public static RelationDefinition.AttributeListBuilder attributeListBuilder() {
        return new AttributeListBuilderImpl();
    }

    private static class AttributeListBuilderImpl
    implements RelationDefinition.AttributeListBuilder {
        private final List<AttributeInfo> list = new ArrayList<AttributeInfo>();

        private AttributeListBuilderImpl() {
        }

        @Override
        public RelationDefinition.AttributeListBuilder addAttribute(QuotedID id, DBTermType termType, String typeName, boolean isNullable) {
            this.list.add(new AttributeInfo(id, this.list.size() + 1, termType, typeName, isNullable));
            return this;
        }

        @Override
        public RelationDefinition.AttributeListBuilder addAttribute(QuotedID id, DBTermType termType, boolean isNullable) {
            this.list.add(new AttributeInfo(id, this.list.size() + 1, termType, termType.getName(), isNullable));
            return this;
        }

        @Override
        public ImmutableList<Attribute> build(RelationDefinition relation) {
            return (ImmutableList)this.list.stream().map(a -> new AttributeImpl(relation, a.id, a.index, a.typeName, a.termType, a.isNullable)).collect(ImmutableCollectors.toList());
        }
    }

    private static final class AttributeInfo {
        private final QuotedID id;
        private final int index;
        private final DBTermType termType;
        private final String typeName;
        private final boolean isNullable;

        AttributeInfo(QuotedID id, int index, DBTermType termType, String typeName, boolean isNullable) {
            this.id = id;
            this.index = index;
            this.termType = termType;
            this.typeName = typeName;
            this.isNullable = isNullable;
        }
    }

    private class RelationPredicateImpl
    extends AtomPredicateImpl
    implements RelationPredicate {
        public RelationPredicateImpl(String name) {
            super(name, (ImmutableList<TermType>)((ImmutableList)AbstractRelationDefinition.this.getAttributes().stream().map(Attribute::getTermType).collect(ImmutableCollectors.toList())));
        }

        @Override
        public RelationDefinition getRelationDefinition() {
            return AbstractRelationDefinition.this;
        }
    }
}

