/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.dbschema;

import com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.dbschema.QuotedID;
import it.unibz.inf.ontop.dbschema.RelationID;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNullByDefault;

@NonNullByDefault
public interface QuotedIDFactory {
    public QuotedID createAttributeID(String var1);

    public RelationID createRelationID(String var1);

    public RelationID createRelationID(String ... var1);

    public String getIDQuotationString();

    public boolean supportsSquareBracketQuotation();

    default public String getIDFactoryType() {
        return QuotedIDFactory.getIDFactoryType(this.getClass());
    }

    public static String getIDFactoryType(Class<? extends QuotedIDFactory> factoryClass) {
        return (String)Stream.iterate(factoryClass, Objects::nonNull, Class::getSuperclass).flatMap(c -> Stream.ofNullable(c.getAnnotation(IDFactoryType.class)).map(IDFactoryType::value)).findFirst().orElseThrow(() -> new UnsupportedOperationException("No @IDFactoryType annotation found"));
    }

    public static interface Supplier {
        public Optional<QuotedIDFactory> get(String var1);

        public static Supplier wrap(QuotedIDFactory ... factories) {
            ImmutableMap map = (ImmutableMap)Stream.of(factories).collect(ImmutableMap.toImmutableMap(QuotedIDFactory::getIDFactoryType, Optional::of));
            return idFactoryType -> (Optional)map.getOrDefault((Object)idFactoryType, Optional.empty());
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface IDFactoryType {
        public String value();
    }
}

