/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.constraints.impl;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.constraints.Homomorphism;
import it.unibz.inf.ontop.constraints.HomomorphismFactory;
import it.unibz.inf.ontop.constraints.impl.ExtensionalDataNodeHomomorphismIteratorImpl;
import it.unibz.inf.ontop.dbschema.ForeignKeyConstraint;
import it.unibz.inf.ontop.dbschema.RelationDefinition;
import it.unibz.inf.ontop.iq.node.ExtensionalDataNode;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.VariableOrGroundTerm;
import it.unibz.inf.ontop.utils.CoreUtilsFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;

public class ExtensionalDataNodeListContainmentCheck {
    private final HomomorphismFactory homomorphismFactory;
    private final CoreUtilsFactory coreUtilsFactory;

    public ExtensionalDataNodeListContainmentCheck(HomomorphismFactory homomorphismFactory, CoreUtilsFactory coreUtilsFactory) {
        this.homomorphismFactory = homomorphismFactory;
        this.coreUtilsFactory = coreUtilsFactory;
    }

    public boolean isContainedIn(ImmutableList<? extends VariableOrGroundTerm> answerVariables1, ImmutableList<ExtensionalDataNode> nodes1, ImmutableList<? extends VariableOrGroundTerm> answerVariables2, ImmutableList<ExtensionalDataNode> nodes2) {
        Homomorphism.Builder builder = this.homomorphismFactory.getHomomorphismBuilder();
        if (answerVariables1.size() != answerVariables2.size()) {
            return false;
        }
        for (int i = 0; i < answerVariables1.size(); ++i) {
            builder.extend((ImmutableTerm)answerVariables1.get(i), (ImmutableTerm)answerVariables2.get(i));
        }
        if (builder.isValid()) {
            ImmutableSet<ChasedExtensionalDataNode> chase = this.chase(nodes1);
            ImmutableSet relationsInChase = (ImmutableSet)chase.stream().map(ChasedExtensionalDataNode::getRelationDefinition).collect(ImmutableCollectors.toSet());
            if (nodes2.stream().map(ExtensionalDataNode::getRelationDefinition).anyMatch(r -> !relationsInChase.contains(r))) {
                return false;
            }
            ExtensionalDataNodeHomomorphismIteratorImpl iterator = new ExtensionalDataNodeHomomorphismIteratorImpl(builder.build(), nodes2, (ImmutableCollection<ChasedExtensionalDataNode>)chase);
            return iterator.hasNext();
        }
        return false;
    }

    public ImmutableSet<ChasedExtensionalDataNode> chase(ImmutableList<ExtensionalDataNode> nodes) {
        VariableGenerator variableGenerator = this.coreUtilsFactory.createVariableGenerator((Collection)nodes.stream().flatMap(n -> n.getVariables().stream()).collect(ImmutableCollectors.toSet()));
        return (ImmutableSet)nodes.stream().flatMap(node -> this.chase((ExtensionalDataNode)node, variableGenerator)).collect(ImmutableCollectors.toSet());
    }

    private Stream<ChasedExtensionalDataNode> chase(ExtensionalDataNode node, VariableGenerator variableGenerator) {
        ChasedExtensionalDataNode chasedNode = new ChasedExtensionalDataNode(node, variableGenerator);
        return Stream.concat(Stream.of(chasedNode), node.getRelationDefinition().getForeignKeys().stream().map(fk -> this.chase((ForeignKeyConstraint)fk, chasedNode, variableGenerator)).flatMap(Optional::stream));
    }

    private Optional<ChasedExtensionalDataNode> chase(ForeignKeyConstraint fk, ChasedExtensionalDataNode node, VariableGenerator variableGenerator) {
        if (fk.getComponents().stream().anyMatch(c -> c.getAttribute().isNullable())) {
            return Optional.empty();
        }
        ImmutableMap<Integer, VariableOrGroundTerm> map = fk.getComponents().stream().collect(ImmutableCollectors.toMap(c -> c.getReferencedAttribute().getIndex() - 1, c -> node.getArgument(c.getAttribute().getIndex() - 1)));
        ChasedExtensionalDataNode chasedNode = new ChasedExtensionalDataNode(fk.getReferencedRelation(), map, variableGenerator);
        return Optional.of(chasedNode);
    }

    static class ChasedExtensionalDataNode {
        private final RelationDefinition relationDefinition;
        private final Map<Integer, VariableOrGroundTerm> argumentMap;
        private final VariableGenerator variableGenerator;

        public ChasedExtensionalDataNode(ExtensionalDataNode node, VariableGenerator variableGenerator) {
            this.relationDefinition = node.getRelationDefinition();
            this.argumentMap = new HashMap<Integer, VariableOrGroundTerm>((Map<Integer, ? extends VariableOrGroundTerm>)node.getArgumentMap());
            this.variableGenerator = variableGenerator;
        }

        public ChasedExtensionalDataNode(RelationDefinition relationDefinition, ImmutableMap<Integer, ? extends VariableOrGroundTerm> argumentMap, VariableGenerator variableGenerator) {
            this.relationDefinition = relationDefinition;
            this.argumentMap = new HashMap<Integer, VariableOrGroundTerm>((Map<Integer, ? extends VariableOrGroundTerm>)argumentMap);
            this.variableGenerator = variableGenerator;
        }

        public RelationDefinition getRelationDefinition() {
            return this.relationDefinition;
        }

        public VariableOrGroundTerm getArgument(int index) {
            return this.argumentMap.computeIfAbsent(index, i -> this.variableGenerator.generateNewVariable());
        }

        public boolean equals(Object o) {
            if (o instanceof ChasedExtensionalDataNode) {
                ChasedExtensionalDataNode other = (ChasedExtensionalDataNode)o;
                return this.relationDefinition.equals(other.relationDefinition) && this.argumentMap.equals(other.argumentMap);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.relationDefinition, this.argumentMap);
        }

        public String toString() {
            return this.relationDefinition.getAtomPredicate().getName() + this.argumentMap;
        }
    }
}

