/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.constraints.impl;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.constraints.Homomorphism;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Queue;

public abstract class AbstractHomomorphismIterator<S, T>
implements Iterator<Homomorphism> {
    private final ListIterator<S> iterator;
    private final Deque<State> stack;
    private boolean movedToNext;
    private Homomorphism next;
    private final ImmutableCollection<T> to;

    public AbstractHomomorphismIterator(Homomorphism baseHomomorphism, ImmutableList<S> from, ImmutableCollection<T> to) {
        this.iterator = from.listIterator();
        this.stack = new ArrayDeque<State>(from.size());
        this.to = to;
        if (this.iterator.hasNext()) {
            this.movedToNext = false;
            this.stack.push(new State(this.iterator.next(), baseHomomorphism));
        } else {
            this.movedToNext = true;
            this.next = baseHomomorphism;
        }
    }

    @Override
    public boolean hasNext() {
        if (!this.movedToNext) {
            this.next = this.shift();
            this.movedToNext = true;
        }
        return this.next != null;
    }

    @Override
    public Homomorphism next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.movedToNext = false;
        return this.next;
    }

    private Homomorphism shift() {
        while (!this.stack.isEmpty()) {
            State state = this.stack.peek();
            Object candidateAtom = state.remainingChoices.poll();
            if (candidateAtom != null) {
                if (!this.equalPredicates(state.atom, candidateAtom)) continue;
                Homomorphism.Builder builder = state.homomorphism.builder();
                this.extendHomomorphism(builder, state.atom, candidateAtom);
                if (!builder.isValid()) continue;
                Homomorphism homomorphism = builder.build();
                if (this.iterator.hasNext()) {
                    this.stack.push(new State(this.iterator.next(), homomorphism));
                    continue;
                }
                return homomorphism;
            }
            this.stack.pop();
            this.iterator.previous();
        }
        return null;
    }

    abstract boolean equalPredicates(S var1, T var2);

    abstract void extendHomomorphism(Homomorphism.Builder var1, S var2, T var3);

    private final class State {
        final Homomorphism homomorphism;
        final Queue<T> remainingChoices;
        final S atom;

        State(S atom, Homomorphism homomorphism) {
            this.atom = atom;
            this.homomorphism = homomorphism;
            this.remainingChoices = new ArrayDeque(AbstractHomomorphismIterator.this.to);
        }
    }
}

