/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.constraints;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.model.atom.AtomPredicate;
import it.unibz.inf.ontop.model.atom.DataAtom;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.VariableOrGroundTerm;
import it.unibz.inf.ontop.substitution.Substitution;
import java.util.Objects;
import java.util.Optional;

public class ImmutableCQ<P extends AtomPredicate> {
    private final ImmutableSet<Variable> answerVariables;
    private final Substitution<VariableOrGroundTerm> substitution;
    private final ImmutableList<DataAtom<P>> atoms;

    public ImmutableCQ(ImmutableSet<Variable> answerVariables, Substitution<VariableOrGroundTerm> substitution, ImmutableList<DataAtom<P>> atoms) {
        this.answerVariables = answerVariables;
        this.substitution = substitution;
        this.atoms = atoms;
    }

    public VariableOrGroundTerm getAnswerTerm(Variable variable) {
        return Optional.ofNullable(this.substitution.get(variable)).orElse(variable);
    }

    public ImmutableSet<Variable> getAnswerVariables() {
        return this.answerVariables;
    }

    public Substitution<VariableOrGroundTerm> getSubstitution() {
        return this.substitution;
    }

    public ImmutableList<DataAtom<P>> getAtoms() {
        return this.atoms;
    }

    public int hashCode() {
        return Objects.hash(this.atoms, this.answerVariables, this.substitution);
    }

    public boolean equals(Object other) {
        if (other instanceof ImmutableCQ) {
            ImmutableCQ otherCQ = (ImmutableCQ)other;
            return this.atoms.equals(otherCQ.atoms) && this.answerVariables.equals(otherCQ.answerVariables) && this.substitution.equals(otherCQ.substitution);
        }
        return false;
    }

    public String toString() {
        return "q" + this.answerVariables + "/" + this.substitution + " :- " + this.atoms;
    }
}

