/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.similarity.text;

import com.ontotext.trree.plugin.similarity.IndexWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;

public class SimilarityTextIndexWriter
implements IndexWriter {
    private final org.apache.lucene.index.IndexWriter writer;
    private FieldType ft;

    public SimilarityTextIndexWriter(File indexDir, Analyzer analyzer) throws IOException {
        if (analyzer == null) {
            throw new IllegalArgumentException("Analyzer should not be null");
        }
        IndexWriterConfig writerConfig = new IndexWriterConfig(analyzer);
        this.writer = new org.apache.lucene.index.IndexWriter((Directory)FSDirectory.open((Path)indexDir.toPath()), writerConfig);
        this.ft = new FieldType();
        this.ft.setIndexOptions(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS);
        this.ft.setTokenized(true);
        this.ft.setStoreTermVectors(true);
        this.ft.setStoreTermVectorPositions(true);
    }

    public void write(Long docId, String docContent) throws IOException {
        Document doc = new Document();
        doc.add((IndexableField)new StoredField("path", docId.longValue()));
        doc.add((IndexableField)new StoredField("modified", DateTools.timeToString((long)System.currentTimeMillis(), (DateTools.Resolution)DateTools.Resolution.MINUTE)));
        Field contentsField = new Field("contents", docContent, this.ft);
        doc.add((IndexableField)contentsField);
        this.writer.addDocument((Iterable)doc);
    }

    @Override
    public void close() throws IOException {
        if (this.writer.hasUncommittedChanges()) {
            this.writer.commit();
        }
        this.writer.close();
    }
}

