/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.similarity.psi;

import com.ontotext.trree.plugin.similarity.IndexWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.WhitespaceAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;

public class SimilarityPredicationIndexWriter
implements IndexWriter {
    private final org.apache.lucene.index.IndexWriter writer;

    public SimilarityPredicationIndexWriter(File indexDir) throws IOException {
        IndexWriterConfig writerConfig = new IndexWriterConfig((Analyzer)new WhitespaceAnalyzer());
        this.writer = new org.apache.lucene.index.IndexWriter((Directory)FSDirectory.open((Path)indexDir.toPath()), writerConfig);
    }

    public void write(Long subject, Long predicate, Long object) throws IOException {
        Document doc = new Document();
        doc.add((IndexableField)new TextField("subject", subject.toString(), Field.Store.YES));
        doc.add((IndexableField)new TextField("predicate", predicate.toString(), Field.Store.YES));
        doc.add((IndexableField)new TextField("object", object.toString(), Field.Store.YES));
        doc.add((IndexableField)new TextField("predication", subject.toString() + "->" + predicate.toString() + "->" + object.toString(), Field.Store.NO));
        this.writer.addDocument((Iterable)doc);
    }

    @Override
    public void close() throws IOException {
        if (this.writer.hasUncommittedChanges()) {
            this.writer.commit();
        }
        this.writer.close();
    }
}

