/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.similarity.psi;

import com.ontotext.trree.plugin.similarity.FlagConfigUtils;
import com.ontotext.trree.plugin.similarity.SimilarityIndex;
import com.ontotext.trree.plugin.similarity.SimilarityIndexes;
import com.ontotext.trree.plugin.similarity.psi.SimilarityPredicationIndexWriter;
import com.ontotext.trree.sdk.PluginException;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pitt.search.semanticvectors.FlagConfig;
import pitt.search.semanticvectors.LuceneUtils;
import pitt.search.semanticvectors.PSI;
import pitt.search.semanticvectors.Search;
import pitt.search.semanticvectors.SearchResult;
import pitt.search.semanticvectors.VectorStoreUtils;
import pitt.search.semanticvectors.lsh.LSHStoreFactory;

public class SimilarityPredicationIndex
extends SimilarityIndex<SimilarityPredicationIndexWriter> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimilarityPredicationIndex.class);
    private static final String[] IMMUTABLE_ARGUMENTS = new String[]{"luceneindexpath"};
    public static final String PREDICATION_TYPE = "predication";

    public SimilarityPredicationIndex() {
    }

    public SimilarityPredicationIndex(String name, String initialConfigParams) {
        super(name, initialConfigParams, PREDICATION_TYPE);
    }

    @Override
    protected void initializeWriter(File indexDir) throws IOException {
        this.writer = new SimilarityPredicationIndexWriter(indexDir);
    }

    @Override
    protected boolean buildVectorsIndex(FlagConfig config) throws IOException {
        this.validateInputIndexConfig(config);
        if (new PSI(config, this.interruptIndexCreation).createIncrementalPSIVectors(config)) {
            if (config.lsh_hashes_num() != config.lsh_max_bits_diff()) {
                String elementalStoreName = VectorStoreUtils.getStoreFileName((String)config.elementalvectorfile(), (FlagConfig)config);
                LSHStoreFactory.INSTANCE.getStore(new File(elementalStoreName), config);
                String semanticStoreName = VectorStoreUtils.getStoreFileName((String)config.semanticvectorfile(), (FlagConfig)config);
                LSHStoreFactory.INSTANCE.getStore(new File(semanticStoreName), config);
            }
            return true;
        }
        return false;
    }

    private void validateInputIndexConfig(FlagConfig config) {
        if (!config.input_index().equals("")) {
            String inputIndexName = config.input_index();
            File inputDir = new File(new File(config.luceneindexpath()).getParentFile().getParentFile(), inputIndexName);
            if (!inputDir.exists()) {
                throw new PluginException("Specified input index does not exist: " + inputIndexName);
            }
            try {
                SimilarityIndex inputConfig = SimilarityIndexes.deserialize(new File(inputDir, inputIndexName + ".json"));
                switch (inputConfig.getStatus()) {
                    case OUTDATED: {
                        LOGGER.warn("The input index is with status OUTDATED: " + inputIndexName);
                        break;
                    }
                    case BUILT: {
                        break;
                    }
                    default: {
                        throw new PluginException("The input index is in status " + inputConfig.getStatus());
                    }
                }
                if (!inputConfig.getType().equalsIgnoreCase("textLiteral")) {
                    throw new PluginException("The input index is not a literal index: " + inputIndexName);
                }
            }
            catch (IOException e) {
                throw new PluginException("Could not deserialize input index: " + inputIndexName);
            }
        }
    }

    @Override
    protected void setConfig(String configurableArguments) {
        if (StringUtils.isNotEmpty((CharSequence)configurableArguments)) {
            for (String immutable : IMMUTABLE_ARGUMENTS) {
                if (!configurableArguments.contains("-" + immutable)) continue;
                throw new PluginException(String.format("Parameter \"%s\" is not configurable!", immutable));
            }
        }
        if (this.getStatus() == SimilarityIndex.Status.REBUILDING) {
            this.rebuildFlagConfig = FlagConfigUtils.fromString(configurableArguments);
        } else {
            this.config = FlagConfigUtils.fromString(configurableArguments);
        }
        try {
            FlagConfigUtils.setFlagValue(this.getCurrentFlagConfig(), "luceneindexpath", this.relationalizeFile(this.getName()));
        }
        catch (IOException | IllegalAccessException | NoSuchFieldException e) {
            throw new PluginException("Could not set index config", (Throwable)e);
        }
        this.relationalizeConfigFilePaths();
    }

    @Override
    public List<SearchResult> search(SimilarityIndex.SearchType searchType, String searchString, String configurableArguments) {
        if (!this.isIndexSearchable()) {
            LOGGER.error("The predication index {} could not be searched, because its status is: " + this.getStatus(), (Object)this.getName());
            return new LinkedList<SearchResult>();
        }
        FlagConfig searchConfiguration = FlagConfigUtils.fromString(configurableArguments);
        try {
            if (this.activeSearchesCounter.incrementAndGet() == 1) {
                this.specialStamp.getAndSet(this.activeSearchLock.readLock());
            }
            if (!configurableArguments.contains("lsh_hashes_num")) {
                FlagConfigUtils.setFlagValue(searchConfiguration, "lsh_hashes_num", this.config.lsh_hashes_num());
            }
            if (!configurableArguments.contains("lsh_max_bits_diff")) {
                FlagConfigUtils.setFlagValue(searchConfiguration, "lsh_max_bits_diff", this.config.lsh_max_bits_diff());
            }
            String luceneIndexPath = this.config.luceneindexpath();
            String semanticVectorFile = this.config.semanticvectorfile();
            String elementalVectorFile = this.config.elementalvectorfile();
            String elementalPredicateVectorFile = this.config.elementalpredicatevectorfile();
            FlagConfigUtils.setFlagValue(searchConfiguration, "luceneindexpath", luceneIndexPath);
            FlagConfigUtils.setFlagValue(searchConfiguration, "queryvectorfile", semanticVectorFile);
            FlagConfigUtils.setFlagValue(searchConfiguration, "searchvectorfile", "");
            FlagConfigUtils.setFlagValue(searchConfiguration, "remainingArgs", searchString.split(" "));
            FlagConfigUtils.setFlagValue(searchConfiguration, "termweight", LuceneUtils.TermWeight.NONE);
            if (searchType.equals((Object)SimilarityIndex.SearchType.PSI_PREDICATE)) {
                FlagConfigUtils.setFlagValue(searchConfiguration, "searchvectorfile", elementalVectorFile);
                FlagConfigUtils.setFlagValue(searchConfiguration, "boundvectorfile", elementalPredicateVectorFile);
                FlagConfigUtils.setFlagValue(searchConfiguration, "searchtype", Search.SearchType.BOUNDPRODUCT);
            }
            if (searchType.equals((Object)SimilarityIndex.SearchType.PSI_ANALOGICAL)) {
                FlagConfigUtils.setFlagValue(searchConfiguration, "matchcase", true);
                FlagConfigUtils.setFlagValue(searchConfiguration, "searchvectorfile", elementalVectorFile);
                FlagConfigUtils.setFlagValue(searchConfiguration, "boundvectorfile", elementalVectorFile);
                FlagConfigUtils.setFlagValue(searchConfiguration, "elementalvectorfile", elementalVectorFile);
                FlagConfigUtils.setFlagValue(searchConfiguration, "semanticvectorfile", semanticVectorFile);
                FlagConfigUtils.setFlagValue(searchConfiguration, "elementalpredicatevectorfile", elementalPredicateVectorFile);
                FlagConfigUtils.setFlagValue(searchConfiguration, "searchtype", Search.SearchType.BOUNDPRODUCT);
            }
            if (this.initialConfigParams.toLowerCase().contains("-indexfileformat text") && !configurableArguments.toLowerCase().contains("-indexfileformat text")) {
                LOGGER.info("Set indexfileformat ot text, found in create index parameters and not in search parameters.");
                FlagConfigUtils.setFlagValue(searchConfiguration, "indexfileformat", VectorStoreUtils.VectorStoreFormat.TEXT);
            }
            List list = Search.runSearch((FlagConfig)searchConfiguration);
            return list;
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new PluginException("You should not see this. Error when setting search arguments", (Throwable)e);
        }
        finally {
            if (this.activeSearchesCounter.decrementAndGet() == 0) {
                this.activeSearchLock.unlockRead(this.specialStamp.getAndSet(0L));
            }
        }
    }

    public void indexData(long subject, long predicate, long object) throws IOException {
        if (this.writer == null) {
            this.prepareForBuild();
        }
        try {
            ((SimilarityPredicationIndexWriter)this.writer).write(subject, predicate, object);
            this.transactionFingerprint ^= subject;
            ++this.docCount;
            if (this.docCount % 100000 == 0) {
                LOGGER.info("{} statements indexed in lucene", (Object)this.docCount);
            }
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }
}

