/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.similarity.iterators;

import com.ontotext.trree.plugin.similarity.SimilarityIndex;
import com.ontotext.trree.sdk.Entities;
import com.ontotext.trree.sdk.InternalServerErrorException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pitt.search.semanticvectors.SearchResult;

public class SimilarityEntityResult {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimilarityEntityResult.class);
    private final List<SearchResult> searchResults;
    private int currentPosition;
    private Entities entities;
    private SimilarityIndex.SearchType searchType;

    public SimilarityEntityResult(List<SearchResult> searchResults, SimilarityIndex.SearchType searchType) {
        this.searchResults = searchResults;
        this.searchType = searchType;
        this.currentPosition = -1;
    }

    public double getCurrentScore() {
        return this.searchResults.get(this.currentPosition).getScore();
    }

    public long getCurrentValue() {
        try {
            long valueId = 0L;
            if (this.searchType.toTerm()) {
                String resultTerm = this.searchResults.get(this.currentPosition).getObjectVector().getObject().toString();
                Literal l = SimpleValueFactory.getInstance().createLiteral(StringUtils.strip((String)resultTerm, (String)"\""));
                valueId = this.entities.put((Value)l, Entities.Scope.REQUEST);
            } else {
                valueId = Long.parseLong(this.searchResults.get(this.currentPosition).getObjectVector().getObject().toString());
            }
            LOGGER.debug("RESULT: {} with score {}", (Object)valueId, (Object)this.getCurrentScore());
            return valueId;
        }
        catch (Exception e) {
            LOGGER.error("Reading document failed", (Throwable)e);
            throw new InternalServerErrorException("Reading document failed", (Throwable)e);
        }
    }

    public boolean next() {
        boolean hasNext;
        ++this.currentPosition;
        boolean bl = hasNext = this.currentPosition < this.searchResults.size();
        if (!hasNext) {
            this.currentPosition = -1;
        }
        return hasNext;
    }

    public void setEntities(Entities entities) {
        this.entities = entities;
    }
}

