/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.similarity;

import com.ontotext.trree.plugin.similarity.iterators.AbstractResultIterator;
import com.ontotext.trree.plugin.similarity.iterators.EntityResultIterator;
import com.ontotext.trree.plugin.similarity.iterators.MasterResultIterator;
import com.ontotext.trree.sdk.Request;
import com.ontotext.trree.sdk.RequestContext;
import com.ontotext.trree.sdk.StatementIterator;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public final class SimilarityRequestContext
implements RequestContext {
    private Request request;
    private List<MasterResultIterator> masters;
    private List<EntityResultIterator> entities;

    public SimilarityRequestContext(Request request) {
        this.request = request;
    }

    public void registerIterator(AbstractResultIterator it) {
        if (it instanceof EntityResultIterator) {
            this.entities = SimilarityRequestContext.createIteratorList(this.entities);
            this.entities.add((EntityResultIterator)it);
        }
    }

    public void unregisterIterator(AbstractResultIterator it) {
        if (it instanceof EntityResultIterator && this.entities != null) {
            this.entities.remove((Object)it);
        }
    }

    public void registerIterator(MasterResultIterator it) {
        this.masters = SimilarityRequestContext.createIteratorList(this.masters);
        this.masters.add(it);
    }

    public void unregisterIterator(MasterResultIterator it) {
        this.masters.remove((Object)it);
    }

    public MasterResultIterator findMasterIterator(long subject) {
        return SimilarityRequestContext.findIteratorBySubject(this.masters, subject);
    }

    public EntityResultIterator findEntityResultIterator(long id) {
        return SimilarityRequestContext.findIteratorByObject(this.entities, id);
    }

    private static <T extends StatementIterator> List<T> createIteratorList(@Nullable List<T> list) {
        if (list == null) {
            list = new ArrayList<T>();
        }
        return list;
    }

    private static <T extends StatementIterator> T findIteratorBySubject(@Nullable List<T> list, long subject) {
        if (list == null) {
            return null;
        }
        for (StatementIterator it : list) {
            if (it.subject != subject) continue;
            return (T)it;
        }
        return null;
    }

    private static <T extends StatementIterator> T findIteratorByObject(@Nullable List<T> list, long object) {
        if (list == null) {
            return null;
        }
        for (StatementIterator it : list) {
            if (it.object != object) continue;
            return (T)it;
        }
        return null;
    }

    public Request getRequest() {
        return this.request;
    }

    public void setRequest(Request request) {
        this.request = request;
    }

    public void reset() {
        this.masters = null;
        this.entities = null;
    }
}

