/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.similarity;

import com.ontotext.trree.plugin.similarity.CreateIndexListener;
import com.ontotext.trree.plugin.similarity.FailedIndex;
import com.ontotext.trree.plugin.similarity.SimilarityIndex;
import com.ontotext.trree.plugin.similarity.SimilarityIndexes;
import com.ontotext.trree.plugin.similarity.SimilarityRequestContext;
import com.ontotext.trree.plugin.similarity.TripleGeneratingFunction;
import com.ontotext.trree.plugin.similarity.iterators.DummyIterator;
import com.ontotext.trree.plugin.similarity.iterators.EntityResultIterator;
import com.ontotext.trree.plugin.similarity.iterators.MasterResultIterator;
import com.ontotext.trree.plugin.similarity.iterators.ResultValueIterator;
import com.ontotext.trree.plugin.similarity.iterators.ScoreIterator;
import com.ontotext.trree.plugin.similarity.psi.SimilarityPredicationIndex;
import com.ontotext.trree.plugin.similarity.text.SimilarityTextIndex;
import com.ontotext.trree.sdk.BadRequestException;
import com.ontotext.trree.sdk.Entities;
import com.ontotext.trree.sdk.InitReason;
import com.ontotext.trree.sdk.PatternInterpreter;
import com.ontotext.trree.sdk.PluginBase;
import com.ontotext.trree.sdk.PluginConnection;
import com.ontotext.trree.sdk.PluginException;
import com.ontotext.trree.sdk.PluginTransactionListener;
import com.ontotext.trree.sdk.Postprocessor;
import com.ontotext.trree.sdk.Preprocessor;
import com.ontotext.trree.sdk.Request;
import com.ontotext.trree.sdk.RequestContext;
import com.ontotext.trree.sdk.StatementIterator;
import com.ontotext.trree.sdk.StatementListener;
import com.ontotext.trree.sdk.UpdateInterpreter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.query.BindingSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimilarityPlugin
extends PluginBase
implements PatternInterpreter,
UpdateInterpreter,
Preprocessor,
Postprocessor,
PluginTransactionListener,
StatementListener {
    private static final SimpleValueFactory vf = SimpleValueFactory.getInstance();
    private static final Logger LOGGER = LoggerFactory.getLogger(SimilarityPlugin.class);
    private long createIndexPredicateId;
    private long createPSIndexPredicateId;
    private long createIndexEntityId;
    private long createPSIndexDataSubjectId;
    private long createPSIndexDataPredicateId;
    private long createPSIndexDataObjectId;
    private long createIndexTextId;
    private long searchEntityPredicateId;
    private long psiSearchEntityPredicateId;
    private long psiSearchPredicatePredicateId;
    private long psiEntityResultPredicateId;
    private long psiAnyPredicatePredicateId;
    private long psiSearchAnalogicalGivenSubjectPredicateId;
    private long psiSearchAnalogicalGivenObjectPredicateId;
    private long psiSearchAnalogicalSearchSubjectPredicateId;
    private long psiSearchAnalogicalResultObjectPredicateId;
    private long searchTermPredicateId;
    private long searchParamsPredicateId;
    private long termsResultPredicateId;
    private long scorePredicateId;
    private long rdfTypeId;
    private long entitiesResultPredicateId;
    private long valueResultPredicateId;
    private long listPredicateId;
    private long namePredicateId;
    private long configPredicateId;
    private long statusPredicateId;
    private long stopListPredicateId;
    private long luceneAnalyzerPredicateId;
    private long rebuildIndexPredicateId;
    private long deleteIndexPredicateId;
    private long typePredicateId;
    private static final String SEMANTIC_VECTORS_MINIMAL_FREE_DISK_SPACE_PROPERTY = "semantic-vectors.minimal-free-disk-space";
    private static final String SEMANTIC_VECTORS_MINIMAL_FREE_DISK_SPACE_VALUE = "1GB";
    private static final String PREFIX = "http://www.ontotext.com/graphdb/similarity/";
    private static final String PREFIX_PSI = "http://www.ontotext.com/graphdb/similarity/psi/";
    private static final String INDEX_INSTANCE = "http://www.ontotext.com/graphdb/similarity/instance/";
    private static final String CREATE_INDEX_PREDICATE = "http://www.ontotext.com/graphdb/similarity/createIndex";
    private static final String CREATE_PS_INDEX_PREDICATE = "http://www.ontotext.com/graphdb/similarity/psi/createPredicationIndex";
    private static final String CREATE_PS_INDEX_DATA_SUBJECT = "http://www.ontotext.com/graphdb/similarity/psi/subject";
    private static final String CREATE_PS_INDEX_DATA_PREDICATE = "http://www.ontotext.com/graphdb/similarity/psi/predicate";
    private static final String CREATE_PS_INDEX_DATA_OBJECT = "http://www.ontotext.com/graphdb/similarity/psi/object";
    private static final String CREATE_INDEX_ENTITY = "http://www.ontotext.com/graphdb/similarity/documentID";
    private static final String CREATE_INDEX_TEXT = "http://www.ontotext.com/graphdb/similarity/documentText";
    private static final String CREATE_INDEX_STOPLIST_PARAMS = "http://www.ontotext.com/graphdb/similarity/stopList";
    private static final String CREATE_INDEX_ANALYZER = "http://www.ontotext.com/graphdb/similarity/analyzer";
    private static final String SEARCH_PSI_ENTITY = "http://www.ontotext.com/graphdb/similarity/psi/searchEntity";
    private static final String SEARCH_PSI_PREDICATE = "http://www.ontotext.com/graphdb/similarity/psi/searchPredicate";
    private static final String SEARCH_PSI_ENTITY_RESULT = "http://www.ontotext.com/graphdb/similarity/psi/entityResult";
    private static final String SEARCH_PSI_ANY = "http://www.ontotext.com/graphdb/similarity/psi/any";
    private static final String SEARCH_PSI_ANALOG_GIVEN_SUBJECT = "http://www.ontotext.com/graphdb/similarity/psi/givenSubject";
    private static final String SEARCH_PSI_ANALOG_GIVEN_OBJECT = "http://www.ontotext.com/graphdb/similarity/psi/givenObject";
    private static final String SEARCH_PSI_ANALOG_SEARCH_SUBJECT = "http://www.ontotext.com/graphdb/similarity/psi/searchSubject";
    private static final String SEARCH_PSI_ANALOG_RESULT_OBJECT = "http://www.ontotext.com/graphdb/similarity/psi/resultObject";
    private static final String SEARCH_ENTITY_PREDICATE = "http://www.ontotext.com/graphdb/similarity/searchDocumentID";
    private static final String SEARCH_TERM_PREDICATE = "http://www.ontotext.com/graphdb/similarity/searchTerm";
    private static final String SEARCH_TERM_PARAMS = "http://www.ontotext.com/graphdb/similarity/searchParameters";
    private static final String SCORE_PREDICATE = "http://www.ontotext.com/graphdb/similarity/score";
    private static final String ENTITIES_RESULT_PREDICATE = "http://www.ontotext.com/graphdb/similarity/documentResult";
    private static final String TERMS_RESULT_PREDICATE = "http://www.ontotext.com/graphdb/similarity/termResult";
    private static final String VALUE_RESULT_PREDICATE = "http://www.ontotext.com/graphdb/similarity/value";
    private static final String LIST_PREDICATE = "http://www.ontotext.com/graphdb/similarity/list";
    private static final String NAME_PREDICATE = "http://www.ontotext.com/graphdb/similarity/name";
    private static final String CONFIG_PREDICATE = "http://www.ontotext.com/graphdb/similarity/config";
    private static final String STATUS_PREDICATE = "http://www.ontotext.com/graphdb/similarity/status";
    private static final String TYPE_PREDICATE = "http://www.ontotext.com/graphdb/similarity/type";
    private static final String REBUILD_PREDICATE = "http://www.ontotext.com/graphdb/similarity/rebuildIndex";
    private static final String DELETE_PREDICATE = "http://www.ontotext.com/graphdb/similarity/deleteIndex";
    private static final double NULLARY_LEVEL_ESTIMATE = 0.01;
    private static final double NULLARY_LEVEL_INFINITY = Double.POSITIVE_INFINITY;
    private static final double PRIMARY_LEVEL_ESTIMATE = 0.1;
    private static final double PRIMARY_LEVEL_INFINITY = 1.1;
    private static final double SECONDARY_LEVEL_ESTIMATE = 0.2;
    private static final double SECONDARY_LEVEL_INFINITY = 1.2;
    private static final double TERTIARY_LEVEL_ESTIMATE = 0.3;
    private static final double TERTIARY_LEVEL_INFINITY = 1.3;
    private static Consumer<SimilarityIndex> deleteListener;
    protected String createIndexName;
    protected long createIndexURI;
    protected List<Pair<Long, String>> data;
    protected Long createEntityCurrentId;
    protected Long createPSCurrentSubjectId;
    protected Long createPSCurrentPredicateId;
    private CreateIndexListener createIndexListener;
    protected Map<Long, SimilarityIndex> similarityIndexes;

    public void initialize(InitReason initReason, PluginConnection pluginConnection) {
        SimilarityPlugin.setSemanticVectorsMinimalFreeDiskSpaceIfNeeded();
        Entities entities = pluginConnection.getEntities();
        this.createIndexPredicateId = entities.put((Value)vf.createIRI(CREATE_INDEX_PREDICATE), Entities.Scope.SYSTEM);
        this.createPSIndexPredicateId = entities.put((Value)vf.createIRI(CREATE_PS_INDEX_PREDICATE), Entities.Scope.SYSTEM);
        this.createIndexEntityId = entities.put((Value)vf.createIRI(CREATE_INDEX_ENTITY), Entities.Scope.SYSTEM);
        this.createPSIndexDataSubjectId = entities.put((Value)vf.createIRI(CREATE_PS_INDEX_DATA_SUBJECT), Entities.Scope.SYSTEM);
        this.createPSIndexDataPredicateId = entities.put((Value)vf.createIRI(CREATE_PS_INDEX_DATA_PREDICATE), Entities.Scope.SYSTEM);
        this.createPSIndexDataObjectId = entities.put((Value)vf.createIRI(CREATE_PS_INDEX_DATA_OBJECT), Entities.Scope.SYSTEM);
        this.createIndexTextId = entities.put((Value)vf.createIRI(CREATE_INDEX_TEXT), Entities.Scope.SYSTEM);
        this.searchEntityPredicateId = entities.put((Value)vf.createIRI(SEARCH_ENTITY_PREDICATE), Entities.Scope.SYSTEM);
        this.searchTermPredicateId = entities.put((Value)vf.createIRI(SEARCH_TERM_PREDICATE), Entities.Scope.SYSTEM);
        this.searchParamsPredicateId = entities.put((Value)vf.createIRI(SEARCH_TERM_PARAMS), Entities.Scope.SYSTEM);
        this.psiSearchEntityPredicateId = entities.put((Value)vf.createIRI(SEARCH_PSI_ENTITY), Entities.Scope.SYSTEM);
        this.psiSearchPredicatePredicateId = entities.put((Value)vf.createIRI(SEARCH_PSI_PREDICATE), Entities.Scope.SYSTEM);
        this.psiAnyPredicatePredicateId = entities.put((Value)vf.createIRI(SEARCH_PSI_ANY), Entities.Scope.SYSTEM);
        this.psiEntityResultPredicateId = entities.put((Value)vf.createIRI(SEARCH_PSI_ENTITY_RESULT), Entities.Scope.SYSTEM);
        this.psiSearchAnalogicalGivenSubjectPredicateId = entities.put((Value)vf.createIRI(SEARCH_PSI_ANALOG_GIVEN_SUBJECT), Entities.Scope.SYSTEM);
        this.psiSearchAnalogicalGivenObjectPredicateId = entities.put((Value)vf.createIRI(SEARCH_PSI_ANALOG_GIVEN_OBJECT), Entities.Scope.SYSTEM);
        this.psiSearchAnalogicalSearchSubjectPredicateId = entities.put((Value)vf.createIRI(SEARCH_PSI_ANALOG_SEARCH_SUBJECT), Entities.Scope.SYSTEM);
        this.psiSearchAnalogicalResultObjectPredicateId = entities.put((Value)vf.createIRI(SEARCH_PSI_ANALOG_RESULT_OBJECT), Entities.Scope.SYSTEM);
        this.termsResultPredicateId = entities.put((Value)vf.createIRI(TERMS_RESULT_PREDICATE), Entities.Scope.SYSTEM);
        this.valueResultPredicateId = entities.put((Value)vf.createIRI(VALUE_RESULT_PREDICATE), Entities.Scope.SYSTEM);
        this.scorePredicateId = entities.put((Value)vf.createIRI(SCORE_PREDICATE), Entities.Scope.SYSTEM);
        this.entitiesResultPredicateId = entities.put((Value)vf.createIRI(ENTITIES_RESULT_PREDICATE), Entities.Scope.SYSTEM);
        this.listPredicateId = entities.put((Value)vf.createIRI(LIST_PREDICATE), Entities.Scope.SYSTEM);
        this.namePredicateId = entities.put((Value)vf.createIRI(NAME_PREDICATE), Entities.Scope.SYSTEM);
        this.configPredicateId = entities.put((Value)vf.createIRI(CONFIG_PREDICATE), Entities.Scope.SYSTEM);
        this.statusPredicateId = entities.put((Value)vf.createIRI(STATUS_PREDICATE), Entities.Scope.SYSTEM);
        this.typePredicateId = entities.put((Value)vf.createIRI(TYPE_PREDICATE), Entities.Scope.SYSTEM);
        this.rdfTypeId = entities.put((Value)RDF.TYPE, Entities.Scope.DEFAULT);
        this.stopListPredicateId = entities.put((Value)vf.createIRI(CREATE_INDEX_STOPLIST_PARAMS), Entities.Scope.SYSTEM);
        this.luceneAnalyzerPredicateId = entities.put((Value)vf.createIRI(CREATE_INDEX_ANALYZER), Entities.Scope.SYSTEM);
        this.rebuildIndexPredicateId = entities.put((Value)vf.createIRI(REBUILD_PREDICATE), Entities.Scope.SYSTEM);
        this.deleteIndexPredicateId = entities.put((Value)vf.createIRI(DELETE_PREDICATE), Entities.Scope.SYSTEM);
        this.createIndexListener = new CreateIndexListener(this);
        deleteListener = index -> this.similarityIndexes.remove(entities.resolve((Value)vf.createIRI(INDEX_INSTANCE, index.getName())));
        this.similarityIndexes = this.loadSimilarityIndexes(entities);
        this.similarityIndexes.values().forEach(idx -> idx.setDeleteListener(deleteListener));
        this.initializeLucene();
    }

    private static void setSemanticVectorsMinimalFreeDiskSpaceIfNeeded() {
        if (StringUtils.isBlank((CharSequence)System.getProperty(SEMANTIC_VECTORS_MINIMAL_FREE_DISK_SPACE_PROPERTY))) {
            System.setProperty(SEMANTIC_VECTORS_MINIMAL_FREE_DISK_SPACE_PROPERTY, SEMANTIC_VECTORS_MINIMAL_FREE_DISK_SPACE_VALUE);
        }
    }

    private void initializeLucene() {
        File dataDir = this.getDataDir();
        if (!dataDir.exists()) {
            dataDir.mkdirs();
        } else {
            Pattern pattern = Pattern.compile("temp_idx_\\d{5,}");
            File[] previousTempIndexes = dataDir.listFiles(file -> file.isDirectory() && pattern.matcher(file.getName()).matches());
            if (previousTempIndexes != null && previousTempIndexes.length > 0) {
                for (File tempIndex : previousTempIndexes) {
                    try {
                        FileUtils.deleteDirectory((File)tempIndex);
                    }
                    catch (IOException e) {
                        this.getLogger().warn("Could not clean temporary index folder!", (Throwable)e);
                    }
                }
            }
        }
        File tempIndexDir = new File(dataDir, "temp_idx_" + System.currentTimeMillis());
        try (FSDirectory fsDirectory = FSDirectory.open((Path)tempIndexDir.toPath());){
            IndexWriterConfig iwc = new IndexWriterConfig();
            iwc.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
            try (IndexWriter writer = new IndexWriter((Directory)fsDirectory, iwc);){
                Document document = new Document();
                document.add((IndexableField)new StringField("text", "test value", Field.Store.YES));
                writer.addDocument((Iterable)document);
                writer.commit();
            }
            try (DirectoryReader reader = DirectoryReader.open((Directory)fsDirectory);){
                IndexSearcher searcher = new IndexSearcher((IndexReader)reader);
                QueryParser parser = new QueryParser("text", (Analyzer)new StandardAnalyzer());
                Query query = parser.parse("test");
                searcher.search(query, 1);
            }
        }
        catch (Exception e) {
            throw new PluginException("Failed to initialize Lucene", (Throwable)e);
        }
        finally {
            try {
                FileUtils.deleteDirectory((File)tempIndexDir);
            }
            catch (IOException e) {
                this.getLogger().warn("Could not clean temporary index folder. Will be cleaned on next startup", (Throwable)e);
            }
        }
    }

    private Map<Long, SimilarityIndex> loadSimilarityIndexes(Entities entities) {
        LinkedHashMap<Long, SimilarityIndex> indexes = new LinkedHashMap<Long, SimilarityIndex>();
        File dataDir = this.getDataDir();
        if (dataDir.exists()) {
            for (File indexDir : dataDir.listFiles(File::isDirectory)) {
                File serialized;
                String indexName = indexDir.getName();
                IRI indexIri = SimpleValueFactory.getInstance().createIRI(INDEX_INSTANCE + indexName);
                File oldSerialized = new File(indexDir, indexName + ".ser");
                if (oldSerialized.exists()) {
                    LOGGER.info(String.format("Could not deserialize index %s from directory %s due to old format. Mark it as obsolete.", indexName, indexDir.getAbsolutePath()));
                    this.initFailedIndex(indexes, indexName, indexIri, entities);
                }
                if (!(serialized = new File(indexDir, indexName + ".json")).exists()) continue;
                try {
                    SimilarityIndex deserialized = SimilarityIndexes.deserialize(serialized);
                    deserialized.initialize(this.getDataDir());
                    switch (deserialized.getStatus()) {
                        case BUILT: 
                        case OUTDATED: 
                        case INTERRUPTED: {
                            break;
                        }
                        default: {
                            deserialized.setStatus(SimilarityIndex.Status.FAILED);
                        }
                    }
                    SimilarityIndexes.serialize(deserialized);
                    indexes.put(entities.put((Value)indexIri, Entities.Scope.SYSTEM), deserialized);
                }
                catch (Throwable e) {
                    LOGGER.error(String.format("Could not deserialize index %s from directory %s. Mark it as obsolete.", indexName, indexDir.getAbsolutePath()), (Object)e.getMessage());
                    this.initFailedIndex(indexes, indexName, indexIri, entities);
                }
            }
        }
        return indexes;
    }

    private void initFailedIndex(Map<Long, SimilarityIndex> indexes, String indexName, IRI indexIri, Entities entities) {
        FailedIndex failedIndex = new FailedIndex(indexName);
        indexes.put(entities.put((Value)indexIri, Entities.Scope.SYSTEM), failedIndex);
    }

    public double estimate(long subject, long predicate, long object, long context, PluginConnection pluginConnection, RequestContext requestContext) {
        if (predicate == this.rdfTypeId) {
            return subject == 0L ? 0.01 : Double.POSITIVE_INFINITY;
        }
        if (predicate == this.searchParamsPredicateId) {
            return subject == Long.MAX_VALUE ? 0.1 : 1.1;
        }
        if (predicate == this.psiSearchPredicatePredicateId) {
            return subject == Long.MAX_VALUE ? 0.1 : 1.1;
        }
        if (predicate == this.searchTermPredicateId || predicate == this.searchEntityPredicateId || predicate == this.psiSearchEntityPredicateId || predicate == this.psiSearchAnalogicalGivenSubjectPredicateId || predicate == this.psiSearchAnalogicalGivenObjectPredicateId || predicate == this.psiSearchAnalogicalSearchSubjectPredicateId) {
            if (object == 0L) {
                return Double.POSITIVE_INFINITY;
            }
            return subject == Long.MAX_VALUE ? 0.1 : 1.1;
        }
        if (predicate == this.entitiesResultPredicateId || predicate == this.psiEntityResultPredicateId || predicate == this.psiSearchAnalogicalResultObjectPredicateId) {
            return subject == Long.MAX_VALUE ? 0.2 : 1.2;
        }
        if (predicate == this.scorePredicateId || predicate == this.valueResultPredicateId) {
            return subject == Long.MAX_VALUE ? 0.3 : 1.3;
        }
        return 1.0;
    }

    public StatementIterator interpret(long subject, long predicate, long object, long context, PluginConnection pluginConnection, RequestContext requestContext) {
        EntityResultIterator eri;
        SimilarityIndex similarityIndex;
        MasterResultIterator mri;
        SimilarityRequestContext src = (SimilarityRequestContext)requestContext;
        if (predicate == this.entitiesResultPredicateId || predicate == this.termsResultPredicateId || predicate == this.psiEntityResultPredicateId || predicate == this.psiSearchAnalogicalResultObjectPredicateId) {
            if (subject == 0L) {
                return new DummyIterator(EntityResultIterator.class.getSimpleName());
            }
            mri = src.findMasterIterator(subject);
            if (mri != null) {
                EntityResultIterator entityResultIterator = new EntityResultIterator();
                entityResultIterator.setSPO(subject, predicate, object);
                entityResultIterator.setEntities(pluginConnection.getEntities());
                entityResultIterator.setMasterResultIterator(mri);
                src.registerIterator(entityResultIterator);
                if (predicate == this.entitiesResultPredicateId && mri.shouldSearchByTerm()) {
                    entityResultIterator.setSearchType(SimilarityIndex.SearchType.TERM_TO_DOC);
                } else if (predicate == this.entitiesResultPredicateId) {
                    entityResultIterator.setSearchType(SimilarityIndex.SearchType.DOC_TO_DOC);
                } else if (predicate == this.psiEntityResultPredicateId) {
                    entityResultIterator.setSearchType(SimilarityIndex.SearchType.PSI);
                } else if (predicate == this.psiSearchAnalogicalResultObjectPredicateId) {
                    entityResultIterator.setSearchType(SimilarityIndex.SearchType.PSI_ANALOGICAL);
                }
                if (predicate == this.termsResultPredicateId && mri.shouldSearchByTerm()) {
                    entityResultIterator.setSearchType(SimilarityIndex.SearchType.TERM_TO_TERM);
                } else if (predicate == this.termsResultPredicateId) {
                    entityResultIterator.setSearchType(SimilarityIndex.SearchType.DOC_TO_TERM);
                }
                return entityResultIterator;
            }
        }
        if (predicate == this.psiSearchPredicatePredicateId) {
            if (subject == 0L) {
                return new DummyIterator(EntityResultIterator.class.getSimpleName());
            }
            mri = src.findMasterIterator(subject);
            if (mri != null) {
                if (object == 0L || object == this.psiAnyPredicatePredicateId) {
                    return StatementIterator.create((long)1L, (long)1L, (long)this.psiAnyPredicatePredicateId, (long)1L);
                }
                if (object != 0L) {
                    mri.setPsiQueryPredicate(object);
                    return StatementIterator.TRUE();
                }
            }
        }
        if (predicate == this.searchParamsPredicateId) {
            if (subject == 0L) {
                return new DummyIterator("Search params");
            }
            mri = src.findMasterIterator(subject);
            if (mri != null) {
                Value paramsValue = pluginConnection.getEntities().get(object);
                if (paramsValue == null) {
                    throw new BadRequestException("No value for search params query. Is the variable bound?");
                }
                mri.setSearchOptions(paramsValue.stringValue());
                return StatementIterator.TRUE();
            }
        }
        if (predicate == this.rdfTypeId && object < 0L && (similarityIndex = this.similarityIndexes.get(object)) != null) {
            MasterResultIterator masterIterator = new MasterResultIterator(pluginConnection.getEntities(), (SimilarityRequestContext)requestContext);
            masterIterator.setSimilarityIndex(similarityIndex);
            ((SimilarityRequestContext)requestContext).registerIterator(masterIterator);
            return masterIterator;
        }
        if (predicate == this.searchTermPredicateId) {
            if (subject == 0L) {
                return new DummyIterator("searchTerm");
            }
            mri = src.findMasterIterator(subject);
            if (mri != null) {
                Value queryValue = pluginConnection.getEntities().get(object);
                if (queryValue == null) {
                    throw new BadRequestException("No value for searchTerm query. Is the variable bound?");
                }
                String queryStr = queryValue.stringValue();
                mri.setQueryString(queryStr);
                return StatementIterator.TRUE();
            }
            return null;
        }
        if (predicate == this.searchEntityPredicateId || predicate == this.psiSearchEntityPredicateId) {
            if (object < 0L) {
                return StatementIterator.EMPTY;
            }
            if (subject == 0L) {
                return new DummyIterator("searchDocumentID");
            }
            mri = src.findMasterIterator(subject);
            if (mri != null) {
                if (object == 0L) {
                    throw new BadRequestException("No value for searchEntity query. Is the variable bound?");
                }
                mri.setQueryEntity(object);
                return StatementIterator.TRUE();
            }
            return null;
        }
        if (predicate == this.psiSearchAnalogicalGivenSubjectPredicateId || predicate == this.psiSearchAnalogicalGivenObjectPredicateId || predicate == this.psiSearchAnalogicalSearchSubjectPredicateId) {
            if (object < 0L) {
                return StatementIterator.EMPTY;
            }
            if (subject == 0L) {
                return new DummyIterator("searchAnalogicalID");
            }
            mri = src.findMasterIterator(subject);
            if (mri != null) {
                if (object == 0L) {
                    throw new BadRequestException("No value for " + pluginConnection.getEntities().get(predicate) + " query. Is the variable bound?");
                }
                if (predicate == this.psiSearchAnalogicalGivenSubjectPredicateId) {
                    mri.setQuerySubject(object);
                }
                if (predicate == this.psiSearchAnalogicalGivenObjectPredicateId) {
                    mri.setQueryObject(object);
                }
                if (predicate == this.psiSearchAnalogicalSearchSubjectPredicateId) {
                    mri.setSearchSubject(object);
                }
                return StatementIterator.TRUE();
            }
            return null;
        }
        if (predicate == this.valueResultPredicateId) {
            if (subject == 0L) {
                return new DummyIterator(ResultValueIterator.class.getSimpleName());
            }
            eri = src.findEntityResultIterator(subject);
            if (eri != null) {
                ResultValueIterator valueIterator = new ResultValueIterator();
                valueIterator.setSPO(subject, predicate, object);
                valueIterator.setEntities(pluginConnection.getEntities());
                valueIterator.setEntityResultIterator(eri);
                src.registerIterator(valueIterator);
                return valueIterator;
            }
        }
        if (predicate == this.scorePredicateId) {
            if (subject == 0L) {
                return new DummyIterator(ScoreIterator.class.getSimpleName());
            }
            eri = src.findEntityResultIterator(subject);
            if (eri != null) {
                ScoreIterator scoreIterator = new ScoreIterator();
                scoreIterator.setSPO(subject, predicate, object);
                scoreIterator.setEntities(pluginConnection.getEntities());
                scoreIterator.setEntityResultIterator(eri);
                src.registerIterator(scoreIterator);
                return scoreIterator;
            }
        }
        if (predicate == this.listPredicateId) {
            long[][] triples = new long[this.similarityIndexes.size()][];
            int index = 0;
            for (Long indexId : this.similarityIndexes.keySet()) {
                triples[index++] = new long[]{subject, predicate, indexId, 0L};
            }
            return StatementIterator.create((long[][])triples);
        }
        if (predicate == this.namePredicateId) {
            return this.generateTriples(subject, id -> new long[]{id, predicate, pluginConnection.getEntities().put((Value)vf.createLiteral(this.similarityIndexes.get(id).getName()), Entities.Scope.REQUEST), 0L});
        }
        if (predicate == this.configPredicateId) {
            return this.generateTriples(subject, id -> new long[]{id, predicate, pluginConnection.getEntities().put((Value)vf.createLiteral(this.similarityIndexes.get(id).getInitialConfigParams()), Entities.Scope.REQUEST), 0L});
        }
        if (predicate == this.statusPredicateId) {
            return this.generateTriples(subject, id -> new long[]{id, predicate, pluginConnection.getEntities().put((Value)vf.createLiteral(this.similarityIndexes.get(id).getStatus().toString()), Entities.Scope.REQUEST), 0L});
        }
        if (predicate == this.typePredicateId) {
            return this.generateTriples(subject, id -> new long[]{id, predicate, pluginConnection.getEntities().put((Value)vf.createLiteral(this.similarityIndexes.get(id).getType()), Entities.Scope.REQUEST), 0L});
        }
        return null;
    }

    private StatementIterator generateTriples(long subject, TripleGeneratingFunction function) {
        long[][] triples = new long[][]{};
        if (subject != 0L && this.similarityIndexes.containsKey(subject)) {
            triples = new long[][]{function.generate(subject)};
        }
        if (subject == 0L) {
            triples = new long[this.similarityIndexes.size()][];
            int index = 0;
            for (Long id : this.similarityIndexes.keySet()) {
                triples[index++] = function.generate(id);
            }
        }
        return triples.length != 0 ? StatementIterator.create((long[][])triples) : null;
    }

    public RequestContext preprocess(Request request) {
        return new SimilarityRequestContext(request);
    }

    public long[] getPredicatesToListenFor() {
        return new long[]{this.createIndexPredicateId, this.createPSIndexPredicateId, this.createIndexEntityId, this.createIndexTextId, this.createPSIndexDataSubjectId, this.createPSIndexDataPredicateId, this.createPSIndexDataObjectId, this.stopListPredicateId, this.rebuildIndexPredicateId, this.deleteIndexPredicateId, this.luceneAnalyzerPredicateId};
    }

    public boolean interpretUpdate(long subject, long predicate, long object, long context, boolean isAddition, boolean isExplicit, PluginConnection pluginConnection) {
        if (!isExplicit) {
            return false;
        }
        Entities entities = pluginConnection.getEntities();
        if (predicate == this.createIndexPredicateId || predicate == this.createPSIndexPredicateId) {
            String indexName;
            if (!(entities.get(object) instanceof Literal)) {
                throw new PluginException("Index options should be a literal.");
            }
            if (this.createIndexName != null) {
                return true;
            }
            String commandArguments = entities.get(object).stringValue();
            IRI indexIRI = (IRI)entities.get(subject);
            if (subject > 0L) {
                throw new BadRequestException(String.format("Cannot create an index \"%s\". IRI exists as an entity.", indexIRI));
            }
            this.createIndexName = indexName = this.getIndexName(indexIRI);
            this.createIndexURI = entities.put((Value)indexIRI, Entities.Scope.SYSTEM);
            if (this.similarityIndexes.get(this.createIndexURI) == null || this.similarityIndexes.get(this.createIndexURI).getStatus() != SimilarityIndex.Status.REBUILDING) {
                SimilarityIndex similarityIndex;
                try {
                    if (predicate == this.createIndexPredicateId) {
                        similarityIndex = new SimilarityTextIndex(indexName, commandArguments);
                    } else if (predicate == this.createPSIndexPredicateId) {
                        similarityIndex = new SimilarityPredicationIndex(indexName, commandArguments);
                    } else {
                        throw new PluginException("Oooops. Should not come here.");
                    }
                    similarityIndex.setDeleteListener(deleteListener);
                    ((SimilarityIndex)similarityIndex).initialize(this.getDataDir(), true);
                }
                catch (IOException e) {
                    throw new PluginException("Could not initialize index", (Throwable)e);
                }
                this.similarityIndexes.put(this.createIndexURI, similarityIndex);
                try {
                    SimilarityIndexes.serialize(similarityIndex);
                }
                catch (IOException e) {
                    throw new PluginException("Could not serialize index " + indexName, (Throwable)e);
                }
            }
            return true;
        }
        if (predicate == this.createIndexEntityId) {
            if (object < 0L) {
                throw new PluginException(String.format("Trying to store entity \"%s\" which is not present in the database.Only data present in the database can be indexed", entities.get(object)));
            }
            if (entities.get(object) instanceof Literal) {
                throw new PluginException("Entities can be only IRIs or BlankNodes");
            }
            this.createEntityCurrentId = object;
            return true;
        }
        if (predicate == this.createIndexTextId) {
            if (this.createEntityCurrentId == null) {
                throw new PluginException("Trying to add text value to non-existing entity");
            }
            SimilarityIndex index = this.similarityIndexes.get(this.createIndexURI);
            if (index == null) {
                throw new PluginException("No such index " + this.createIndexURI);
            }
            if (subject != this.createEntityCurrentId && !index.getConfig().literal_index()) {
                throw new PluginException(String.format("%s should follow %s!", CREATE_INDEX_TEXT, CREATE_INDEX_ENTITY));
            }
            if (!(entities.get(object) instanceof Literal)) {
                this.createEntityCurrentId = null;
                return true;
            }
            Literal textLiteral = (Literal)entities.get(object);
            if (index instanceof SimilarityTextIndex) {
                try {
                    long id = index.getConfig().literal_index() ? object : this.createEntityCurrentId;
                    ((SimilarityTextIndex)index).indexData(id, textLiteral.stringValue());
                }
                catch (IOException e) {
                    throw new PluginException(e.getMessage());
                }
            } else {
                throw new PluginException("No such text index " + this.createIndexURI);
            }
            this.createEntityCurrentId = null;
            return true;
        }
        if (predicate == this.createPSIndexDataSubjectId) {
            if (object < 0L) {
                throw new PluginException(String.format("Trying to store entity \"%s\" which is not present in the database.Only data present in the database can be indexed", entities.get(object)));
            }
            if (entities.get(object) instanceof Literal) {
                throw new PluginException("Subject can be only IRIs or BlankNodes");
            }
            this.createPSCurrentSubjectId = object;
            return true;
        }
        if (predicate == this.createPSIndexDataPredicateId) {
            if (this.createPSCurrentSubjectId == null) {
                throw new PluginException("Trying to add predicate value to non-existing subject");
            }
            if (subject != this.createPSCurrentSubjectId) {
                throw new PluginException(String.format("%s should follow %s!", CREATE_PS_INDEX_DATA_PREDICATE, CREATE_PS_INDEX_DATA_SUBJECT));
            }
            if (entities.get(object) instanceof Literal || entities.get(object) instanceof BNode) {
                throw new PluginException("Predicates can be only IRIs");
            }
            this.createPSCurrentPredicateId = object;
            return true;
        }
        if (predicate == this.createPSIndexDataObjectId) {
            if (this.createPSCurrentSubjectId == null) {
                throw new PluginException("Trying to add object value to non-existing subject");
            }
            if (this.createPSCurrentPredicateId == null) {
                throw new PluginException("Trying to add object value to non-existing predicate");
            }
            if (subject != this.createPSCurrentSubjectId) {
                throw new PluginException(String.format("%s should follow %s!", CREATE_PS_INDEX_DATA_OBJECT, CREATE_PS_INDEX_DATA_SUBJECT));
            }
            SimilarityIndex index = this.similarityIndexes.get(this.createIndexURI);
            if (index != null && index instanceof SimilarityPredicationIndex) {
                try {
                    ((SimilarityPredicationIndex)index).indexData(this.createPSCurrentSubjectId, this.createPSCurrentPredicateId, object);
                }
                catch (IOException e) {
                    throw new PluginException(e.getMessage());
                }
            } else {
                throw new PluginException("No such predication index. " + this.createIndexURI);
            }
            this.createPSCurrentSubjectId = null;
            this.createPSCurrentPredicateId = null;
            return true;
        }
        if (predicate == this.rebuildIndexPredicateId) {
            IRI indexIRI = (IRI)entities.get(subject);
            String indexName = this.getIndexName(indexIRI);
            long entityID = entities.resolve((Value)indexIRI);
            if (!this.similarityIndexes.containsKey(entityID)) {
                throw new PluginException(String.format("Index %s does not exist.", indexName));
            }
            SimilarityIndex index = this.similarityIndexes.get(entityID);
            switch (index.getStatus()) {
                case BUILDING: {
                    LOGGER.info("Already running build of index {}", (Object)index.getName());
                    throw new PluginException(String.format("Already running build of index %s", index.getName()));
                }
                case REBUILDING: {
                    LOGGER.info("Already running rebuild of index {}", (Object)index.getName());
                    throw new PluginException(String.format("Already running rebuild of index %s", index.getName()));
                }
                case INTERRUPTED: 
                case FAILED: 
                case OBSOLETE: {
                    LOGGER.info("Previous status {} of index {} does not allow searches during rebuild", (Object)index.getStatus(), (Object)index.getName());
                    index.writer = null;
                    index.fingerprint = 0L;
                    return true;
                }
            }
            index.writer = null;
            index.fingerprint = 0L;
            index.setStatus(SimilarityIndex.Status.REBUILDING);
            return true;
        }
        if (predicate == this.deleteIndexPredicateId) {
            IRI indexIRI = (IRI)entities.get(subject);
            String indexName = this.getIndexName(indexIRI);
            long entityID = entities.resolve((Value)indexIRI);
            if (!this.similarityIndexes.containsKey(entityID)) {
                return true;
            }
            try {
                this.similarityIndexes.get(entityID).delete();
                this.similarityIndexes.remove(entityID);
            }
            catch (IOException e) {
                throw new PluginException("Cannot delete index. " + indexName, (Throwable)e);
            }
            return true;
        }
        if (predicate == this.stopListPredicateId) {
            if (!(entities.get(object) instanceof Literal)) {
                throw new PluginException("Stop list should be literal.");
            }
            if (StringUtils.isEmpty((CharSequence)this.createIndexName)) {
                return false;
            }
            Literal stopListText = (Literal)entities.get(object);
            SimilarityIndex similarityTextIndex = this.similarityIndexes.get(this.createIndexURI);
            if (similarityTextIndex != null && similarityTextIndex instanceof SimilarityTextIndex) {
                String[] splitWords = stopListText.stringValue().split(" ");
                ((SimilarityTextIndex)similarityTextIndex).setStopWords(Arrays.asList(splitWords));
            }
            return true;
        }
        if (predicate == this.luceneAnalyzerPredicateId) {
            if (!(entities.get(object) instanceof Literal)) {
                throw new PluginException("Lucene Analyzer class is expected");
            }
            if (StringUtils.isEmpty((CharSequence)this.createIndexName)) {
                return false;
            }
            Literal luceneIndexClass = (Literal)entities.get(object);
            SimilarityIndex similarityTextIndex = this.similarityIndexes.get(this.createIndexURI);
            if (similarityTextIndex != null && similarityTextIndex instanceof SimilarityTextIndex && !similarityTextIndex.prepared()) {
                try {
                    ((SimilarityTextIndex)similarityTextIndex).setAnalyzer(luceneIndexClass.stringValue());
                }
                catch (Exception e) {
                    throw new PluginException(e.getMessage());
                }
            }
            return true;
        }
        return false;
    }

    private String getIndexName(IRI indexIRI) {
        String indexName = indexIRI.stringValue();
        if (!indexName.startsWith(INDEX_INSTANCE)) {
            throw new PluginException("Not a valid index name. Should start with http://www.ontotext.com/graphdb/similarity/instance/");
        }
        indexName = indexName.substring(INDEX_INSTANCE.length());
        return indexName;
    }

    public String getName() {
        return "similarity";
    }

    public boolean shouldPostprocess(RequestContext requestContext) {
        return false;
    }

    public BindingSet postprocess(BindingSet bindingSet, RequestContext requestContext) {
        return null;
    }

    public Iterator<BindingSet> flush(RequestContext requestContext) {
        return null;
    }

    public long getFingerprint() {
        long fp = 0L;
        for (SimilarityIndex index : this.similarityIndexes.values()) {
            fp ^= index.getFingerprint();
        }
        return fp;
    }

    public void transactionAbortedByUser(PluginConnection pluginConnection) {
        this.createIndexListener.transactionAbortedByUser(pluginConnection);
    }

    public void transactionStarted(PluginConnection pluginConnection) {
        this.createIndexListener.transactionStarted(pluginConnection);
    }

    public void transactionCommit(PluginConnection pluginConnection) {
        this.createIndexListener.transactionCommit(pluginConnection);
    }

    public void transactionCompleted(PluginConnection pluginConnection) {
        this.createIndexListener.transactionCompleted(pluginConnection);
    }

    public void transactionAborted(PluginConnection pluginConnection) {
        this.createIndexListener.transactionAborted(pluginConnection);
    }

    public boolean statementAdded(long l, long l1, long l2, long l3, boolean b, PluginConnection pluginConnection) {
        return this.createIndexListener.statementAdded(l, l1, l2, l3, b, pluginConnection);
    }

    public boolean statementRemoved(long l, long l1, long l2, long l3, boolean b, PluginConnection pluginConnection) {
        return this.createIndexListener.statementRemoved(l, l1, l2, l3, b, pluginConnection);
    }
}

