/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.query.translation.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.exception.OntopInvalidKGQueryException;
import it.unibz.inf.ontop.exception.OntopUnsupportedKGQueryException;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.injection.OntopKGQuerySettings;
import it.unibz.inf.ontop.iq.IQ;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.UnaryIQTree;
import it.unibz.inf.ontop.iq.impl.IQTreeTools;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.iq.node.InnerJoinNode;
import it.unibz.inf.ontop.iq.node.IntensionalDataNode;
import it.unibz.inf.ontop.iq.node.QueryModifierNode;
import it.unibz.inf.ontop.iq.node.QueryNode;
import it.unibz.inf.ontop.iq.node.TrueNode;
import it.unibz.inf.ontop.iq.node.UnaryOperatorNode;
import it.unibz.inf.ontop.model.atom.AtomFactory;
import it.unibz.inf.ontop.model.atom.DataAtom;
import it.unibz.inf.ontop.model.atom.DistinctVariableOnlyDataAtom;
import it.unibz.inf.ontop.model.term.BNode;
import it.unibz.inf.ontop.model.term.GroundTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.VariableOrGroundTerm;
import it.unibz.inf.ontop.model.term.functionsymbol.FunctionSymbolFactory;
import it.unibz.inf.ontop.model.type.TypeFactory;
import it.unibz.inf.ontop.query.aggregates.StdevPopAggregateFactory;
import it.unibz.inf.ontop.query.aggregates.StdevSampAggregateFactory;
import it.unibz.inf.ontop.query.aggregates.StdevShortAggregateFactory;
import it.unibz.inf.ontop.query.aggregates.VariancePopAggregateFactory;
import it.unibz.inf.ontop.query.aggregates.VarianceSampAggregateFactory;
import it.unibz.inf.ontop.query.aggregates.VarianceShortAggregateFactory;
import it.unibz.inf.ontop.query.translation.InsertClauseNormalizer;
import it.unibz.inf.ontop.query.translation.RDF4JQueryTranslator;
import it.unibz.inf.ontop.query.translation.impl.RDF4JTupleExprTranslator;
import it.unibz.inf.ontop.query.translation.impl.RDF4JValueTranslator;
import it.unibz.inf.ontop.substitution.Substitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.CoreUtilsFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.rdf.api.RDF;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.algebra.Modify;
import org.eclipse.rdf4j.query.algebra.UpdateExpr;
import org.eclipse.rdf4j.query.impl.SimpleDataset;
import org.eclipse.rdf4j.query.parser.ParsedQuery;
import org.eclipse.rdf4j.query.parser.ParsedUpdate;
import org.eclipse.rdf4j.query.parser.sparql.aggregate.CustomAggregateFunctionRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class RDF4JQueryTranslatorImpl
implements RDF4JQueryTranslator {
    private final CoreUtilsFactory coreUtilsFactory;
    private final TermFactory termFactory;
    private final SubstitutionFactory substitutionFactory;
    private final TypeFactory typeFactory;
    private final IntermediateQueryFactory iqFactory;
    private final AtomFactory atomFactory;
    private final RDF rdfFactory;
    private final FunctionSymbolFactory functionSymbolFactory;
    private final InsertClauseNormalizer insertClauseNormalizer;
    private final IQTreeTools iqTreeTools;
    private static final Logger LOGGER = LoggerFactory.getLogger(RDF4JQueryTranslatorImpl.class);
    private static final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();

    @Inject
    public RDF4JQueryTranslatorImpl(CoreUtilsFactory coreUtilsFactory, TermFactory termFactory, SubstitutionFactory substitutionFactory, TypeFactory typeFactory, IntermediateQueryFactory iqFactory, AtomFactory atomFactory, RDF rdfFactory, FunctionSymbolFactory functionSymbolFactory, InsertClauseNormalizer insertClauseNormalizer, IQTreeTools iqTreeTools, OntopKGQuerySettings settings) {
        this.coreUtilsFactory = coreUtilsFactory;
        this.termFactory = termFactory;
        this.substitutionFactory = substitutionFactory;
        this.typeFactory = typeFactory;
        this.iqFactory = iqFactory;
        this.atomFactory = atomFactory;
        this.rdfFactory = rdfFactory;
        this.functionSymbolFactory = functionSymbolFactory;
        this.insertClauseNormalizer = insertClauseNormalizer;
        this.iqTreeTools = iqTreeTools;
        if (settings.isCustomSPARQLFunctionRegistrationEnabled()) {
            CustomAggregateFunctionRegistry registry = CustomAggregateFunctionRegistry.getInstance();
            registry.add((Object)new VarianceSampAggregateFactory());
            registry.add((Object)new VariancePopAggregateFactory());
            registry.add((Object)new VarianceShortAggregateFactory());
            registry.add((Object)new StdevSampAggregateFactory());
            registry.add((Object)new StdevPopAggregateFactory());
            registry.add((Object)new StdevShortAggregateFactory());
        }
    }

    @Override
    public IQ translateQuery(ParsedQuery pq, BindingSet bindings) throws OntopInvalidKGQueryException, OntopUnsupportedKGQueryException {
        if (IS_DEBUG_ENABLED) {
            LOGGER.debug("Parsed query:\n{}", (Object)pq);
        }
        ImmutableMap<Variable, GroundTerm> externalBindings = this.convertExternalBindings(bindings);
        IQTree tree = this.getTranslator(externalBindings, pq.getDataset(), true).getTree(pq.getTupleExpr());
        ImmutableSet vars = tree.getVariables();
        ImmutableList projectedVars = (ImmutableList)pq.getTupleExpr().getBindingNames().stream().map(arg_0 -> ((TermFactory)this.termFactory).getVariable(arg_0)).filter(arg_0 -> ((ImmutableSet)vars).contains(arg_0)).collect(ImmutableCollectors.toList());
        if (IS_DEBUG_ENABLED) {
            LOGGER.debug("IQTree (before normalization):\n{}", (Object)tree);
        }
        return this.iqFactory.createIQ(this.atomFactory.getDistinctVariableOnlyDataAtom(this.atomFactory.getRDFAnswerPredicate(projectedVars.size()), projectedVars), tree).normalizeForOptimization();
    }

    protected ImmutableMap<Variable, GroundTerm> convertExternalBindings(BindingSet bindings) {
        RDF4JValueTranslator translator = this.getValueTranslator();
        return (ImmutableMap)bindings.getBindingNames().stream().collect(ImmutableCollectors.toMap(arg_0 -> ((TermFactory)this.termFactory).getVariable(arg_0), n -> translator.getTermForLiteralOrIri(bindings.getValue(n))));
    }

    @Override
    public IQ translateAskQuery(ParsedQuery pq, BindingSet bindings) throws OntopUnsupportedKGQueryException, OntopInvalidKGQueryException {
        if (IS_DEBUG_ENABLED) {
            LOGGER.debug("Parsed query:\n{}", (Object)pq);
        }
        ImmutableMap<Variable, GroundTerm> externalBindings = this.convertExternalBindings(bindings);
        IQTree tree = this.getTranslator(externalBindings, pq.getDataset(), true).getTree(pq.getTupleExpr());
        if (IS_DEBUG_ENABLED) {
            LOGGER.debug("IQTree (before normalization):\n{}", (Object)tree);
        }
        return this.iqFactory.createIQ(this.atomFactory.getDistinctVariableOnlyDataAtom(this.atomFactory.getRDFAnswerPredicate(0), ImmutableList.of()), this.projectOutAllVars(tree)).normalizeForOptimization();
    }

    @Override
    public ImmutableSet<IQ> translateInsertOperation(ParsedUpdate parsedUpdate) throws OntopUnsupportedKGQueryException, OntopInvalidKGQueryException {
        ImmutableSet.Builder iqsBuilder = ImmutableSet.builder();
        Map datasetMapping = parsedUpdate.getDatasetMapping();
        for (UpdateExpr expr : parsedUpdate.getUpdateExprs()) {
            if (expr instanceof Modify) {
                iqsBuilder.addAll(this.translateInsertExpression((Modify)expr, (Dataset)datasetMapping.get(expr)));
                continue;
            }
            throw new OntopUnsupportedKGQueryException("Unsupported update: " + expr);
        }
        return iqsBuilder.build();
    }

    protected ImmutableSet<IQ> translateInsertExpression(Modify expression, @Nullable Dataset dataset) throws OntopUnsupportedKGQueryException, OntopInvalidKGQueryException {
        SimpleDataset insertDataset;
        TrueNode whereTree;
        if (expression.getDeleteExpr() != null) {
            throw new OntopUnsupportedKGQueryException("DELETE clauses are not supported");
        }
        if (expression.getInsertExpr() == null) {
            throw new OntopInvalidKGQueryException("Was expecting an INSERT clause");
        }
        Object object = whereTree = expression.getWhereExpr() == null ? this.iqFactory.createTrueNode() : this.getTranslator((ImmutableMap<Variable, GroundTerm>)ImmutableMap.of(), dataset, true).getTree(expression.getWhereExpr());
        if (dataset != null) {
            SimpleDataset newDataset = new SimpleDataset();
            IRI defaultInsertGraph = dataset.getDefaultInsertGraph();
            if (defaultInsertGraph != null) {
                newDataset.addDefaultGraph(defaultInsertGraph);
            }
            insertDataset = newDataset;
        } else {
            insertDataset = null;
        }
        IQTree insertTree = this.getTranslator((ImmutableMap<Variable, GroundTerm>)ImmutableMap.of(), (Dataset)insertDataset, false).getTree(expression.getInsertExpr());
        ImmutableSet.Builder iqsBuilder = ImmutableSet.builder();
        ImmutableSet<IntensionalDataNode> dataNodes = this.extractIntensionalDataNodesFromHead(insertTree);
        InsertClauseNormalizer.Result normalization = this.insertClauseNormalizer.normalize(dataNodes, (IQTree)whereTree);
        IQTree normalizedSubTree = normalization.getConstructionNode().map(arg_0 -> this.lambda$translateInsertExpression$1((IQTree)whereTree, arg_0)).orElse((IQTree)whereTree);
        if (normalizedSubTree.isDeclaredAsEmpty()) {
            return ImmutableSet.of();
        }
        for (IntensionalDataNode dataNode : dataNodes) {
            iqsBuilder.add((Object)this.createInsertIQ(dataNode, normalization.getBNodeVariableMap(), normalizedSubTree));
        }
        return iqsBuilder.build();
    }

    private ImmutableSet<IntensionalDataNode> extractIntensionalDataNodesFromHead(IQTree insertTree) throws OntopInvalidKGQueryException {
        if (insertTree instanceof IntensionalDataNode) {
            return ImmutableSet.of((Object)((IntensionalDataNode)insertTree));
        }
        QueryNode rootNode = insertTree.getRootNode();
        if (rootNode instanceof InnerJoinNode && !((InnerJoinNode)rootNode).getOptionalFilterCondition().isPresent()) {
            ImmutableSet.Builder setBuilder = ImmutableSet.builder();
            for (IQTree child : insertTree.getChildren()) {
                setBuilder.addAll(this.extractIntensionalDataNodesFromHead(child));
            }
            return setBuilder.build();
        }
        throw new OntopInvalidKGQueryException("Invalid INSERT clause");
    }

    private IQ createInsertIQ(IntensionalDataNode dataNode, ImmutableMap<BNode, Variable> bnodeVariableMap, IQTree subTree) {
        DataAtom dataNodeAtom = dataNode.getProjectionAtom();
        VariableGenerator variableGenerator = this.coreUtilsFactory.createVariableGenerator((Collection)Sets.union((Set)subTree.getKnownVariables(), (Set)dataNode.getKnownVariables()));
        ImmutableList normalizedArguments = (ImmutableList)dataNodeAtom.getArguments().stream().map(a -> a instanceof BNode ? (VariableOrGroundTerm)Optional.ofNullable((Variable)bnodeVariableMap.get(a)).orElseThrow(() -> new MinorOntopInternalBugException("BNodes from the INSERT clause should be replaced internally by variables generated out of templates")) : a).collect(ImmutableCollectors.toList());
        ImmutableMap map = (ImmutableMap)normalizedArguments.stream().map(t -> Maps.immutableEntry((Object)(t instanceof Variable ? (Variable)t : variableGenerator.generateNewVariable()), (Object)t)).distinct().collect(ImmutableCollectors.toMap());
        DistinctVariableOnlyDataAtom projectionAtom = this.atomFactory.getDistinctVariableOnlyDataAtom(dataNodeAtom.getPredicate(), ImmutableList.copyOf((Collection)map.keySet()));
        ConstructionNode constructionNode = this.iqFactory.createConstructionNode(map.keySet(), (Substitution)map.entrySet().stream().collect(this.substitutionFactory.toSubstitutionSkippingIdentityEntries()));
        IQ newIQ = this.iqFactory.createIQ(projectionAtom, (IQTree)this.iqFactory.createUnaryIQTree((UnaryOperatorNode)constructionNode, subTree));
        return newIQ.normalizeForOptimization();
    }

    private IQTree projectOutAllVars(IQTree tree) {
        if (tree.getRootNode() instanceof QueryModifierNode) {
            return this.iqFactory.createUnaryIQTree((UnaryOperatorNode)tree.getRootNode(), this.projectOutAllVars(((UnaryIQTree)tree).getChild()));
        }
        return this.iqFactory.createUnaryIQTree((UnaryOperatorNode)this.iqFactory.createConstructionNode(ImmutableSet.of()), tree);
    }

    private RDF4JTupleExprTranslator getTranslator(ImmutableMap<Variable, GroundTerm> externalBindings, @Nullable Dataset dataset, boolean treatBNodeAsVariable) {
        return new RDF4JTupleExprTranslator(externalBindings, dataset, treatBNodeAsVariable, this.coreUtilsFactory, this.substitutionFactory, this.iqFactory, this.atomFactory, this.termFactory, this.functionSymbolFactory, this.rdfFactory, this.typeFactory, this.iqTreeTools);
    }

    private RDF4JValueTranslator getValueTranslator() {
        return new RDF4JValueTranslator(this.termFactory, this.rdfFactory, this.typeFactory);
    }

    private /* synthetic */ IQTree lambda$translateInsertExpression$1(IQTree whereTree, ConstructionNode c) {
        return this.iqFactory.createUnaryIQTree((UnaryOperatorNode)c, whereTree);
    }
}

