/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.query.impl;

import com.google.inject.Inject;
import it.unibz.inf.ontop.exception.OntopInvalidKGQueryException;
import it.unibz.inf.ontop.exception.OntopUnsupportedKGQueryException;
import it.unibz.inf.ontop.query.AskQuery;
import it.unibz.inf.ontop.query.ConstructQuery;
import it.unibz.inf.ontop.query.DescribeQuery;
import it.unibz.inf.ontop.query.GraphSPARQLQuery;
import it.unibz.inf.ontop.query.InsertOperation;
import it.unibz.inf.ontop.query.KGQueryFactory;
import it.unibz.inf.ontop.query.RDF4JQueryFactory;
import it.unibz.inf.ontop.query.SPARQLQuery;
import it.unibz.inf.ontop.query.SelectQuery;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.impl.MapBindingSet;
import org.eclipse.rdf4j.query.parser.ParsedBooleanQuery;
import org.eclipse.rdf4j.query.parser.ParsedDescribeQuery;
import org.eclipse.rdf4j.query.parser.ParsedGraphQuery;
import org.eclipse.rdf4j.query.parser.ParsedQuery;
import org.eclipse.rdf4j.query.parser.ParsedTupleQuery;
import org.eclipse.rdf4j.query.parser.ParsedUpdate;
import org.eclipse.rdf4j.query.parser.QueryParserUtil;

public class KGQueryFactoryImpl
implements KGQueryFactory {
    private final RDF4JQueryFactory rdf4jFactory;

    @Inject
    private KGQueryFactoryImpl(RDF4JQueryFactory rdf4jFactory) {
        this.rdf4jFactory = rdf4jFactory;
    }

    @Override
    public SelectQuery createSelectQuery(String queryString) throws OntopInvalidKGQueryException {
        ParsedQuery parsedQuery = KGQueryFactoryImpl.parseQueryString(queryString);
        if (parsedQuery instanceof ParsedTupleQuery) {
            return this.rdf4jFactory.createSelectQuery(queryString, (ParsedTupleQuery)parsedQuery, (BindingSet)new MapBindingSet());
        }
        throw new OntopInvalidKGQueryException("Not a valid SELECT query: " + queryString);
    }

    @Override
    public AskQuery createAskQuery(String queryString) throws OntopInvalidKGQueryException {
        ParsedQuery parsedQuery = KGQueryFactoryImpl.parseQueryString(queryString);
        if (parsedQuery instanceof ParsedBooleanQuery) {
            return this.rdf4jFactory.createAskQuery(queryString, (ParsedBooleanQuery)parsedQuery, (BindingSet)new MapBindingSet());
        }
        throw new OntopInvalidKGQueryException("Not a valid ASK query: " + queryString);
    }

    @Override
    public ConstructQuery createConstructQuery(String queryString) throws OntopInvalidKGQueryException {
        ParsedQuery parsedQuery = KGQueryFactoryImpl.parseQueryString(queryString);
        if (parsedQuery instanceof ParsedGraphQuery && !(parsedQuery instanceof ParsedDescribeQuery)) {
            return this.rdf4jFactory.createConstructQuery(queryString, (ParsedGraphQuery)parsedQuery, (BindingSet)new MapBindingSet());
        }
        throw new OntopInvalidKGQueryException("Not a valid CONSTRUCT query: " + queryString);
    }

    @Override
    public DescribeQuery createDescribeQuery(String queryString) throws OntopInvalidKGQueryException {
        ParsedQuery parsedQuery = KGQueryFactoryImpl.parseQueryString(queryString);
        if (parsedQuery instanceof ParsedDescribeQuery) {
            return this.rdf4jFactory.createDescribeQuery(queryString, (ParsedDescribeQuery)parsedQuery, (BindingSet)new MapBindingSet());
        }
        throw new OntopInvalidKGQueryException("Not a valid DESCRIBE query: " + queryString);
    }

    @Override
    public InsertOperation createInsertQuery(String operationString) throws OntopInvalidKGQueryException {
        ParsedUpdate parsedUpdate = KGQueryFactoryImpl.parseUpdateString(operationString);
        return this.rdf4jFactory.createInsertOperation(operationString, parsedUpdate);
    }

    @Override
    public SPARQLQuery<?> createSPARQLQuery(String queryString) throws OntopInvalidKGQueryException, OntopUnsupportedKGQueryException {
        ParsedQuery parsedQuery = KGQueryFactoryImpl.parseQueryString(queryString);
        if (parsedQuery instanceof ParsedTupleQuery) {
            return this.rdf4jFactory.createSelectQuery(queryString, (ParsedTupleQuery)parsedQuery, (BindingSet)new MapBindingSet());
        }
        if (parsedQuery instanceof ParsedBooleanQuery) {
            return this.rdf4jFactory.createAskQuery(queryString, (ParsedBooleanQuery)parsedQuery, (BindingSet)new MapBindingSet());
        }
        if (parsedQuery instanceof ParsedDescribeQuery) {
            return this.rdf4jFactory.createDescribeQuery(queryString, (ParsedDescribeQuery)parsedQuery, (BindingSet)new MapBindingSet());
        }
        if (parsedQuery instanceof ParsedGraphQuery) {
            return this.rdf4jFactory.createConstructQuery(queryString, (ParsedGraphQuery)parsedQuery, (BindingSet)new MapBindingSet());
        }
        throw new OntopUnsupportedKGQueryException("Unsupported query: " + queryString);
    }

    @Override
    public GraphSPARQLQuery createGraphQuery(String queryString) throws OntopInvalidKGQueryException, OntopUnsupportedKGQueryException {
        ParsedQuery parsedQuery = KGQueryFactoryImpl.parseQueryString(queryString);
        if (parsedQuery instanceof ParsedDescribeQuery) {
            return this.rdf4jFactory.createDescribeQuery(queryString, (ParsedDescribeQuery)parsedQuery, (BindingSet)new MapBindingSet());
        }
        if (parsedQuery instanceof ParsedGraphQuery) {
            return this.rdf4jFactory.createConstructQuery(queryString, (ParsedGraphQuery)parsedQuery, (BindingSet)new MapBindingSet());
        }
        throw new OntopUnsupportedKGQueryException("Unsupported query: " + queryString);
    }

    private static ParsedQuery parseQueryString(String queryString) throws OntopInvalidKGQueryException {
        try {
            return QueryParserUtil.parseQuery((QueryLanguage)QueryLanguage.SPARQL, (String)queryString, null);
        }
        catch (MalformedQueryException e) {
            throw new OntopInvalidKGQueryException((Exception)((Object)e));
        }
    }

    private static ParsedUpdate parseUpdateString(String updateString) throws OntopInvalidKGQueryException {
        try {
            return QueryParserUtil.parseUpdate((QueryLanguage)QueryLanguage.SPARQL, (String)updateString, null);
        }
        catch (MalformedQueryException e) {
            throw new OntopInvalidKGQueryException((Exception)((Object)e));
        }
    }
}

