/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.openai;

import dev.langchain4j.data.image.Image;
import dev.langchain4j.http.client.HttpClientBuilder;
import dev.langchain4j.internal.RetryUtils;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.image.ImageModel;
import dev.langchain4j.model.openai.OpenAiImageModelName;
import dev.langchain4j.model.openai.internal.OpenAiClient;
import dev.langchain4j.model.openai.internal.image.GenerateImagesRequest;
import dev.langchain4j.model.openai.internal.image.GenerateImagesResponse;
import dev.langchain4j.model.openai.internal.image.ImageData;
import dev.langchain4j.model.openai.spi.OpenAiImageModelBuilderFactory;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.spi.ServiceHelper;
import java.time.Duration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;

public class OpenAiImageModel
implements ImageModel {
    private final String modelName;
    private final String size;
    private final String quality;
    private final String style;
    private final String user;
    private final String responseFormat;
    private final OpenAiClient client;
    private final Integer maxRetries;

    public OpenAiImageModel(OpenAiImageModelBuilder builder) {
        Object cBuilder = ((OpenAiClient.Builder)((OpenAiClient.Builder)((OpenAiClient.Builder)((OpenAiClient.Builder)((OpenAiClient.Builder)((OpenAiClient.Builder)((OpenAiClient.Builder)((OpenAiClient.Builder)((OpenAiClient.Builder)((OpenAiClient.Builder)((OpenAiClient.Builder)((OpenAiClient.Builder)OpenAiClient.builder().httpClientBuilder(builder.httpClientBuilder)).baseUrl(Utils.getOrDefault(builder.baseUrl, "https://api.openai.com/v1"))).apiKey(builder.apiKey)).organizationId(builder.organizationId)).projectId(builder.projectId)).connectTimeout(Utils.getOrDefault(builder.timeout, Duration.ofSeconds(15L)))).readTimeout(Utils.getOrDefault(builder.timeout, Duration.ofSeconds(60L)))).logRequests(Utils.getOrDefault(builder.logRequests, false))).logResponses(Utils.getOrDefault(builder.logResponses, false))).logger(builder.logger)).userAgent("langchain4j-openai")).customHeaders(builder.customHeaders)).customQueryParams(builder.customQueryParams);
        this.client = ((OpenAiClient.Builder)cBuilder).build();
        this.maxRetries = Utils.getOrDefault(builder.maxRetries, 2);
        this.modelName = builder.modelName;
        this.size = builder.size;
        this.quality = builder.quality;
        this.style = builder.style;
        this.user = builder.user;
        this.responseFormat = builder.responseFormat;
    }

    public String modelName() {
        return this.modelName;
    }

    @Override
    public Response<Image> generate(String prompt) {
        GenerateImagesRequest request = this.requestBuilder(prompt).build();
        GenerateImagesResponse response = (GenerateImagesResponse)RetryUtils.withRetryMappingExceptions(() -> this.client.imagesGeneration(request), this.maxRetries).execute();
        return Response.from(OpenAiImageModel.fromImageData(response.data().get(0)));
    }

    @Override
    public Response<List<Image>> generate(String prompt, int n) {
        GenerateImagesRequest request = this.requestBuilder(prompt).n(n).build();
        GenerateImagesResponse response = (GenerateImagesResponse)RetryUtils.withRetryMappingExceptions(() -> this.client.imagesGeneration(request), this.maxRetries).execute();
        return Response.from(response.data().stream().map(OpenAiImageModel::fromImageData).collect(Collectors.toList()));
    }

    public static OpenAiImageModelBuilder builder() {
        Iterator<OpenAiImageModelBuilderFactory> iterator = ServiceHelper.loadFactories(OpenAiImageModelBuilderFactory.class).iterator();
        if (iterator.hasNext()) {
            OpenAiImageModelBuilderFactory factory = iterator.next();
            return (OpenAiImageModelBuilder)factory.get();
        }
        return new OpenAiImageModelBuilder();
    }

    private static Image fromImageData(ImageData data) {
        return Image.builder().url(data.url()).base64Data(data.b64Json()).revisedPrompt(data.revisedPrompt()).build();
    }

    private GenerateImagesRequest.Builder requestBuilder(String prompt) {
        return GenerateImagesRequest.builder().model(this.modelName).prompt(prompt).size(this.size).quality(this.quality).style(this.style).user(this.user).responseFormat(this.responseFormat);
    }

    public static class OpenAiImageModelBuilder {
        private HttpClientBuilder httpClientBuilder;
        private String baseUrl;
        private String apiKey;
        private String organizationId;
        private String projectId;
        private String modelName;
        private String size;
        private String quality;
        private String style;
        private String user;
        private String responseFormat;
        private Duration timeout;
        private Integer maxRetries;
        private Boolean logRequests;
        private Boolean logResponses;
        private Logger logger;
        private Map<String, String> customHeaders;
        private Map<String, String> customQueryParams;

        public OpenAiImageModelBuilder httpClientBuilder(HttpClientBuilder httpClientBuilder) {
            this.httpClientBuilder = httpClientBuilder;
            return this;
        }

        public OpenAiImageModelBuilder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public OpenAiImageModelBuilder modelName(OpenAiImageModelName modelName) {
            this.modelName = modelName.toString();
            return this;
        }

        public OpenAiImageModelBuilder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public OpenAiImageModelBuilder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public OpenAiImageModelBuilder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public OpenAiImageModelBuilder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public OpenAiImageModelBuilder size(String size) {
            this.size = size;
            return this;
        }

        public OpenAiImageModelBuilder quality(String quality) {
            this.quality = quality;
            return this;
        }

        public OpenAiImageModelBuilder style(String style) {
            this.style = style;
            return this;
        }

        public OpenAiImageModelBuilder user(String user) {
            this.user = user;
            return this;
        }

        public OpenAiImageModelBuilder responseFormat(String responseFormat) {
            this.responseFormat = responseFormat;
            return this;
        }

        public OpenAiImageModelBuilder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public OpenAiImageModelBuilder maxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public OpenAiImageModelBuilder logRequests(Boolean logRequests) {
            this.logRequests = logRequests;
            return this;
        }

        public OpenAiImageModelBuilder logResponses(Boolean logResponses) {
            this.logResponses = logResponses;
            return this;
        }

        public OpenAiImageModelBuilder logger(Logger logger) {
            this.logger = logger;
            return this;
        }

        public OpenAiImageModelBuilder customHeaders(Map<String, String> customHeaders) {
            this.customHeaders = customHeaders;
            return this;
        }

        public OpenAiImageModelBuilder customQueryParams(Map<String, String> customQueryParams) {
            this.customQueryParams = customQueryParams;
            return this;
        }

        public OpenAiImageModel build() {
            return new OpenAiImageModel(this);
        }
    }
}

