/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.http.client.log;

import dev.langchain4j.Internal;
import dev.langchain4j.exception.HttpException;
import dev.langchain4j.http.client.HttpClient;
import dev.langchain4j.http.client.HttpRequest;
import dev.langchain4j.http.client.SuccessfulHttpResponse;
import dev.langchain4j.http.client.log.HttpRequestLogger;
import dev.langchain4j.http.client.log.HttpResponseLogger;
import dev.langchain4j.http.client.sse.ServerSentEvent;
import dev.langchain4j.http.client.sse.ServerSentEventContext;
import dev.langchain4j.http.client.sse.ServerSentEventListener;
import dev.langchain4j.http.client.sse.ServerSentEventParser;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class LoggingHttpClient
implements HttpClient {
    private static final Logger DEFAULT_LOG = LoggerFactory.getLogger(LoggingHttpClient.class);
    private final HttpClient delegateHttpClient;
    private final boolean logRequests;
    private final boolean logResponses;
    private final Logger log;

    public LoggingHttpClient(HttpClient delegateHttpClient, Boolean logRequests, Boolean logResponses) {
        this.delegateHttpClient = ValidationUtils.ensureNotNull(delegateHttpClient, "delegateHttpClient");
        this.logRequests = Utils.getOrDefault(logRequests, false);
        this.logResponses = Utils.getOrDefault(logResponses, false);
        this.log = DEFAULT_LOG;
    }

    public LoggingHttpClient(HttpClient delegateHttpClient, Boolean logRequests, Boolean logResponses, Logger logger) {
        this.delegateHttpClient = ValidationUtils.ensureNotNull(delegateHttpClient, "delegateHttpClient");
        this.logRequests = Utils.getOrDefault(logRequests, false);
        this.logResponses = Utils.getOrDefault(logResponses, false);
        this.log = Utils.getOrDefault(logger, DEFAULT_LOG);
    }

    @Override
    public SuccessfulHttpResponse execute(HttpRequest request) throws HttpException {
        if (this.logRequests) {
            HttpRequestLogger.log(this.log, request);
        }
        SuccessfulHttpResponse response = this.delegateHttpClient.execute(request);
        if (this.logResponses) {
            HttpResponseLogger.log(this.log, response);
        }
        return response;
    }

    @Override
    public void execute(HttpRequest request, final ServerSentEventListener delegateListener) {
        if (this.logRequests) {
            HttpRequestLogger.log(this.log, request);
        }
        this.delegateHttpClient.execute(request, new ServerSentEventListener(){
            final /* synthetic */ LoggingHttpClient this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void onOpen(SuccessfulHttpResponse response) {
                if (this.this$0.logResponses) {
                    HttpResponseLogger.log(this.this$0.log, response);
                }
                delegateListener.onOpen(response);
            }

            @Override
            public void onEvent(ServerSentEvent event) {
                if (this.this$0.logResponses) {
                    this.this$0.log.debug("{}", (Object)event);
                }
                delegateListener.onEvent(event);
            }

            @Override
            public void onEvent(ServerSentEvent event, ServerSentEventContext context) {
                if (this.this$0.logResponses) {
                    this.this$0.log.debug("{}", (Object)event);
                }
                delegateListener.onEvent(event, context);
            }

            @Override
            public void onError(Throwable throwable) {
                delegateListener.onError(throwable);
            }

            @Override
            public void onClose() {
                delegateListener.onClose();
            }
        });
    }

    @Override
    public void execute(HttpRequest request, ServerSentEventParser parser, final ServerSentEventListener delegateListener) {
        if (this.logRequests) {
            HttpRequestLogger.log(this.log, request);
        }
        this.delegateHttpClient.execute(request, parser, new ServerSentEventListener(){
            final /* synthetic */ LoggingHttpClient this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void onOpen(SuccessfulHttpResponse response) {
                if (this.this$0.logResponses) {
                    HttpResponseLogger.log(this.this$0.log, response);
                }
                delegateListener.onOpen(response);
            }

            @Override
            public void onEvent(ServerSentEvent event) {
                if (this.this$0.logResponses) {
                    this.this$0.log.debug("{}", (Object)event);
                }
                delegateListener.onEvent(event);
            }

            @Override
            public void onEvent(ServerSentEvent event, ServerSentEventContext context) {
                if (this.this$0.logResponses) {
                    this.this$0.log.debug("{}", (Object)event);
                }
                delegateListener.onEvent(event, context);
            }

            @Override
            public void onError(Throwable throwable) {
                delegateListener.onError(throwable);
            }

            @Override
            public void onClose() {
                delegateListener.onClose();
            }
        });
    }
}

