/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.embeddings.security;

import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.HexFormat;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class AuthClientInterceptor
implements ClientInterceptor {
    private static final String TIMESTAMP_HEADER = "x-timestamp";
    private static final String SIGNATURE_HEADER = "x-signature";
    private static final String ALGORITHM = "HmacSHA256";
    private final String secret;

    public AuthClientInterceptor(String secret) {
        this.secret = secret;
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(next.newCall(method, callOptions)){

            public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                String timestamp = String.valueOf(Instant.now().getEpochSecond());
                String signature = AuthClientInterceptor.this.encode(AuthClientInterceptor.this.secret, timestamp);
                headers.put(Metadata.Key.of((String)AuthClientInterceptor.TIMESTAMP_HEADER, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)timestamp);
                headers.put(Metadata.Key.of((String)AuthClientInterceptor.SIGNATURE_HEADER, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)signature);
                super.start(responseListener, headers);
            }
        };
    }

    private String encode(String secret, String message) {
        try {
            Mac mac = Mac.getInstance(ALGORITHM);
            mac.init(new SecretKeySpec(secret.getBytes(StandardCharsets.UTF_8), ALGORITHM));
            byte[] result = mac.doFinal(message.getBytes(StandardCharsets.UTF_8));
            return HexFormat.of().formatHex(result);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to encode the authorization secret", e);
        }
    }
}

