/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.soaas.util;

import com.ontotext.soaas.util.RetryExecutionException;
import java.util.function.Consumer;

public class RetryingOperation
implements Runnable {
    private final Runnable delegate;
    private final Consumer<RuntimeException> onException;
    private final long initialDelay;
    private final long delayBeforeRetry;
    private final int retries;

    public RetryingOperation(Runnable delegate, long initialDelay, long delayBeforeRetry, int retries, Consumer<RuntimeException> onException) {
        this.delegate = delegate;
        this.onException = onException;
        this.initialDelay = Math.max(initialDelay, 0L);
        this.delayBeforeRetry = Math.max(delayBeforeRetry, 0L);
        this.retries = retries;
    }

    @Override
    public void run() {
        this.executeWithRetriesInternal();
    }

    public long getInitialDelay() {
        return this.initialDelay;
    }

    public long getDelayBeforeRetry() {
        return this.delayBeforeRetry;
    }

    public int getRetries() {
        return this.retries;
    }

    private void executeWithRetriesInternal() {
        this.waitFor(this.getInitialDelay());
        int currentRetries = this.getRetries();
        while (this.tryExecutingTask()) {
            if (--currentRetries == 0 || currentRetries == -1) {
                return;
            }
            this.waitFor(this.getDelayBeforeRetry());
        }
    }

    private boolean tryExecutingTask() {
        try {
            this.delegate.run();
        }
        catch (RetryExecutionException ex) {
            return !Thread.currentThread().isInterrupted();
        }
        catch (RuntimeException re) {
            try {
                this.onException.accept(re);
            }
            catch (RetryExecutionException ex) {
                return !Thread.currentThread().isInterrupted();
            }
        }
        return false;
    }

    private void waitFor(long delay) {
        if (delay > 0L) {
            try {
                Thread.sleep(delay);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

