/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.soaas.plugin;

import com.google.common.annotations.VisibleForTesting;
import com.ontotext.soaas.plugin.Injection;
import com.ontotext.soaas.plugin.InjectionValue;
import com.ontotext.soaas.plugin.Injector;
import com.ontotext.soaas.plugin.NoSuchInjectionException;
import com.ontotext.soaas.plugin.Order;
import com.ontotext.soaas.plugin.Plugin;
import com.ontotext.soaas.plugin.PluginLoader;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginsManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static Set<Plugin> registeredPlugins = ConcurrentHashMap.newKeySet();
    private static Set<InjectionValue> pluginConfigurations = ConcurrentHashMap.newKeySet();
    private static Set<Injector> customInjections = ConcurrentHashMap.newKeySet();
    private static BeanResolver beanResolver;
    private static Set<PluginFilter> pluginFilters;

    private PluginsManager() {
    }

    public static void addConfig(Object injectable) {
        pluginConfigurations.add(new InjectionValue(injectable));
    }

    public static <E> void addConfig(Class<E> injectionType, Supplier<E> injectable) {
        pluginConfigurations.add(new InjectionValue(injectionType, injectable));
    }

    public static void addConfig(InjectionValue injection) {
        pluginConfigurations.add(Objects.requireNonNull(injection));
    }

    public static void addConfig(Injector injection) {
        customInjections.add(Objects.requireNonNull(injection));
    }

    public static <T> PluginLoader<T> loader(Class<T> pluginType) {
        return new PluginLoader<T>(pluginType);
    }

    public static <T> PluginLoader<T> loader(Class<T> pluginType, ClassLoader classLoader) {
        return new PluginLoader<T>(pluginType, classLoader);
    }

    public static <T> List<T> loadPlugins(Class<T> pluginType) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return PluginsManager.loadPlugins(pluginType, Collections.emptySet(), Collections.emptySet(), classLoader);
    }

    public static <T> List<T> loadPlugins(Class<T> pluginType, ClassLoader classLoader) {
        return PluginsManager.loadPlugins(pluginType, Collections.emptySet(), Collections.emptySet(), classLoader);
    }

    public static <T> List<T> loadPlugins(Class<T> pluginType, Set<Plugin> additionalPlugins, Set<InjectionValue> additionalValues, ClassLoader classLoader) {
        Objects.requireNonNull(pluginType, "The extension point cannot be null");
        LinkedHashSet<Plugin> plugins = new LinkedHashSet<Plugin>(PluginsManager.loadExtensions(pluginType, classLoader));
        PluginsManager.loadBeans(pluginType, plugins);
        PluginsManager.loadRuntimePlugins(pluginType, plugins, registeredPlugins);
        PluginsManager.loadRuntimePlugins(pluginType, plugins, additionalPlugins);
        return plugins.stream().map(PluginsManager.configurePlugin(additionalValues)).filter(instance -> PluginsManager.isPluginApplicable(pluginType, instance)).map(pluginType::cast).sorted(Order.Comparator.sortByOrder()).collect(Collectors.toList());
    }

    private static Function<Plugin, Object> configurePlugin(Set<InjectionValue> additionalValues) {
        return plugin -> {
            Object pluginInstance = plugin.get();
            HashMap injectedValues = new HashMap();
            List<Injection> injectors = plugin.injectors();
            Consumer<InjectionValue> injectionValueConsumer = injectionValue -> {
                Object valueToInject = null;
                for (Injection injection : injectors) {
                    Class<?> argumentType = injection.argumentType();
                    if (!argumentType.isAssignableFrom(injectionValue.getType())) continue;
                    if (valueToInject == null) {
                        valueToInject = injectedValues.computeIfAbsent(argumentType, key -> injectionValue.getValue());
                    }
                    injection.inject(pluginInstance, valueToInject);
                }
            };
            additionalValues.forEach(injectionValueConsumer);
            pluginConfigurations.forEach(injectionValueConsumer);
            customInjections.forEach(injection -> injection.injectInto(pluginInstance));
            PluginsManager.injectBeans(pluginInstance, injectors, injectedValues);
            return pluginInstance;
        };
    }

    private static void injectBeans(Object pluginInstance, List<Injection> injectors, Map<Class<?>, Object> injectedValues) {
        if (beanResolver == null) {
            if (injectors.size() > injectedValues.size()) {
                LOGGER.warn("There are missing injection values for {}", pluginInstance.getClass());
            }
            return;
        }
        for (Injection injection : injectors) {
            Class<?> argumentType = injection.argumentType();
            Object bean = injectedValues.computeIfAbsent(argumentType, beanType -> ((Collection)Objects.requireNonNullElse(beanResolver.resolveBeans(beanType), Collections.emptyList())).stream().findFirst().orElse(null));
            if (bean == null && injection.required()) {
                throw PluginsManager.getNoSuchBeanException(argumentType);
            }
            injection.inject(pluginInstance, bean);
        }
    }

    private static NoSuchInjectionException getNoSuchBeanException(Class<?> beanType) {
        return new NoSuchInjectionException("Could not resolve bean of type " + String.valueOf(beanType));
    }

    private static <T> void loadRuntimePlugins(Class<T> pluginType, Collection<Plugin> plugins, Set<Plugin> registeredPlugins) {
        for (Plugin plugin : registeredPlugins) {
            if (!pluginType.isAssignableFrom(plugin.type())) continue;
            plugins.add(plugin);
        }
    }

    private static <T> boolean isPluginApplicable(Class<T> pluginType, Object plugin) {
        if (pluginFilters.isEmpty()) {
            return pluginType.isInstance(plugin);
        }
        return pluginType.isInstance(plugin) && pluginFilters.stream().allMatch(filter -> filter.getPluginState(pluginType, plugin) != PluginState.DISABLED);
    }

    private static <T> void loadBeans(Class<T> pluginType, Collection<Plugin> plugins) {
        Collection<T> beans;
        if (beanResolver != null && (beans = beanResolver.resolveBeans(pluginType)) != null) {
            for (T bean : beans) {
                plugins.add(Plugin.from(bean));
            }
        }
    }

    private static <T> List<Plugin> loadExtensions(Class<T> extensionClass, ClassLoader classLoader) {
        ServiceLoader<T> serviceLoader = ServiceLoader.load(extensionClass, classLoader);
        ArrayList<Plugin> extensions = new ArrayList<Plugin>();
        for (T extension : serviceLoader) {
            extensions.add(Plugin.from(extension));
        }
        return extensions;
    }

    public static BeanResolver getBeanResolver() {
        return beanResolver;
    }

    public static void setBeanResolver(BeanResolver beanResolver) {
        PluginsManager.beanResolver = beanResolver;
    }

    public static Set<PluginFilter> getPluginFilter() {
        if (pluginFilters.isEmpty()) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(pluginFilters);
    }

    public static void addPluginFilter(PluginFilter pluginFilter) {
        if (pluginFilter != null) {
            pluginFilters.add(pluginFilter);
        }
    }

    public static void removePluginFilter(PluginFilter pluginFilter) {
        if (pluginFilter != null) {
            pluginFilters.remove(pluginFilter);
        }
    }

    public static void registerPlugin(Object pluginInstance) {
        registeredPlugins.add(Plugin.from(pluginInstance));
    }

    public static <E> void registerPlugin(Class<E> pluginEndpoint, Supplier<E> pluginInstanceSupplier) {
        registeredPlugins.add(Plugin.fromSupplier(pluginEndpoint, pluginInstanceSupplier));
    }

    public static void unregisterPlugin(Object pluginInstance) {
        registeredPlugins.remove(Plugin.from(pluginInstance));
    }

    public static <E> void unregisterPlugin(Class<E> pluginEndpoint, Supplier<E> pluginInstanceSupplier) {
        registeredPlugins.remove(Plugin.fromSupplier(pluginEndpoint, pluginInstanceSupplier));
    }

    @VisibleForTesting
    public static void reset() {
        registeredPlugins.clear();
        pluginConfigurations.clear();
        customInjections.clear();
        beanResolver = null;
        pluginFilters.clear();
    }

    static {
        pluginFilters = new LinkedHashSet<PluginFilter>();
    }

    @FunctionalInterface
    public static interface BeanResolver
    extends Function<Class<?>, Collection<?>> {
        default public <T> Collection<T> resolveBeans(Class<T> type) {
            return (Collection)this.apply(type);
        }
    }

    @FunctionalInterface
    public static interface PluginFilter {
        public PluginState getPluginState(Class<?> var1, Object var2);
    }

    public static enum PluginState {
        DEFAULT,
        ENABLED,
        DISABLED;

    }
}

