/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.soaas.plugin;

import com.ontotext.soaas.plugin.InjectionValue;
import com.ontotext.soaas.plugin.Injector;
import com.ontotext.soaas.plugin.Plugin;
import com.ontotext.soaas.plugin.PluginsManager;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;

public class PluginLoader<E> {
    private final Class<E> pluginType;
    private final ClassLoader classLoader;
    private Set<InjectionValue> pluginConfigurations = new LinkedHashSet<InjectionValue>();
    private Set<Plugin> registeredPlugins = new LinkedHashSet<Plugin>();
    private static Set<Injector> customInjections = ConcurrentHashMap.newKeySet();

    PluginLoader(Class<E> pluginType) {
        this.pluginType = pluginType;
        this.classLoader = Thread.currentThread().getContextClassLoader();
    }

    public PluginLoader(Class<E> pluginType, ClassLoader classLoader) {
        this.pluginType = pluginType;
        this.classLoader = classLoader;
    }

    public PluginLoader<E> withConfig(Object injectable) {
        this.pluginConfigurations.add(new InjectionValue(injectable));
        return this;
    }

    public <T> PluginLoader<E> withConfig(Class<T> injectionType, Supplier<T> injectable) {
        this.pluginConfigurations.add(new InjectionValue(injectionType, injectable));
        return this;
    }

    public PluginLoader<E> withConfig(InjectionValue injection) {
        this.pluginConfigurations.add(Objects.requireNonNull(injection));
        return this;
    }

    public PluginLoader<E> withConfig(Injector injection) {
        customInjections.add(Objects.requireNonNull(injection));
        return this;
    }

    public PluginLoader<E> withPlugin(Object pluginInstance) {
        Objects.requireNonNull(pluginInstance, "Plugin instance is required!");
        if (pluginInstance instanceof Class) {
            if (!this.pluginType.isAssignableFrom((Class)pluginInstance)) {
                throw new IllegalArgumentException(String.format("Extension class %s is not applicable with extension: %s", pluginInstance, this.pluginType));
            }
        } else if (pluginInstance instanceof Plugin) {
            if (!this.pluginType.isAssignableFrom(((Plugin)pluginInstance).type())) {
                throw new IllegalArgumentException(String.format("Extension instance type %s is not applicable with extension: %s", ((Plugin)pluginInstance).type(), this.pluginType));
            }
        } else if (!this.pluginType.isAssignableFrom(pluginInstance.getClass())) {
            throw new IllegalArgumentException(String.format("Extension instance %s is not applicable with extension: %s", pluginInstance.getClass(), this.pluginType));
        }
        this.registeredPlugins.add(Plugin.from(pluginInstance));
        return this;
    }

    public <S extends E> PluginLoader<E> withPlugin(Class<S> pluginEndpoint, Supplier<S> pluginInstanceSupplier) {
        Objects.requireNonNull(pluginEndpoint, "Extension type is required");
        Objects.requireNonNull(pluginInstanceSupplier, "Extension instance supplier is required");
        this.registeredPlugins.add(Plugin.fromSupplier(pluginEndpoint, pluginInstanceSupplier));
        return this;
    }

    public List<E> load() {
        List<E> plugins = PluginsManager.loadPlugins(this.pluginType, this.registeredPlugins, this.pluginConfigurations, this.classLoader);
        if (!customInjections.isEmpty()) {
            plugins.forEach(plugin -> customInjections.forEach(injection -> injection.injectInto(plugin)));
        }
        return plugins;
    }

    public E loadFirst() {
        List<E> plugins = PluginsManager.loadPlugins(this.pluginType, this.registeredPlugins, this.pluginConfigurations, this.classLoader);
        if (!customInjections.isEmpty()) {
            plugins.forEach(plugin -> customInjections.forEach(injection -> injection.injectInto(plugin)));
        }
        if (plugins.isEmpty()) {
            return null;
        }
        return plugins.get(0);
    }

    public void reset() {
        customInjections.clear();
        this.pluginConfigurations.clear();
    }
}

