/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.soaas.common.sparql;

import java.util.Collections;
import java.util.Map;

public class OperationBuilderOptions {
    public static final OperationBuilderOptions DEFAULT = OperationBuilderOptions.custom().build();
    private final MutationMode mutationMode;
    private final Map<String, String> federationServices;
    private final int soTypeOptimizationThreshold;
    private final boolean singleSoTypeOptimizationEnabled;
    private final int inThreshold;
    private final boolean forceLateralQueries;
    private final boolean disableSinglePropertiesOptimization;

    private OperationBuilderOptions(Builder builder) {
        this.mutationMode = builder.getMutationMode();
        this.federationServices = builder.getFederationServices();
        this.soTypeOptimizationThreshold = builder.getSoTypeOptimizationThreshold();
        this.singleSoTypeOptimizationEnabled = builder.isSingleSoTypeOptimizationEnabled();
        this.inThreshold = builder.getInThreshold();
        this.forceLateralQueries = !builder.isDisableLateralOptimization();
        this.disableSinglePropertiesOptimization = builder.isDisableSinglePropertiesOptimization();
    }

    public MutationMode getMutationMode() {
        return this.mutationMode;
    }

    public Map<String, String> getFederationServices() {
        return this.federationServices;
    }

    public int getSoTypeOptimizationThreshold() {
        return this.soTypeOptimizationThreshold;
    }

    public boolean isSingleSoTypeOptimizationEnabled() {
        return this.singleSoTypeOptimizationEnabled;
    }

    public int getInThreshold() {
        return this.inThreshold;
    }

    public boolean isForceLateralQueries() {
        return this.forceLateralQueries;
    }

    public boolean isDisableSinglePropertiesOptimization() {
        return this.disableSinglePropertiesOptimization;
    }

    public static Builder custom() {
        return new Builder();
    }

    public static class Builder {
        private MutationMode mutationMode = MutationMode.DEFAULT;
        private Map<String, String> federationServices = Collections.emptyMap();
        private int soTypeOptimizationThreshold = 2;
        private boolean singleSoTypeOptimizationEnabled = true;
        private int inThreshold = 1000;
        private boolean disableLateralOptimization = false;
        private boolean disableSinglePropertiesOptimization = false;

        private Builder() {
        }

        public Builder setMutationMode(MutationMode mutationMode) {
            this.mutationMode = mutationMode;
            return this;
        }

        public MutationMode getMutationMode() {
            if (this.mutationMode == null || this.mutationMode == MutationMode.DEFAULT) {
                return MutationMode.READ_WRITE;
            }
            return this.mutationMode;
        }

        public Map<String, String> getFederationServices() {
            return this.federationServices;
        }

        public Builder setFederationServices(Map<String, String> federationServices) {
            this.federationServices = federationServices;
            return this;
        }

        public Builder setSoTypeOptimizationThreshold(int soTypeOptimizationThreshold) {
            this.soTypeOptimizationThreshold = soTypeOptimizationThreshold;
            return this;
        }

        public int getSoTypeOptimizationThreshold() {
            return this.soTypeOptimizationThreshold;
        }

        public Builder setSingleSoTypeOptimizationEnabled(boolean singleSoTypeOptimizationEnabled) {
            this.singleSoTypeOptimizationEnabled = singleSoTypeOptimizationEnabled;
            return this;
        }

        public boolean isSingleSoTypeOptimizationEnabled() {
            return this.singleSoTypeOptimizationEnabled;
        }

        public Builder setInThreshold(int inThreshold) {
            this.inThreshold = inThreshold;
            return this;
        }

        public int getInThreshold() {
            return this.inThreshold;
        }

        public Builder setDisableLateralOptimization(boolean disableLateralOptimization) {
            this.disableLateralOptimization = disableLateralOptimization;
            return this;
        }

        public boolean isDisableLateralOptimization() {
            return this.disableLateralOptimization;
        }

        public OperationBuilderOptions build() {
            return new OperationBuilderOptions(this);
        }

        public boolean isDisableSinglePropertiesOptimization() {
            return this.disableSinglePropertiesOptimization;
        }

        public Builder setDisableSinglePropertiesOptimization(boolean disableSinglePropertiesOptimization) {
            this.disableSinglePropertiesOptimization = disableSinglePropertiesOptimization;
            return this;
        }
    }

    public static enum MutationMode {
        DEFAULT(true, true, false),
        APPEND_ONLY(false, false, true),
        READ_WRITE(true, true, false),
        READ_ONLY(false, false, false),
        CHANGES(true, true, true);

        private final boolean allowIdChange;
        private final boolean allowCustomGraph;
        private final boolean writeInEntityGraph;

        private MutationMode(boolean allowIdChange, boolean allowCustomGraph, boolean writeInEntityGraph) {
            this.allowIdChange = allowIdChange;
            this.allowCustomGraph = allowCustomGraph;
            this.writeInEntityGraph = writeInEntityGraph;
        }

        public boolean allowIdChange() {
            return this.allowIdChange;
        }

        public boolean allowCustomGraph() {
            return this.allowCustomGraph;
        }

        public boolean allowEntityGraph() {
            return this.writeInEntityGraph;
        }
    }
}

