/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.soaas.common.rdf;

import com.ontotext.soaas.common.rdf.EntityPool;
import com.ontotext.soaas.common.rdf.LongTriple;
import com.ontotext.soaas.common.rdf.RdfTree;
import com.ontotext.soaas.common.rdf.Triple;
import com.ontotext.soaas.common.rdf.ValueReader;
import java.util.Collection;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.eclipse.rdf4j.model.Statement;

public interface RdfData {
    public int add(String var1, String var2, Object var3);

    public int add(long var1, long var3, long var5);

    default public int add(Statement statement) {
        return this.add(statement.getSubject().stringValue(), statement.getPredicate().stringValue(), statement.getObject());
    }

    public boolean remove(String var1, String var2, Object var3);

    public boolean remove(long var1, long var3, long var5);

    default public Collection<String> getResultIris(String queryName) {
        return this.getTriples("http://www.ontotext.com/semantic-object/result/", queryName == null ? null : "http://www.ontotext.com/semantic-object/result/" + queryName, null).stream().map(Triple::getObject).map(Object::toString).collect(Collectors.toList());
    }

    default public Collection<String> getQueries() {
        return this.getTriples("http://www.ontotext.com/semantic-object/result/", null, null).stream().map(Triple::getPredicate).distinct().map(Object::toString).map(pred -> pred.replaceFirst("http://www.ontotext.com/semantic-object/result/", "")).collect(Collectors.toList());
    }

    default public Collection<Triple> getAllTriples() {
        return this.getTriples(null, null, null);
    }

    default public RdfData merge(RdfData other) {
        other.forEach(triple -> this.add(triple.getSubject(), triple.getPredicate(), triple.getObject()));
        return this;
    }

    public Collection<Triple> getTriples(String var1, String var2, Object var3);

    public Collection<LongTriple> getTriples(long var1, long var3, long var5);

    default public boolean contains(long subject, long predicate, long object) {
        return !this.getTriples(subject, predicate, object).isEmpty();
    }

    default public boolean contains(String subject, String predicate, Object object) {
        EntityPool pool = this.getPool();
        long subjectId = pool.resolve(subject);
        long predicateId = pool.resolve(predicate);
        long objectId = pool.resolve(object);
        return this.contains(subjectId, predicateId, objectId);
    }

    public void forEach(Consumer<Triple> var1);

    public Map<String, Collection<Object>> get(String var1);

    public Collection<Object> get(String var1, String var2);

    public boolean isEmpty();

    public void setValueReader(ValueReader var1);

    public ValueReader getValueReader();

    public EntityPool getPool();

    public RdfTree toTree();

    public static class Constants {
        public static final String RES = "http://www.ontotext.com/semantic-object/result/";

        private Constants() {
        }
    }
}

