/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.soaas.common.rdf;

import com.ontotext.soaas.common.rdf.DistinctLongList;
import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.collections.api.LazyLongIterable;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function0;
import org.eclipse.collections.api.block.function.primitive.LongToObjectFunction;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.block.procedure.primitive.LongObjectProcedure;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.api.map.primitive.LongObjectMap;
import org.eclipse.collections.api.tuple.primitive.LongObjectPair;
import org.eclipse.collections.impl.iterator.UnmodifiableLongIterator;
import org.eclipse.collections.impl.lazy.AbstractLazyIterable;
import org.eclipse.collections.impl.lazy.primitive.AbstractLazyLongIterable;
import org.eclipse.collections.impl.map.mutable.primitive.LongObjectHashMap;
import org.eclipse.collections.impl.tuple.primitive.PrimitiveTuples;

public class OrderedLongObjectMap<V>
extends LongObjectHashMap<V> {
    private static final int DEFAULT_INITIAL_CAPACITY = 8;
    private final transient MutableLongList keysOrder;

    public OrderedLongObjectMap() {
        this.keysOrder = new DistinctLongList();
    }

    public OrderedLongObjectMap(int initialCapacity) {
        super(initialCapacity);
        this.keysOrder = new DistinctLongList(initialCapacity);
    }

    public OrderedLongObjectMap(LongObjectMap<? extends V> map) {
        this(Math.max(map.size(), 8));
        this.putAll(map);
    }

    public V put(long key, V value) {
        this.keysOrder.add(key);
        return (V)super.put(key, value);
    }

    public void putAll(LongObjectMap<? extends V> map) {
        this.keysOrder.addAll((LongIterable)map.keysView());
        super.putAll(map);
    }

    public V getIfAbsentPut(long key, V value) {
        this.keysOrder.add(key);
        return (V)super.getIfAbsentPut(key, value);
    }

    public V getIfAbsentPut(long key, Function0<? extends V> function) {
        this.keysOrder.add(key);
        return (V)super.getIfAbsentPut(key, function);
    }

    public <P> V getIfAbsentPutWith(long key, Function<? super P, ? extends V> function, P parameter) {
        this.keysOrder.add(key);
        return (V)super.getIfAbsentPutWith(key, function, parameter);
    }

    public V getIfAbsentPutWithKey(long key, LongToObjectFunction<? extends V> function) {
        this.keysOrder.add(key);
        return (V)super.getIfAbsentPutWithKey(key, function);
    }

    public void forEachKey(LongProcedure procedure) {
        this.keysOrder.forEach(procedure);
    }

    public void forEachKeyValue(LongObjectProcedure<? super V> procedure) {
        this.keysOrder.forEach((LongProcedure & Serializable)each -> procedure.value(each, this.get(each)));
    }

    public LazyLongIterable keysView() {
        return new KeysView();
    }

    public RichIterable<LongObjectPair<V>> keyValuesView() {
        return new KeyValuesView();
    }

    public V putPair(LongObjectPair<V> keyValuePair) {
        this.keysOrder.add(keyValuePair.getOne());
        return (V)super.putPair(keyValuePair);
    }

    public V remove(long key) {
        return this.removeKey(key);
    }

    public V removeKey(long key) {
        this.keysOrder.remove(key);
        return (V)super.removeKey(key);
    }

    private class KeysView
    extends AbstractLazyLongIterable {
        private KeysView() {
        }

        public LongIterator longIterator() {
            return new UnmodifiableLongIterator((LongIterator)OrderedLongObjectMap.this.keysOrder.longIterator());
        }

        public void forEach(LongProcedure procedure) {
            this.each(procedure);
        }

        public void each(LongProcedure procedure) {
            OrderedLongObjectMap.this.forEachKey(procedure);
        }
    }

    private class KeyValuesView
    extends AbstractLazyIterable<LongObjectPair<V>> {
        private KeyValuesView() {
        }

        public void each(Procedure<? super LongObjectPair<V>> procedure) {
            for (int i = 0; i < OrderedLongObjectMap.this.keysOrder.size(); ++i) {
                long key = OrderedLongObjectMap.this.keysOrder.get(i);
                procedure.value((Object)PrimitiveTuples.pair((long)key, (Object)OrderedLongObjectMap.this.get(key)));
            }
        }

        public void forEachWithIndex(ObjectIntProcedure<? super LongObjectPair<V>> objectIntProcedure) {
            int index = 0;
            for (int i = 0; i < OrderedLongObjectMap.this.keysOrder.size(); ++i) {
                long key = OrderedLongObjectMap.this.keysOrder.get(i);
                objectIntProcedure.value((Object)PrimitiveTuples.pair((long)key, (Object)OrderedLongObjectMap.this.get(key)), index);
                ++index;
            }
        }

        public <P> void forEachWith(Procedure2<? super LongObjectPair<V>, ? super P> procedure, P parameter) {
            for (int i = 0; i < OrderedLongObjectMap.this.keysOrder.size(); ++i) {
                long key = OrderedLongObjectMap.this.keysOrder.get(i);
                procedure.value((Object)PrimitiveTuples.pair((long)key, (Object)OrderedLongObjectMap.this.get(key)), parameter);
            }
        }

        public Iterator<LongObjectPair<V>> iterator() {
            return new InternalKeyValuesIterator();
        }

        public class InternalKeyValuesIterator
        implements Iterator<LongObjectPair<V>> {
            private int count;

            @Override
            public LongObjectPair<V> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("next() called, but the iterator is exhausted");
                }
                long key = OrderedLongObjectMap.this.keysOrder.get(this.count);
                Object value = OrderedLongObjectMap.this.get(key);
                LongObjectPair result = PrimitiveTuples.pair((long)key, (Object)value);
                ++this.count;
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
            }

            @Override
            public boolean hasNext() {
                return this.count != OrderedLongObjectMap.this.keysOrder.size();
            }
        }
    }
}

