/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.soaas.common.rdf;

import com.ontotext.soaas.common.rdf.EntityPool;
import com.ontotext.soaas.common.rdf.LongTriple;
import com.ontotext.soaas.common.rdf.Triple;
import java.util.Objects;

public class LazyTriple
implements Triple {
    private final long subject;
    private final long predicate;
    private final long object;
    private final EntityPool pool;

    public LazyTriple(LongTriple triple) {
        this(triple.getSubject(), triple.getPredicate(), triple.getObject(), triple.getPool());
    }

    public LazyTriple(long subject, long predicate, long object, EntityPool pool) {
        this.subject = subject;
        this.predicate = predicate;
        this.object = object;
        this.pool = pool;
    }

    @Override
    public String getSubject() {
        return this.pool.getString(this.subject);
    }

    @Override
    public String getPredicate() {
        return this.pool.getString(this.predicate);
    }

    @Override
    public Object getObject() {
        return this.pool.get(this.object);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof LazyTriple && this.pool == ((LazyTriple)obj).pool) {
            LazyTriple that = (LazyTriple)obj;
            return this.subject == that.subject && this.predicate == that.predicate && this.object == that.object;
        }
        if (obj instanceof Triple) {
            Triple that = (Triple)obj;
            return Objects.equals(this.getSubject(), that.getSubject()) && Objects.equals(this.getPredicate(), that.getPredicate()) && Objects.equals(this.getObject(), that.getObject());
        }
        return false;
    }

    public int hashCode() {
        int result = (int)(this.subject ^ this.subject >>> 32);
        result = 31 * result + (int)(this.predicate ^ this.predicate >>> 32);
        result = 31 * result + (int)(this.object ^ this.object >>> 32);
        result = 31 * result + this.pool.hashCode();
        return result;
    }

    public String toString() {
        return "<" + this.pool.getString(this.subject) + "> <" + this.pool.getString(this.predicate) + "> <" + this.pool.getString(this.object) + ">";
    }
}

